/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.ActionShortcutProvider;
import com.intellij.ide.util.FileStructureNodeProvider;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.ide.util.treeView.smartTree.ActionPresentationData;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLAlias;
import org.jetbrains.yaml.psi.YAMLAnchor;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.resolve.YAMLAliasReference;
import org.jetbrains.yaml.structureView.DuplicatedPsiTreeElementBase;
import org.jetbrains.yaml.structureView.YAMLStructureViewFactory;

public class YAMLAliasResolveNodeProvider
implements FileStructureNodeProvider<StructureViewTreeElement>,
ActionShortcutProvider {
    @NonNls
    public static final String ID = "YAML_SHOW_RESOLVED_ALIAS_VALUES";

    @NotNull
    public String getCheckBoxText() {
        String string = YAMLBundle.message("YAMLAliasResolveNodeProvider.action.name", new Object[0]);
        if (string == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public Shortcut @NotNull [] getShortcut() {
        throw new IncorrectOperationException("see getActionIdForShortcut()");
    }

    @NotNull
    public String getActionIdForShortcut() {
        return "FileStructurePopup";
    }

    @NotNull
    public Collection<StructureViewTreeElement> provideNodes(@NotNull TreeElement node) {
        String details;
        Object psiElem;
        DuplicatedPsiTreeElementBase yamlNode;
        if (node == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(1);
        }
        if (node instanceof DuplicatedPsiTreeElementBase) {
            yamlNode = (DuplicatedPsiTreeElementBase)node;
            psiElem = yamlNode.getElement();
            details = yamlNode.getDetails();
        } else if (node instanceof PsiTreeElementBase) {
            yamlNode = (PsiTreeElementBase)node;
            psiElem = yamlNode.getElement();
            if (psiElem == null) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    YAMLAliasResolveNodeProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
            details = YAMLAliasResolveNodeProvider.calculateStartPath(psiElem);
        } else {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                YAMLAliasResolveNodeProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        YAMLPsiElement yamlElem = psiElem instanceof YAMLPsiElement ? (YAMLPsiElement)psiElem : null;
        YAMLValue value = YAMLAliasResolveNodeProvider.getContainedValue(yamlElem);
        if (!(value instanceof YAMLAlias)) {
            List<StructureViewTreeElement> list = Collections.emptyList();
            if (list == null) {
                YAMLAliasResolveNodeProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection<StructureViewTreeElement> collection = YAMLStructureViewFactory.createChildrenViewTreeElements(YAMLAliasResolveNodeProvider.resolveAlias((YAMLAlias)value), details);
        if (collection == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public ActionPresentation getPresentation() {
        return new ActionPresentationData(YAMLBundle.message("YAMLAliasResolveNodeProvider.action.name", new Object[0]), YAMLBundle.message("YAMLAliasResolveNodeProvider.action.description", new Object[0]), YAMLStructureViewFactory.ALIAS_ICON);
    }

    @NotNull
    public String getName() {
        return ID;
    }

    @Nullable
    private static YAMLValue resolveAlias(@NotNull YAMLAlias alias) {
        YAMLAliasReference ref;
        if (alias == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(6);
        }
        YAMLAnchor anchor = (ref = alias.getReference()) == null ? null : ref.resolve();
        return anchor != null ? anchor.getMarkedValue() : null;
    }

    @Nullable
    @Contract(value="null -> null")
    private static YAMLValue getContainedValue(@Nullable YAMLPsiElement element) {
        if (element == null) {
            return null;
        }
        final Ref result = Ref.create();
        element.accept(new YamlPsiElementVisitor(){

            @Override
            public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                if (keyValue == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.set((Object)keyValue.getValue());
            }

            @Override
            public void visitSequenceItem(@NotNull YAMLSequenceItem sequenceItem) {
                if (sequenceItem == null) {
                    1.$$$reportNull$$$0(1);
                }
                result.set((Object)sequenceItem.getValue());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "keyValue";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sequenceItem";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/yaml/structureView/YAMLAliasResolveNodeProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitKeyValue";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSequenceItem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (YAMLValue)result.get();
    }

    @NotNull
    private static String calculateStartPath(@NotNull PsiElement psiElem) {
        if (psiElem == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(7);
        }
        if (!(psiElem instanceof YAMLPsiElement)) {
            return "";
        }
        String string = YAMLUtil.getConfigFullName((YAMLPsiElement)psiElem);
        if (string == null) {
            YAMLAliasResolveNodeProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/structureView/YAMLAliasResolveNodeProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckBoxText";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/structureView/YAMLAliasResolveNodeProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "provideNodes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateStartPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "provideNodes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveAlias";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateStartPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

