/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/internal/statistic/utils/StatisticsUtil;", "", "()V", "kilo", "", "mega", "getCountingStepName", "", "value", "steps", "", "getNextPowerOfTwo", "getProjectId", "project", "Lcom/intellij/openapi/project/Project;", "humanize", "number", "intellij.platform.statistics"})
public final class StatisticsUtil {
    private static final int kilo = 1000;
    private static final int mega = 1000000;
    public static final StatisticsUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getProjectId(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return EventLogConfiguration.INSTANCE.anonymize(ProjectUtil.getProjectCacheFileName$default((Project)project, (boolean)false, null, null, (int)7, null));
    }

    @JvmStatic
    public static final int getNextPowerOfTwo(int value) {
        return value <= 1 ? 1 : Integer.highestOneBit(value - 1) << 1;
    }

    @NotNull
    public final String getCountingStepName(int value, @NotNull List<Integer> steps) {
        int stepIndex;
        Intrinsics.checkParameterIsNotNull(steps, (String)"steps");
        if (steps.isEmpty()) {
            return String.valueOf(value);
        }
        if (value < ((Number)steps.get(0)).intValue()) {
            return "<" + ((Number)steps.get(0)).intValue();
        }
        for (stepIndex = 0; stepIndex < steps.size() - 1 && value >= ((Number)steps.get(stepIndex + 1)).intValue(); ++stepIndex) {
        }
        int step = ((Number)steps.get(stepIndex)).intValue();
        boolean addPlus = stepIndex == steps.size() - 1 || ((Number)steps.get(stepIndex + 1)).intValue() != step + 1;
        return this.humanize(step) + (addPlus ? "+" : "");
    }

    private final String humanize(int number) {
        if (number == 0) {
            return "0";
        }
        int m = number / 1000000;
        int k = number % 1000000 / 1000;
        int r = number % 1000;
        String ms = m > 0 ? "" + m + 'M' : "";
        String ks = k > 0 ? "" + k + 'K' : "";
        String rs = r > 0 ? String.valueOf(r) : "";
        return ms + ks + rs;
    }

    private StatisticsUtil() {
    }

    static {
        StatisticsUtil statisticsUtil;
        INSTANCE = statisticsUtil = new StatisticsUtil();
    }
}

