/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.NullableConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.psi.MarkdownRecursiveElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuoteImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeaderImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraphImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableImpl;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    public static final Map<IElementType, String> TYPES_PRESENTATION_MAP = new HashMap<IElementType, String>();

    protected void buildLanguageFoldRegions(final @NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, final @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (root.getLanguage() != root.getContainingFile().getViewProvider().getBaseLanguage()) {
            return;
        }
        root.accept((PsiElementVisitor)new MarkdownElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitElement(element);
                element.acceptChildren((PsiElementVisitor)this);
            }

            @Override
            public void visitList(@NotNull MarkdownListImpl list) {
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.addDescriptors(list);
                super.visitList(list);
            }

            @Override
            public void visitParagraph(@NotNull MarkdownParagraphImpl paragraph) {
                PsiElement parent;
                if (paragraph == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((parent = paragraph.getParent()) instanceof MarkdownBlockQuoteImpl && PsiTreeUtil.findChildrenOfType((PsiElement)parent, MarkdownParagraphImpl.class).size() <= 1) {
                    return;
                }
                this.addDescriptors(paragraph);
                super.visitParagraph(paragraph);
            }

            @Override
            public void visitTable(@NotNull MarkdownTableImpl table) {
                if (table == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.addDescriptors(table);
                super.visitTable(table);
            }

            @Override
            public void visitBlockQuote(@NotNull MarkdownBlockQuoteImpl blockQuote) {
                if (blockQuote == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.addDescriptors(blockQuote);
                super.visitBlockQuote(blockQuote);
            }

            @Override
            public void visitCodeFence(@NotNull MarkdownCodeFenceImpl codeFence) {
                if (codeFence == null) {
                    1.$$$reportNull$$$0(5);
                }
                this.addDescriptors(codeFence);
                super.visitCodeFence(codeFence);
            }

            private void addDescriptors(@NotNull MarkdownPsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(6);
                }
                MarkdownFoldingBuilder.addDescriptors(element, element.getTextRange(), descriptors, document);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "paragraph";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "blockQuote";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "codeFence";
                        break;
                    }
                }
                objectArray2[1] = "org/intellij/plugins/markdown/folding/MarkdownFoldingBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitList";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitParagraph";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTable";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitBlockQuote";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCodeFence";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addDescriptors";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        root.accept((PsiElementVisitor)new MarkdownRecursiveElementVisitor(){

            @Override
            public void visitHeader(@NotNull MarkdownHeaderImpl header) {
                if (header == null) {
                    2.$$$reportNull$$$0(0);
                }
                MarkdownPsiUtil.processContainer((PsiElement)header, (Consumer<? super PsiElement>)((Consumer)endHeader -> {}), (NullableConsumer<? super PsiElement>)((NullableConsumer)endHeader -> {
                    PsiElement lastFileChild = header.getContainingFile().getLastChild().getLastChild();
                    PsiElement prevEndFolding = endHeader == null ? (PsiUtilCore.getElementType((PsiElement)lastFileChild) == MarkdownTokenTypes.EOL ? MarkdownFoldingBuilder.skipNewLinesBackward(lastFileChild) : lastFileChild) : MarkdownFoldingBuilder.skipNewLinesBackward(endHeader);
                    if (prevEndFolding == null) {
                        return;
                    }
                    TextRange range = TextRange.create((int)header.getTextRange().getStartOffset(), (int)prevEndFolding.getTextRange().getEndOffset());
                    MarkdownFoldingBuilder.addDescriptors(header, range, descriptors, document);
                }));
                super.visitHeader(header);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "org/intellij/plugins/markdown/folding/MarkdownFoldingBuilder$2", "visitHeader"));
            }
        });
    }

    public static void addDescriptors(@NotNull MarkdownPsiElement element, @NotNull TextRange range, @NotNull List<? super FoldingDescriptor> descriptors, @NotNull Document document) {
        if (element == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (descriptors == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (document == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (document.getLineNumber(range.getStartOffset()) != document.getLineNumber(range.getEndOffset() - 1)) {
            descriptors.add((FoldingDescriptor)new FoldingDescriptor((PsiElement)element, range));
        }
    }

    @Nullable
    public static PsiElement skipNewLinesBackward(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (e.getNode().getElementType() == MarkdownTokenTypes.EOL) continue;
            return e;
        }
        return null;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        IElementType elementType;
        String explicitName;
        if (node == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (range == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(8);
        }
        String prefix = (explicitName = TYPES_PRESENTATION_MAP.get(elementType = PsiUtilCore.getElementType((ASTNode)node))) != null ? explicitName + ": " : "";
        return prefix + StringUtil.shortenTextWithEllipsis((String)node.getText(), (int)30, (int)5);
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            MarkdownFoldingBuilder.$$$reportNull$$$0(9);
        }
        return false;
    }

    static {
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.ATX_1, MarkdownBundle.message("markdown.folding.atx.1.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.ATX_2, MarkdownBundle.message("markdown.folding.atx.2.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.ATX_3, MarkdownBundle.message("markdown.folding.atx.3.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.ATX_4, MarkdownBundle.message("markdown.folding.atx.4.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.ATX_5, MarkdownBundle.message("markdown.folding.atx.5.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.ATX_6, MarkdownBundle.message("markdown.folding.atx.6.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.ORDERED_LIST, MarkdownBundle.message("markdown.folding.ordered.list.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.UNORDERED_LIST, MarkdownBundle.message("markdown.folding.unordered.list.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.BLOCK_QUOTE, MarkdownBundle.message("markdown.folding.block.quote.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.TABLE, MarkdownBundle.message("markdown.folding.table.name", new Object[0]));
        TYPES_PRESENTATION_MAP.put(MarkdownElementTypes.CODE_FENCE, MarkdownBundle.message("markdown.folding.code.fence.name", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/folding/MarkdownFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addDescriptors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

