/*
 * Decompiled with CFR 0.152.
 */
package com.github.marschall.memoryfilesystem;

import com.github.marschall.memoryfilesystem.AbstractPath;
import com.github.marschall.memoryfilesystem.CompositeList;
import com.github.marschall.memoryfilesystem.ElementPath;
import com.github.marschall.memoryfilesystem.MemoryFileSystem;
import java.io.IOException;
import java.net.URI;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class SingletonPath
extends ElementPath {
    private final String fileName;

    SingletonPath(MemoryFileSystem fileSystem, String fileName) {
        super(fileSystem);
        this.fileName = fileName;
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    public Path getRoot() {
        return null;
    }

    @Override
    public Path getFileName() {
        return this;
    }

    @Override
    public Path getParent() {
        return null;
    }

    @Override
    public int getNameCount() {
        return 1;
    }

    @Override
    public Path getName(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("index must be 0 but was " + index);
        }
        return this;
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex != 0) {
            throw new IllegalArgumentException("begin index must be 1");
        }
        if (endIndex != 1) {
            throw new IllegalArgumentException("end index must be 1");
        }
        return this;
    }

    @Override
    public boolean startsWith(String other) {
        AbstractPath path = this.getMemoryFileSystem().getPath(other, new String[0]);
        return this.isEqualPath(path);
    }

    @Override
    public boolean endsWith(String other) {
        AbstractPath path = this.getMemoryFileSystem().getPath(other, new String[0]);
        return this.isEqualPath(path);
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public URI toUri() {
        return this.toAbsolutePath().toUri();
    }

    @Override
    public Path toAbsolutePath() {
        return this.getMemoryFileSystem().getDefaultPath().resolve(this);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.getMemoryFileSystem().toRealPath(this, options);
    }

    @Override
    public Iterator<Path> iterator() {
        return Collections.singleton(this).iterator();
    }

    @Override
    List<String> getNameElements() {
        return Collections.singletonList(this.fileName);
    }

    @Override
    String getNameElement(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("index must be 0 but was " + index);
        }
        return this.fileName;
    }

    @Override
    String getLastNameElement() {
        return this.fileName;
    }

    @Override
    int compareToNonRoot(ElementPath other) {
        if (other.isAbsolute()) {
            return 1;
        }
        if (other.getNameCount() == 0) {
            return 1;
        }
        Collator collator = this.getMemoryFileSystem().getCollator();
        int comparison = collator.compare(this.fileName, other.getNameElement(0));
        if (comparison != 0) {
            return comparison;
        }
        if (other.getNameCount() > 1) {
            return -1;
        }
        return 0;
    }

    @Override
    boolean startsWith(AbstractPath other) {
        return this.isEqualPath(other);
    }

    @Override
    boolean endsWith(AbstractPath other) {
        return this.isEqualPath(other);
    }

    private boolean isEqualPath(AbstractPath other) {
        if (other.isAbsolute()) {
            return false;
        }
        if (other.isRoot()) {
            return false;
        }
        if (other instanceof ElementPath) {
            ElementPath otherPath = (ElementPath)other;
            if (otherPath.getNameCount() != 1) {
                return false;
            }
            Collator collator = this.getMemoryFileSystem().getCollator();
            return collator.equals(this.fileName, otherPath.getLastNameElement());
        }
        throw new IllegalArgumentException("can't check for #startsWith against " + other);
    }

    @Override
    Path resolve(ElementPath other) {
        List<String> newNameElement = CompositeList.create(this.getNameElements(), other.getNameElements());
        return AbstractPath.createRelative(this.getMemoryFileSystem(), newNameElement);
    }

    @Override
    Path resolveSibling(AbstractPath other) {
        return other;
    }

    @Override
    boolean isRoot() {
        return false;
    }

    @Override
    Path relativize(AbstractPath other) {
        if (other.isAbsolute()) {
            throw new IllegalArgumentException("can only relativize a relative path against a relative path");
        }
        if (other instanceof ElementPath) {
            ElementPath otherPath = (ElementPath)other;
            if (otherPath.startsWith(this)) {
                if (otherPath.getNameCount() == 1) {
                    return this.getMemoryFileSystem().getEmptyPath();
                }
                return other.subpath(1, otherPath.getNameCount());
            }
            List<String> newNameElement = CompositeList.create(Collections.singletonList(".."), otherPath.getNameElements());
            return AbstractPath.createRelative(this.getMemoryFileSystem(), newNameElement);
        }
        throw new IllegalArgumentException("unsupported path argument");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SingletonPath)) {
            return false;
        }
        SingletonPath other = (SingletonPath)obj;
        MemoryFileSystem memoryFileSystem = this.getMemoryFileSystem();
        return memoryFileSystem.equals(other.getMemoryFileSystem()) && memoryFileSystem.getCollator().equals(this.fileName, other.fileName);
    }

    @Override
    public int hashCode() {
        MemoryFileSystem memoryFileSystem = this.getMemoryFileSystem();
        Collator collator = memoryFileSystem.getCollator();
        CollationKey collationKey = collator.getCollationKey(this.fileName);
        int result = 17;
        result = 31 * result + memoryFileSystem.hashCode();
        result = 31 * result + Arrays.hashCode(collationKey.toByteArray());
        return result;
    }

    @Override
    public String toString() {
        return this.fileName;
    }
}

