/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPhaseListener;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.Weigher;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionServiceImpl
extends BaseCompletionService {
    private static final Logger LOG = Logger.getInstance(CompletionServiceImpl.class);
    private static volatile CompletionPhase ourPhase = CompletionPhase.NoCompletion;
    private static boolean ourTracePhases;
    private static Throwable ourPhaseTrace;

    public CompletionServiceImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                CompletionProgressIndicator indicator;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((indicator = CompletionServiceImpl.getCurrentCompletionProgressIndicator()) != null && indicator.getProject() == project) {
                    indicator.closeAndFinish(true);
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                } else if (indicator == null) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$1", "projectClosing"));
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(0);
                }
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$2", "beforePluginUnload"));
            }
        });
    }

    public static CompletionServiceImpl getCompletionService() {
        return (CompletionServiceImpl)CompletionService.getCompletionService();
    }

    @Override
    public void setAdvertisementText(@Nullable String text) {
        if (text == null) {
            return;
        }
        CompletionProgressIndicator completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (completion != null) {
            completion.addAdvertisement(text, null);
        }
    }

    @Override
    protected CompletionResultSet createResultSet(@NotNull CompletionParameters parameters2, @NotNull Consumer<? super CompletionResult> consumer, @NotNull CompletionContributor contributor, @NotNull PrefixMatcher matcher) {
        if (parameters2 == null) {
            CompletionServiceImpl.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            CompletionServiceImpl.$$$reportNull$$$0(1);
        }
        if (contributor == null) {
            CompletionServiceImpl.$$$reportNull$$$0(2);
        }
        if (matcher == null) {
            CompletionServiceImpl.$$$reportNull$$$0(3);
        }
        return new CompletionResultSetImpl(consumer, matcher, contributor, parameters2, null, null);
    }

    @Override
    public CompletionProcess getCurrentCompletion() {
        CompletionProgressIndicator indicator = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        return indicator != null ? indicator : this.myApiCompletionProcess;
    }

    public static CompletionProgressIndicator getCurrentCompletionProgressIndicator() {
        if (CompletionServiceImpl.isPhase(CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.CommittingDocuments.class, CompletionPhase.Synchronous.class)) {
            return CompletionServiceImpl.ourPhase.indicator;
        }
        return null;
    }

    @SafeVarargs
    public static void assertPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(4);
        }
        if (!CompletionServiceImpl.isPhase(possibilities)) {
            CompletionServiceImpl.reportPhase();
        }
    }

    private static void reportPhase() {
        LOG.error(ourPhase + (ourPhaseTrace != null ? "; set at " + ExceptionUtil.getThrowableText((Throwable)ourPhaseTrace) : ""));
        ourTracePhases = true;
    }

    @SafeVarargs
    public static boolean isPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (possibilities == null) {
            CompletionServiceImpl.$$$reportNull$$$0(5);
        }
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        for (Class<? extends CompletionPhase> possibility : possibilities) {
            if (!possibility.isInstance(phase)) continue;
            return true;
        }
        return false;
    }

    public static void setCompletionPhase(@NotNull CompletionPhase phase) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        CompletionProgressIndicator oldIndicator = oldPhase.indicator;
        if (oldIndicator != null && !(phase instanceof CompletionPhase.BgCalculation) && oldIndicator.isRunning() && !oldIndicator.isCanceled()) {
            LOG.error("don't change phase during running completion: oldPhase=" + oldPhase);
        }
        boolean wasCompletionRunning = CompletionServiceImpl.isRunningPhase(oldPhase);
        boolean isCompletionRunning = CompletionServiceImpl.isRunningPhase(phase);
        if (isCompletionRunning != wasCompletionRunning) {
            ((CompletionPhaseListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(CompletionPhaseListener.TOPIC)).completionPhaseChanged(isCompletionRunning);
        }
        Disposer.dispose((Disposable)oldPhase);
        ourPhase = phase;
        if (ourTracePhases) {
            ourPhaseTrace = new Throwable();
        }
    }

    private static boolean isRunningPhase(@NotNull CompletionPhase phase) {
        if (phase == null) {
            CompletionServiceImpl.$$$reportNull$$$0(7);
        }
        return phase != CompletionPhase.NoCompletion && !(phase instanceof CompletionPhase.ZombiePhase) && !(phase instanceof CompletionPhase.ItemsCalculated);
    }

    public static CompletionPhase getCompletionPhase() {
        return ourPhase;
    }

    @Override
    @NotNull
    protected CompletionSorterImpl addWeighersBefore(@NotNull CompletionSorterImpl sorter) {
        if (sorter == null) {
            CompletionServiceImpl.$$$reportNull$$$0(8);
        }
        CompletionSorterImpl processed2 = super.addWeighersBefore(sorter);
        CompletionSorterImpl completionSorterImpl = processed2.withClassifier(CompletionSorterImpl.weighingFactory(new LiveTemplateWeigher()));
        if (completionSorterImpl == null) {
            CompletionServiceImpl.$$$reportNull$$$0(9);
        }
        return completionSorterImpl;
    }

    @Override
    @NotNull
    protected CompletionSorterImpl processStatsWeigher(@NotNull CompletionSorterImpl sorter, @NotNull Weigher weigher2, final @NotNull CompletionLocation location) {
        if (sorter == null) {
            CompletionServiceImpl.$$$reportNull$$$0(10);
        }
        if (weigher2 == null) {
            CompletionServiceImpl.$$$reportNull$$$0(11);
        }
        if (location == null) {
            CompletionServiceImpl.$$$reportNull$$$0(12);
        }
        CompletionSorterImpl processedSorter = super.processStatsWeigher(sorter, weigher2, location);
        CompletionSorterImpl completionSorterImpl = processedSorter.withClassifier(new ClassifierFactory<LookupElement>("stats"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
            }
        });
        if (completionSorterImpl == null) {
            CompletionServiceImpl.$$$reportNull$$$0(13);
        }
        return completionSorterImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibilities";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phase";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "weigher";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "addWeighersBefore";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "processStatsWeigher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createResultSet";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "assertPhase";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPhase";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCompletionPhase";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRunningPhase";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addWeighersBefore";
                break;
            }
            case 9: 
            case 13: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processStatsWeigher";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompletionResultSetImpl
    extends BaseCompletionService.BaseCompletionResultSet {
        CompletionResultSetImpl(Consumer<? super CompletionResult> consumer, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters2, @Nullable CompletionSorter sorter, @Nullable CompletionResultSetImpl original) {
            super(consumer, prefixMatcher, contributor, parameters2, sorter, original);
        }

        public void addAllElements(@NotNull Iterable<? extends LookupElement> elements2) {
            if (elements2 == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(0);
            }
            CompletionThreadingBase.withBatchUpdate(() -> super.addAllElements(elements2), this.myParameters.getProcess());
        }

        @Override
        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(1);
            }
            if (matcher.equals(this.getPrefixMatcher())) {
                CompletionResultSetImpl completionResultSetImpl = this;
                if (completionResultSetImpl == null) {
                    CompletionResultSetImpl.$$$reportNull$$$0(2);
                }
                return completionResultSetImpl;
            }
            return new CompletionResultSetImpl((Consumer<? super CompletionResult>)this.getConsumer(), matcher, this.myContributor, this.myParameters, this.mySorter, this);
        }

        @Override
        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            if (sorter == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(3);
            }
            return new CompletionResultSetImpl((Consumer<? super CompletionResult>)this.getConsumer(), this.getPrefixMatcher(), this.myContributor, this.myParameters, sorter, this);
        }

        @Override
        public void addLookupAdvertisement(@NotNull String text) {
            if (text == null) {
                CompletionResultSetImpl.$$$reportNull$$$0(4);
            }
            CompletionServiceImpl.getCompletionService().setAdvertisementText(text);
        }

        @Override
        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProcessBase) {
                ((CompletionProcessBase)process2).addWatchedPrefix(this.myParameters.getOffset() - this.getPrefixMatcher().getPrefix().length(), prefixCondition);
            }
        }

        @Override
        public void restartCompletionWhenNothingMatches() {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProgressIndicator) {
                ((CompletionProgressIndicator)process2).getLookup().setStartCompletionWhenNothingMatches(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sorter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/completion/impl/CompletionServiceImpl$CompletionResultSetImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addAllElements";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixMatcher";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "withRelevanceSorter";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addLookupAdvertisement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

