/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ChangeLAFAnimator;
import com.intellij.ide.actions.QuickSwitchSchemeAction;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.ui.StartupUiUtil;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickChangeLookAndFeel
extends QuickSwitchSchemeAction {
    private UIManager.LookAndFeelInfo initialLaf;
    private final Alarm switchAlarm = new Alarm();

    protected void fillActions(Project project, @NotNull DefaultActionGroup group, @NotNull DataContext dataContext) {
        if (group == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(1);
        }
        LafManager lafMan = LafManager.getInstance();
        UIManager.LookAndFeelInfo[] lfs = lafMan.getInstalledLookAndFeels();
        this.initialLaf = lafMan.getCurrentLookAndFeel();
        for (UIManager.LookAndFeelInfo lf : lfs) {
            group.add((AnAction)new LafChangeAction(lf, this.initialLaf == lf));
        }
    }

    protected void showPopup(AnActionEvent e, ListPopup popup2) {
        this.switchAlarm.cancelAllRequests();
        if (Registry.is((String)"ide.instant.theme.switch")) {
            popup2.addListSelectionListener(event -> {
                JList list2 = (JList)event.getSource();
                Object item = list2.getSelectedValue();
                if (item instanceof AnActionHolder) {
                    this.switchAlarm.cancelAllRequests();
                    this.switchAlarm.addRequest(() -> {
                        LafChangeAction action2 = (LafChangeAction)((AnActionHolder)item).getAction();
                        QuickChangeLookAndFeel.switchLafAndUpdateUI(LafManager.getInstance(), action2.myLookAndFeelInfo, false);
                    }, Registry.get((String)"ide.instant.theme.switch.delay").asInteger());
                }
            });
        }
        popup2.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (Registry.is((String)"ide.instant.theme.switch") && !event.isOk()) {
                    QuickChangeLookAndFeel.switchLafAndUpdateUI(LafManager.getInstance(), QuickChangeLookAndFeel.this.initialLaf, false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/QuickChangeLookAndFeel$1", "onClosed"));
            }
        });
        super.showPopup(e, popup2);
    }

    @Nullable
    protected Condition<? super AnAction> preselectAction() {
        LafManager lafMan = LafManager.getInstance();
        return a -> ((LafChangeAction)((Object)a)).myLookAndFeelInfo == lafMan.getCurrentLookAndFeel();
    }

    public static void switchLafAndUpdateUI(@NotNull LafManager lafMan, @NotNull UIManager.LookAndFeelInfo lf, boolean async) {
        UIManager.LookAndFeelInfo cur;
        if (lafMan == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(2);
        }
        if (lf == null) {
            QuickChangeLookAndFeel.$$$reportNull$$$0(3);
        }
        if ((cur = lafMan.getCurrentLookAndFeel()) == lf) {
            return;
        }
        ChangeLAFAnimator animator = Registry.is((String)"ide.intellij.laf.enable.animation") ? ChangeLAFAnimator.showSnapshot() : null;
        boolean wasDarcula = StartupUiUtil.isUnderDarcula();
        lafMan.setCurrentLookAndFeel(lf);
        Runnable updater2 = () -> {
            Ref updated = Ref.create((Object)false);
            Disposable disposable2 = Disposer.newDisposable();
            ApplicationManager.getApplication().getMessageBus().connect(disposable2).subscribe(LafManagerListener.TOPIC, source -> updated.set((Object)true));
            try {
                if (StartupUiUtil.isUnderDarcula()) {
                    DarculaInstaller.install();
                } else if (wasDarcula) {
                    DarculaInstaller.uninstall();
                }
            }
            finally {
                Disposer.dispose((Disposable)disposable2);
                if (!((Boolean)updated.get()).booleanValue()) {
                    lafMan.updateUI();
                }
                if (animator != null) {
                    animator.hideSnapshotWithAnimation();
                }
            }
        };
        if (async) {
            SwingUtilities.invokeLater(updater2);
        } else {
            updater2.run();
        }
    }

    protected boolean isEnabled() {
        return LafManager.getInstance().getInstalledLookAndFeels().length > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lafMan";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lf";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/QuickChangeLookAndFeel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillActions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "switchLafAndUpdateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LafChangeAction
    extends DumbAwareAction {
        private final UIManager.LookAndFeelInfo myLookAndFeelInfo;

        private LafChangeAction(UIManager.LookAndFeelInfo lf, boolean currentLaf) {
            super(lf.getName(), null, LafChangeAction.getIcon(currentLaf));
            this.myLookAndFeelInfo = lf;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                LafChangeAction.$$$reportNull$$$0(0);
            }
            if (!Registry.is((String)"ide.instant.theme.switch")) {
                QuickChangeLookAndFeel.switchLafAndUpdateUI(LafManager.getInstance(), this.myLookAndFeelInfo, false);
            }
        }

        @Nullable
        private static Icon getIcon(boolean currentLaf) {
            return Registry.is((String)"ide.instant.theme.switch") ? null : (currentLaf ? AllIcons.Actions.Forward : QuickSwitchSchemeAction.ourNotCurrentAction);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/QuickChangeLookAndFeel$LafChangeAction", "actionPerformed"));
        }
    }
}

