/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.FileVisitResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsTableModel {
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    protected final List<IdeaPluginDescriptor> view = new ArrayList<IdeaPluginDescriptor>();
    private final Map<PluginId, Boolean> myEnabled = new HashMap<PluginId, Boolean>();
    private final Map<PluginId, Set<PluginId>> myDependentToRequiredListMap = new HashMap<PluginId, Set<PluginId>>();

    public InstalledPluginsTableModel() {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
            if (appInfo.isEssentialPlugin(plugin.getPluginId())) {
                this.myEnabled.put(plugin.getPluginId(), true);
                continue;
            }
            this.view.add(plugin);
        }
        this.view.addAll(ourState.getInstalledPlugins());
        for (IdeaPluginDescriptor descriptor2 : this.view) {
            this.setEnabled(descriptor2, descriptor2.isEnabled());
        }
        this.updatePluginDependencies();
    }

    public List<IdeaPluginDescriptor> getAllPlugins() {
        return new ArrayList<IdeaPluginDescriptor>(this.view);
    }

    @Nullable
    public Set<PluginId> getRequiredPlugins(PluginId pluginId) {
        return this.myDependentToRequiredListMap.get(pluginId);
    }

    public boolean isLoaded(PluginId pluginId) {
        return this.myEnabled.get(pluginId) != null;
    }

    protected void setEnabled(IdeaPluginDescriptor ideaPluginDescriptor, boolean enabled) {
        PluginId pluginId = ideaPluginDescriptor.getPluginId();
        if (!enabled && !PluginManagerCore.isDisabled(pluginId)) {
            this.myEnabled.put(pluginId, null);
        } else {
            this.myEnabled.put(pluginId, enabled);
        }
    }

    public Map<PluginId, Set<PluginId>> getDependentToRequiredListMap() {
        return this.myDependentToRequiredListMap;
    }

    protected void updatePluginDependencies() {
        this.myDependentToRequiredListMap.clear();
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = null;
        for (IdeaPluginDescriptor rootDescriptor : this.view) {
            Boolean enabled;
            PluginId pluginId = rootDescriptor.getPluginId();
            this.myDependentToRequiredListMap.remove(pluginId);
            if (rootDescriptor instanceof IdeaPluginDescriptorImpl && ((IdeaPluginDescriptorImpl)rootDescriptor).isDeleted() || (enabled = this.myEnabled.get(pluginId)) != null && !enabled.booleanValue()) continue;
            if (pluginIdMap == null) {
                pluginIdMap = PluginManagerCore.buildPluginIdMap();
            }
            if (rootDescriptor instanceof IdeaPluginDescriptorImpl) {
                PluginManagerCore.processAllDependencies((IdeaPluginDescriptorImpl)rootDescriptor, false, pluginIdMap, (depId, descriptor2) -> {
                    if (depId.equals(pluginId)) {
                        return FileVisitResult.CONTINUE;
                    }
                    Boolean enabled1 = this.myEnabled.get(depId);
                    if (enabled1 == null && !ourState.wasUpdated((PluginId)depId) || enabled1 != null && !enabled1.booleanValue()) {
                        Set<PluginId> required = this.myDependentToRequiredListMap.get(pluginId);
                        if (required == null) {
                            required = new HashSet<PluginId>();
                            this.myDependentToRequiredListMap.put(pluginId, required);
                        }
                        required.add((PluginId)depId);
                    }
                    return FileVisitResult.CONTINUE;
                });
            }
            if (enabled != null || this.myDependentToRequiredListMap.containsKey(pluginId) || !PluginManagerCore.isCompatible(rootDescriptor)) continue;
            this.myEnabled.put(pluginId, true);
        }
    }

    public void enableRows(IdeaPluginDescriptor @NotNull [] ideaPluginDescriptors, @NotNull Boolean value2) {
        if (value2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(0);
        }
        if (ideaPluginDescriptors == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(1);
        }
        HashMap<PluginId, Boolean> tempEnabled = new HashMap<PluginId, Boolean>(this.myEnabled);
        InstalledPluginsTableModel.setNewEnabled(ideaPluginDescriptors, tempEnabled, value2);
        if (this.suggestToChangeDependencies(ideaPluginDescriptors, tempEnabled, value2)) {
            for (IdeaPluginDescriptor descriptor2 : ideaPluginDescriptors) {
                this.handleBeforeChangeEnableState(descriptor2, value2);
            }
            InstalledPluginsTableModel.setNewEnabled(ideaPluginDescriptors, this.myEnabled, value2);
            this.updatePluginDependencies();
        }
    }

    private static void setNewEnabled(IdeaPluginDescriptor @NotNull [] ideaPluginDescriptors, @NotNull Map<PluginId, Boolean> enabledContainer, @NotNull Boolean value2) {
        if (enabledContainer == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(2);
        }
        if (value2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(3);
        }
        if (ideaPluginDescriptors == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(4);
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : ideaPluginDescriptors) {
            PluginId currentPluginId = ideaPluginDescriptor.getPluginId();
            Boolean enabled = enabledContainer.get(currentPluginId) == null ? Boolean.FALSE : value2;
            enabledContainer.put(currentPluginId, enabled);
        }
    }

    public boolean isEnabled(PluginId pluginId) {
        Boolean enabled = this.myEnabled.get(pluginId);
        return enabled != null && enabled != false;
    }

    public boolean isDisabled(@NotNull PluginId pluginId) {
        Boolean enabled;
        if (pluginId == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(5);
        }
        return (enabled = this.myEnabled.get(pluginId)) != null && enabled == false;
    }

    public Map<PluginId, Boolean> getEnabledMap() {
        return this.myEnabled;
    }

    private boolean suggestToChangeDependencies(IdeaPluginDescriptor @NotNull [] descriptorsWithChangedEnabledState, @NotNull Map<PluginId, Boolean> enabledContainer, @NotNull Boolean newEnabledState) {
        if (enabledContainer == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(6);
        }
        if (newEnabledState == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(7);
        }
        if (descriptorsWithChangedEnabledState == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(8);
        }
        ArrayList<IdeaPluginDescriptor> descriptorsToCheckDependencies = new ArrayList<IdeaPluginDescriptor>();
        if (newEnabledState.booleanValue()) {
            Collections.addAll(descriptorsToCheckDependencies, descriptorsWithChangedEnabledState);
        } else {
            descriptorsToCheckDependencies.addAll(this.getAllPlugins());
            descriptorsToCheckDependencies.removeAll(Arrays.asList(descriptorsWithChangedEnabledState));
            Iterator iterator2 = descriptorsToCheckDependencies.iterator();
            while (iterator2.hasNext()) {
                IdeaPluginDescriptor descriptor3 = (IdeaPluginDescriptor)iterator2.next();
                Boolean enabled = enabledContainer.get(descriptor3.getPluginId());
                if (enabled != null && enabled.booleanValue()) continue;
                iterator2.remove();
            }
        }
        HashSet deps = new HashSet();
        Map<PluginId, IdeaPluginDescriptorImpl> pluginIdMap = PluginManagerCore.buildPluginIdMap();
        for (IdeaPluginDescriptor descriptorToCheckDependencies : descriptorsToCheckDependencies) {
            if (!(descriptorToCheckDependencies instanceof IdeaPluginDescriptorImpl)) continue;
            IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)descriptorToCheckDependencies;
            PluginId pluginId2 = pluginDescriptor.getPluginId();
            PluginManagerCore.processAllDependencies(pluginDescriptor, false, pluginIdMap, (depId, descriptor2) -> {
                if (depId == pluginId2) {
                    return FileVisitResult.CONTINUE;
                }
                Boolean enabled = (Boolean)enabledContainer.get(depId);
                if (enabled == null) {
                    return FileVisitResult.TERMINATE;
                }
                if (newEnabledState.booleanValue() && !enabled.booleanValue()) {
                    deps.add(depId);
                }
                if (newEnabledState.booleanValue()) {
                    return FileVisitResult.CONTINUE;
                }
                if (pluginDescriptor.isDeleted()) {
                    return FileVisitResult.CONTINUE;
                }
                if (pluginDescriptor.isImplementationDetail()) {
                    return FileVisitResult.CONTINUE;
                }
                for (IdeaPluginDescriptor d : descriptorsWithChangedEnabledState) {
                    if (depId != d.getPluginId()) continue;
                    deps.add(pluginId2);
                    break;
                }
                return FileVisitResult.CONTINUE;
            });
        }
        if (deps.isEmpty()) {
            return true;
        }
        String listOfDependencies = StringUtil.join(deps, pluginId -> {
            IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin(pluginId);
            return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;" + (pluginDescriptor == null ? pluginId.getIdString() : pluginDescriptor.getName());
        }, (String)"<br>");
        String message = newEnabledState != false ? IdeBundle.message((String)"dialog.message.enable.required.plugins", (Object[])new Object[]{descriptorsWithChangedEnabledState.length, deps.size(), listOfDependencies}) : IdeBundle.message((String)"dialog.message.disable.dependent.plugins", (Object[])new Object[]{deps.size(), descriptorsWithChangedEnabledState.length, listOfDependencies});
        if (Messages.showOkCancelDialog((String)message, (String)(newEnabledState != false ? IdeBundle.message((String)"dialog.title.enable.required.plugins", (Object[])new Object[0]) : IdeBundle.message((String)"dialog.title.disable.dependent.plugins", (Object[])new Object[0])), (String)(newEnabledState != false ? IdeBundle.message((String)"button.enable", (Object[])new Object[0]) : IdeBundle.message((String)"button.disable", (Object[])new Object[0])), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon()) == 0) {
            for (PluginId pluginId2 : deps) {
                this.myEnabled.put(pluginId2, newEnabledState);
            }
            return true;
        }
        return false;
    }

    protected void handleBeforeChangeEnableState(@NotNull IdeaPluginDescriptor descriptor2, boolean value2) {
        if (descriptor2 == null) {
            InstalledPluginsTableModel.$$$reportNull$$$0(9);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaPluginDescriptors";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledContainer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEnabledState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsWithChangedEnabledState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/InstalledPluginsTableModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "enableRows";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setNewEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDisabled";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestToChangeDependencies";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBeforeChangeEnableState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

