/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

class EditorLocation {
    private final Editor myEditor;
    private final Point myPoint;
    private VisualPosition myVisualPosition;
    private LogicalPosition myLogicalPosition;
    private int myOffset;
    private int myVisualLineBaseY;

    EditorLocation(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            EditorLocation.$$$reportNull$$$0(0);
        }
        if (point == null) {
            EditorLocation.$$$reportNull$$$0(1);
        }
        this.myOffset = -1;
        this.myVisualLineBaseY = -1;
        this.myEditor = editor;
        this.myPoint = point;
    }

    @NotNull
    Point getPoint() {
        Point point = this.myPoint;
        if (point == null) {
            EditorLocation.$$$reportNull$$$0(2);
        }
        return point;
    }

    @NotNull
    VisualPosition getVisualPosition() {
        if (this.myVisualPosition == null) {
            this.myVisualPosition = this.myEditor.xyToVisualPosition(this.myPoint);
        }
        VisualPosition visualPosition = this.myVisualPosition;
        if (visualPosition == null) {
            EditorLocation.$$$reportNull$$$0(3);
        }
        return visualPosition;
    }

    int getVisualLineBaseY() {
        if (this.myVisualLineBaseY < 0) {
            this.myVisualLineBaseY = this.myEditor.visualLineToY(this.getVisualPosition().line);
        }
        return this.myVisualLineBaseY;
    }

    @NotNull
    LogicalPosition getLogicalPosition() {
        if (this.myLogicalPosition == null) {
            this.myLogicalPosition = this.myEditor.visualToLogicalPosition(this.getVisualPosition());
        }
        LogicalPosition logicalPosition = this.myLogicalPosition;
        if (logicalPosition == null) {
            EditorLocation.$$$reportNull$$$0(4);
        }
        return logicalPosition;
    }

    int getOffset() {
        if (this.myOffset < 0) {
            this.myOffset = this.myEditor.logicalPositionToOffset(this.getLogicalPosition());
        }
        return this.myOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/EditorLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/EditorLocation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPoint";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisualPosition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogicalPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

