/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CompositeWhiteSpaceFormattingStrategy
implements WhiteSpaceFormattingStrategy {
    private final List<WhiteSpaceFormattingStrategy> myStrategies;
    private boolean myReplaceDefaultStrategy;

    public CompositeWhiteSpaceFormattingStrategy(@NotNull Collection<? extends WhiteSpaceFormattingStrategy> strategies) throws IllegalArgumentException {
        if (strategies == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(0);
        }
        this.myStrategies = new ArrayList<WhiteSpaceFormattingStrategy>();
        for (WhiteSpaceFormattingStrategy whiteSpaceFormattingStrategy : strategies) {
            this.addStrategy(whiteSpaceFormattingStrategy);
        }
    }

    @Override
    public int check(@NotNull CharSequence text, int start2, int end) {
        if (text == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(1);
        }
        int offset = start2;
        while (offset < end) {
            WhiteSpaceFormattingStrategy strategy;
            int oldOffset = offset;
            Iterator<WhiteSpaceFormattingStrategy> iterator2 = this.myStrategies.iterator();
            while (iterator2.hasNext() && (offset = (strategy = iterator2.next()).check(text, offset, end)) <= oldOffset) {
            }
            if (offset != oldOffset) continue;
            return start2;
        }
        return offset;
    }

    @Override
    public boolean replaceDefaultStrategy() {
        return this.myReplaceDefaultStrategy;
    }

    public void addStrategy(@NotNull WhiteSpaceFormattingStrategy strategy) throws IllegalArgumentException {
        if (strategy == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(2);
        }
        if (this.myReplaceDefaultStrategy && strategy.replaceDefaultStrategy()) {
            throw new IllegalArgumentException(String.format("Can't combine strategy '%s' with already registered strategies (%s). Reason: given strategy is marked to replace all existing strategies but strategy with such characteristics is already registered", strategy, this.myStrategies));
        }
        this.myStrategies.add(strategy);
        this.myReplaceDefaultStrategy |= strategy.replaceDefaultStrategy();
    }

    @Override
    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull CharSequence text, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings, ASTNode nodeAfter) {
        if (whiteSpaceText == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(3);
        }
        if (text == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(4);
        }
        CharSequence result2 = whiteSpaceText;
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            result2 = strategy.adjustWhiteSpaceIfNecessary(result2, text, startOffset, endOffset, codeStyleSettings, nodeAfter);
        }
        CharSequence charSequence = result2;
        if (charSequence == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @Override
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, @NotNull PsiElement startElement, int startOffset, int endOffset, CodeStyleSettings codeStyleSettings) {
        if (whiteSpaceText == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(7);
        }
        CharSequence result2 = whiteSpaceText;
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            result2 = strategy.adjustWhiteSpaceIfNecessary(result2, startElement, startOffset, endOffset, codeStyleSettings);
        }
        return result2;
    }

    @Override
    public boolean containsWhitespacesOnly(@NotNull ASTNode node) {
        if (node == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(8);
        }
        for (WhiteSpaceFormattingStrategy strategy : this.myStrategies) {
            if (!strategy.containsWhitespacesOnly(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addWhitespace(@NotNull ASTNode treePrev, @NotNull LeafElement whiteSpaceElement) {
        if (treePrev == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(9);
        }
        if (whiteSpaceElement == null) {
            CompositeWhiteSpaceFormattingStrategy.$$$reportNull$$$0(10);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategies";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePrev";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/CompositeWhiteSpaceFormattingStrategy";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustWhiteSpaceIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addStrategy";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 5: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsWhitespacesOnly";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addWhitespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

