/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharSequenceSubSequence;
import org.jetbrains.annotations.NotNull;

public class LexerEditorHighlighterLexer
extends LexerBase {
    private HighlighterIterator iterator;
    private CharSequence buffer;
    private int start;
    private int end;
    private final EditorHighlighter myHighlighter;
    private final boolean myAlreadyInitializedHighlighter;

    public LexerEditorHighlighterLexer(EditorHighlighter highlighter, boolean alreadyInitializedHighlighter) {
        this.myHighlighter = highlighter;
        this.myAlreadyInitializedHighlighter = alreadyInitializedHighlighter;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int state) {
        if (buffer == null) {
            LexerEditorHighlighterLexer.$$$reportNull$$$0(0);
        }
        if (this.myAlreadyInitializedHighlighter) {
            this.buffer = buffer;
            this.start = startOffset;
            this.end = endOffset;
        } else {
            this.buffer = buffer;
            this.start = startOffset;
            this.end = endOffset;
            this.myHighlighter.setText((CharSequence)new CharSequenceSubSequence(this.buffer, this.start, this.end));
        }
        this.iterator = this.myHighlighter.createIterator(0);
    }

    public void resetPosition(int offset) {
        this.iterator = this.myHighlighter.createIterator(offset);
    }

    public int getState() {
        return 0;
    }

    public IElementType getTokenType() {
        if (this.iterator.atEnd()) {
            return null;
        }
        return this.iterator.getTokenType();
    }

    public int getTokenStart() {
        return this.iterator.getStart();
    }

    public int getTokenEnd() {
        return this.iterator.getEnd();
    }

    public void advance() {
        this.iterator.advance();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.buffer;
        if (charSequence == null) {
            LexerEditorHighlighterLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.end;
    }

    public HighlighterIterator getHighlighterIterator() {
        return this.iterator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/LexerEditorHighlighterLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/LexerEditorHighlighterLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

