/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.memory;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InMemoryIndexStorage<K, V>
implements VfsAwareIndexStorage<K, V> {
    private final Map<K, ValueContainerImpl<V>> myMap = new THashMap();

    @Override
    public boolean processKeys(@NotNull Processor<? super K> processor2, GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (processor2 == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(0);
        }
        return this.myMap.keySet().stream().allMatch(arg_0 -> processor2.process(arg_0));
    }

    public void addValue(K k, int inputId, V v) {
        this.myMap.computeIfAbsent(k, __ -> new ValueContainerImpl()).addValue(inputId, v);
    }

    public void removeAllValues(@NotNull K k, int inputId) {
        ValueContainerImpl<V> container2;
        if (k == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(1);
        }
        if ((container2 = this.myMap.get(k)) == null) {
            return;
        }
        container2.removeAssociatedValue(inputId);
        if (container2.size() == 0) {
            this.myMap.remove(k);
        }
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public ValueContainer<V> read(K k) throws StorageException {
        ValueContainer valueContainer = (ValueContainer)ObjectUtils.notNull(this.myMap.get(k), (Object)new ValueContainerImpl());
        if (valueContainer == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(2);
        }
        return valueContainer;
    }

    public void clearCaches() {
    }

    public void close() {
    }

    public void flush() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/memory/InMemoryIndexStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/memory/InMemoryIndexStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

