/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.chrome.ChromeSettings;
import com.intellij.ide.browsers.firefox.FirefoxSettings;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.SystemInfo;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BrowserFamily implements Iconable
{
    CHROME(IdeBundle.message("browsers.chrome", new Object[0]), "chrome", "google-chrome", "Google Chrome", AllIcons.Xml.Browsers.Chrome){

        @Override
        public BrowserSpecificSettings createBrowserSpecificSettings() {
            return new ChromeSettings();
        }
    }
    ,
    FIREFOX(IdeBundle.message("browsers.firefox", new Object[0]), "firefox", "firefox", "Firefox", AllIcons.Xml.Browsers.Firefox){

        @Override
        public BrowserSpecificSettings createBrowserSpecificSettings() {
            return new FirefoxSettings();
        }
    }
    ,
    EXPLORER(IdeBundle.message("browsers.explorer", new Object[0]), "iexplore", null, null, AllIcons.Xml.Browsers.Explorer),
    OPERA(IdeBundle.message("browsers.opera", new Object[0]), "opera", "opera", "Opera", AllIcons.Xml.Browsers.Opera),
    SAFARI(IdeBundle.message("browsers.safari", new Object[0]), "safari", null, "Safari", AllIcons.Xml.Browsers.Safari);

    private final String myName;
    private final String myWindowsPath;
    private final String myUnixPath;
    private final String myMacPath;
    private final Icon myIcon;

    private BrowserFamily(@Nullable String name, @Nullable String windowsPath, @NotNull String unixPath, String macPath, Icon icon) {
        if (name == null) {
            BrowserFamily.$$$reportNull$$$0(0);
        }
        if (windowsPath == null) {
            BrowserFamily.$$$reportNull$$$0(1);
        }
        if (icon == null) {
            BrowserFamily.$$$reportNull$$$0(2);
        }
        this.myName = name;
        this.myWindowsPath = windowsPath;
        this.myUnixPath = unixPath;
        this.myMacPath = macPath;
        this.myIcon = icon;
    }

    @Nullable
    public BrowserSpecificSettings createBrowserSpecificSettings() {
        return null;
    }

    @Nullable
    public String getExecutionPath() {
        if (SystemInfo.isWindows) {
            return this.myWindowsPath;
        }
        if (SystemInfo.isMac) {
            return this.myMacPath;
        }
        return this.myUnixPath;
    }

    public String getName() {
        return this.myName;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public String toString() {
        return this.myName;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return this.getIcon();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "windowsPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "icon";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/browsers/BrowserFamily";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

