/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0013\"\b\b\u0000\u0010\u0014*\u00020\u0002*\u0002H\u0014\u00a2\u0006\u0002\u0010\u0015\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\n\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\"\u0017\u0010\f\u001a\u0004\u0018\u00010\u0006*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0004\u00a8\u0006\u0016"}, d2={"endOffset", "", "Lcom/intellij/psi/PsiElement;", "getEndOffset", "(Lcom/intellij/psi/PsiElement;)I", "newRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "getNewRange", "(Lcom/intellij/openapi/editor/event/DocumentEvent;)Lcom/intellij/openapi/util/TextRange;", "oldRange", "getOldRange", "range", "Lcom/intellij/openapi/editor/RangeMarker;", "getRange", "(Lcom/intellij/openapi/editor/RangeMarker;)Lcom/intellij/openapi/util/TextRange;", "startOffset", "getStartOffset", "createSmartPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "E", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/SmartPsiElementPointer;", "intellij.platform.lang"})
public final class UtilsKt {
    @NotNull
    public static final TextRange getOldRange(@NotNull DocumentEvent $this$oldRange) {
        Intrinsics.checkParameterIsNotNull((Object)$this$oldRange, (String)"$this$oldRange");
        return new TextRange($this$oldRange.getOffset(), $this$oldRange.getOffset() + $this$oldRange.getOldLength());
    }

    @NotNull
    public static final TextRange getNewRange(@NotNull DocumentEvent $this$newRange) {
        Intrinsics.checkParameterIsNotNull((Object)$this$newRange, (String)"$this$newRange");
        return new TextRange($this$newRange.getOffset(), $this$newRange.getOffset() + $this$newRange.getNewLength());
    }

    @Nullable
    public static final TextRange getRange(@NotNull RangeMarker $this$range) {
        int end;
        Intrinsics.checkParameterIsNotNull((Object)$this$range, (String)"$this$range");
        if (!$this$range.isValid()) {
            return null;
        }
        int start = $this$range.getStartOffset();
        int n = start;
        return 0 <= n && (end = $this$range.getEndOffset()) >= n ? new TextRange(start, end) : null;
    }

    public static final int getStartOffset(@NotNull PsiElement $this$startOffset) {
        Intrinsics.checkParameterIsNotNull((Object)$this$startOffset, (String)"$this$startOffset");
        TextRange textRange = $this$startOffset.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"textRange");
        return textRange.getStartOffset();
    }

    public static final int getEndOffset(@NotNull PsiElement $this$endOffset) {
        Intrinsics.checkParameterIsNotNull((Object)$this$endOffset, (String)"$this$endOffset");
        TextRange textRange = $this$endOffset.getTextRange();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"textRange");
        return textRange.getEndOffset();
    }

    @NotNull
    public static final <E extends PsiElement> SmartPsiElementPointer<E> createSmartPointer(@NotNull E $this$createSmartPointer) {
        Intrinsics.checkParameterIsNotNull($this$createSmartPointer, (String)"$this$createSmartPointer");
        SmartPsiElementPointer<E> smartPsiElementPointer = SmartPointerManager.getInstance($this$createSmartPointer.getProject()).createSmartPsiElementPointer($this$createSmartPointer);
        Intrinsics.checkExpressionValueIsNotNull(smartPsiElementPointer, (String)"SmartPointerManager.getI\u2026rtPsiElementPointer(this)");
        return smartPsiElementPointer;
    }
}

