/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.NotNullFunction;
import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.ColorGetterByLayoutIndex;
import com.intellij.vcs.log.graph.impl.print.GraphElementComparatorByLayoutIndex;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PrintElementManagerImpl
implements PrintElementManager {
    @NotNull
    private final Comparator<GraphElement> myGraphElementComparator;
    @NotNull
    private final ColorGetterByLayoutIndex myColorGetter;
    @NotNull
    private final LinearGraph myLinearGraph;
    @NotNull
    private Selection mySelection;

    PrintElementManagerImpl(@NotNull LinearGraph linearGraph, @NotNull PermanentGraphInfo myPermanentGraph, @NotNull GraphColorManager colorManager) {
        if (linearGraph == null) {
            PrintElementManagerImpl.$$$reportNull$$$0(0);
        }
        if (myPermanentGraph == null) {
            PrintElementManagerImpl.$$$reportNull$$$0(1);
        }
        if (colorManager == null) {
            PrintElementManagerImpl.$$$reportNull$$$0(2);
        }
        this.mySelection = new Selection(this, Collections.emptySet());
        this.myLinearGraph = linearGraph;
        this.myColorGetter = new ColorGetterByLayoutIndex(linearGraph, myPermanentGraph, colorManager);
        this.myGraphElementComparator = new GraphElementComparatorByLayoutIndex((NotNullFunction<? super Integer, Integer>)((NotNullFunction)nodeIndex -> {
            int nodeId = linearGraph.getNodeId((int)nodeIndex);
            if (nodeId < 0) {
                return nodeId;
            }
            return myPermanentGraph.getPermanentGraphLayout().getLayoutIndex(nodeId);
        }));
    }

    @Override
    public boolean isSelected(@NotNull PrintElementWithGraphElement printElement) {
        if (printElement == null) {
            PrintElementManagerImpl.$$$reportNull$$$0(3);
        }
        return this.mySelection.isSelected(printElement);
    }

    boolean setSelectedElement(@NotNull PrintElementWithGraphElement printElement) {
        if (printElement == null) {
            PrintElementManagerImpl.$$$reportNull$$$0(4);
        }
        return this.setSelection(new Selection(this, printElement));
    }

    boolean setSelectedElements(@NotNull Set<Integer> selectedNodeId) {
        if (selectedNodeId == null) {
            PrintElementManagerImpl.$$$reportNull$$$0(5);
        }
        return this.setSelection(new Selection(this, selectedNodeId));
    }

    private boolean setSelection(@NotNull Selection newSelection) {
        if (newSelection == null) {
            PrintElementManagerImpl.$$$reportNull$$$0(6);
        }
        if (newSelection.equals(this.mySelection)) {
            return false;
        }
        this.mySelection = newSelection;
        return true;
    }

    @Override
    public int getColorId(@NotNull GraphElement element) {
        if (element == null) {
            PrintElementManagerImpl.$$$reportNull$$$0(7);
        }
        return this.myColorGetter.getColorId(element);
    }

    @Override
    @NotNull
    public Comparator<GraphElement> getGraphElementComparator() {
        Comparator<GraphElement> comparator = this.myGraphElementComparator;
        if (comparator == null) {
            PrintElementManagerImpl.$$$reportNull$$$0(8);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linearGraph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myPermanentGraph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodeId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphElementComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getColorId";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Selection {
        @Nullable
        private final PrintElementWithGraphElement mySelectedPrintElement;
        @NotNull
        private final Set<Integer> mySelectedNodeIds;
        final /* synthetic */ PrintElementManagerImpl this$0;

        public Selection(@NotNull PrintElementManagerImpl this$0, Set<Integer> selectedNodeId) {
            if (selectedNodeId == null) {
                Selection.$$$reportNull$$$0(0);
            }
            this(this$0, null, selectedNodeId);
        }

        public Selection(@NotNull PrintElementManagerImpl this$0, PrintElementWithGraphElement printElement) {
            if (printElement == null) {
                Selection.$$$reportNull$$$0(1);
            }
            this(this$0, printElement, Collections.emptySet());
        }

        private Selection(@Nullable PrintElementManagerImpl this$0, @NotNull PrintElementWithGraphElement printElement, Set<Integer> nodeIds) {
            if (nodeIds == null) {
                Selection.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            this.mySelectedPrintElement = printElement;
            this.mySelectedNodeIds = nodeIds;
        }

        public boolean isSelected(@NotNull PrintElementWithGraphElement printElement) {
            if (printElement == null) {
                Selection.$$$reportNull$$$0(3);
            }
            if (printElement.equals(this.mySelectedPrintElement)) {
                return true;
            }
            GraphElement graphElement = printElement.getGraphElement();
            if (graphElement instanceof GraphNode) {
                int nodeId = this.this$0.myLinearGraph.getNodeId(((GraphNode)graphElement).getNodeIndex());
                return this.mySelectedNodeIds.contains(nodeId);
            }
            if (graphElement instanceof GraphEdge) {
                GraphEdge edge = (GraphEdge)graphElement;
                boolean selected = edge.getTargetId() == null || this.mySelectedNodeIds.contains(edge.getTargetId());
                selected &= edge.getUpNodeIndex() == null || this.mySelectedNodeIds.contains(this.this$0.myLinearGraph.getNodeId(edge.getUpNodeIndex()));
                return selected &= edge.getDownNodeIndex() == null || this.mySelectedNodeIds.contains(this.this$0.myLinearGraph.getNodeId(edge.getDownNodeIndex()));
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Selection selection = (Selection)o;
            return Objects.equals(this.mySelectedPrintElement, selection.mySelectedPrintElement) && Comparing.haveEqualElements(this.mySelectedNodeIds, selection.mySelectedNodeIds);
        }

        public int hashCode() {
            return 31 * Objects.hashCode(this.mySelectedPrintElement) + Comparing.unorderedHashcode(this.mySelectedNodeIds);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedNodeId";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeIds";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/PrintElementManagerImpl$Selection";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

