/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.rel.type.DynamicRecordType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlMonotonicity;
import org.apache.calcite.sql.validate.SqlQualified;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Util;

public class SqlIdentifier
extends SqlNode {
    public ImmutableList<String> names;
    final SqlCollation collation;
    protected ImmutableList<SqlParserPos> componentPositions;

    public SqlIdentifier(List<String> names, SqlCollation collation, SqlParserPos pos, List<SqlParserPos> componentPositions) {
        super(pos);
        this.names = ImmutableList.copyOf(names);
        this.collation = collation;
        this.componentPositions = componentPositions == null ? null : ImmutableList.copyOf(componentPositions);
        for (String name : names) {
            assert (name != null);
        }
    }

    public SqlIdentifier(List<String> names, SqlParserPos pos) {
        this(names, null, pos, null);
    }

    public SqlIdentifier(String name, SqlCollation collation, SqlParserPos pos) {
        this((List<String>)ImmutableList.of((Object)name), collation, pos, null);
    }

    public SqlIdentifier(String name, SqlParserPos pos) {
        this((List<String>)ImmutableList.of((Object)name), null, pos, null);
    }

    public static SqlIdentifier star(SqlParserPos pos) {
        return SqlIdentifier.star((List<String>)ImmutableList.of((Object)""), pos, (List<SqlParserPos>)ImmutableList.of((Object)pos));
    }

    public static SqlIdentifier star(List<String> names, SqlParserPos pos, List<SqlParserPos> componentPositions) {
        return new SqlIdentifier(Lists.transform(names, s -> s.equals("*") ? "" : s), null, pos, componentPositions);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.IDENTIFIER;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlIdentifier((List<String>)this.names, this.collation, pos, (List<SqlParserPos>)this.componentPositions);
    }

    @Override
    public String toString() {
        return SqlIdentifier.getString(this.names);
    }

    public static String getString(List<String> names) {
        return Util.sepList(SqlIdentifier.toStar(names), ".");
    }

    public static List<String> toStar(List<String> names) {
        return Lists.transform(names, s -> s.equals("") ? "*" : (s.equals("*") ? "\"*\"" : s));
    }

    public void setNames(List<String> names, List<SqlParserPos> poses) {
        this.names = ImmutableList.copyOf(names);
        this.componentPositions = poses == null ? null : ImmutableList.copyOf(poses);
    }

    public SqlIdentifier setName(int i, String name) {
        if (!((String)this.names.get(i)).equals(name)) {
            Object[] nameArray = (String[])this.names.toArray((Object[])new String[0]);
            nameArray[i] = name;
            return new SqlIdentifier((List<String>)ImmutableList.copyOf((Object[])nameArray), this.collation, this.pos, (List<SqlParserPos>)this.componentPositions);
        }
        return this;
    }

    public SqlIdentifier add(int i, String name, SqlParserPos pos) {
        ArrayList<SqlParserPos> pos2;
        ArrayList<String> names2 = new ArrayList<String>((Collection<String>)this.names);
        names2.add(i, name);
        if (this.componentPositions == null) {
            pos2 = null;
        } else {
            pos2 = new ArrayList<SqlParserPos>((Collection<SqlParserPos>)this.componentPositions);
            pos2.add(i, pos);
        }
        return new SqlIdentifier(names2, this.collation, pos, pos2);
    }

    public SqlParserPos getComponentParserPosition(int i) {
        assert (i >= 0 && i < this.names.size());
        return this.componentPositions == null ? this.getParserPosition() : (SqlParserPos)this.componentPositions.get(i);
    }

    public void assignNamesFrom(SqlIdentifier other) {
        this.setNames((List<String>)other.names, (List<SqlParserPos>)other.componentPositions);
    }

    public SqlIdentifier getComponent(int ordinal) {
        return this.getComponent(ordinal, ordinal + 1);
    }

    public SqlIdentifier getComponent(int from, int to) {
        SqlParserPos pos;
        ImmutableList pos2;
        if (this.componentPositions == null) {
            pos2 = null;
            pos = this.pos;
        } else {
            pos2 = this.componentPositions.subList(from, to);
            pos = SqlParserPos.sum((Iterable<SqlParserPos>)pos2);
        }
        return new SqlIdentifier((List<String>)this.names.subList(from, to), this.collation, pos, (List<SqlParserPos>)pos2);
    }

    public SqlIdentifier plus(String name, SqlParserPos pos) {
        SqlParserPos pos2;
        ImmutableList componentPositions;
        ImmutableList names = ImmutableList.builder().addAll(this.names).add((Object)name).build();
        if (this.componentPositions != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            componentPositions = builder.addAll(this.componentPositions).add((Object)pos).build();
            pos2 = SqlParserPos.sum((Iterable<SqlParserPos>)builder.add((Object)this.pos).build());
        } else {
            componentPositions = null;
            pos2 = pos;
        }
        return new SqlIdentifier((List<String>)names, this.collation, pos2, (List<SqlParserPos>)componentPositions);
    }

    public SqlIdentifier plusStar() {
        SqlIdentifier id = this.plus("*", SqlParserPos.ZERO);
        return new SqlIdentifier((List)id.names.stream().map(s -> s.equals("*") ? "" : s).collect(Util.toImmutableList()), null, id.pos, (List<SqlParserPos>)id.componentPositions);
    }

    public SqlIdentifier skipLast(int n) {
        return this.getComponent(0, this.names.size() - n);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.IDENTIFIER);
        for (String name : this.names) {
            writer.sep(".");
            if (name.equals("")) {
                writer.print("*");
                continue;
            }
            writer.identifier(name);
        }
        if (null != this.collation) {
            this.collation.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateIdentifier(this, scope);
    }

    @Override
    public void validateExpr(SqlValidator validator, SqlValidatorScope scope) {
        SqlCall call = SqlUtil.makeCall(validator.getOperatorTable(), this);
        if (call != null) {
            validator.validateCall(call, scope);
            return;
        }
        validator.validateIdentifier(this, scope);
    }

    @Override
    public boolean equalsDeep(SqlNode node, Litmus litmus) {
        if (!(node instanceof SqlIdentifier)) {
            return litmus.fail("{} != {}", this, node);
        }
        SqlIdentifier that = (SqlIdentifier)node;
        if (this.names.size() != that.names.size()) {
            return litmus.fail("{} != {}", this, node);
        }
        for (int i = 0; i < this.names.size(); ++i) {
            if (((String)this.names.get(i)).equals(that.names.get(i))) continue;
            return litmus.fail("{} != {}", this, node);
        }
        return litmus.succeed();
    }

    @Override
    public <R> R accept(SqlVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public SqlCollation getCollation() {
        return this.collation;
    }

    public String getSimple() {
        assert (this.names.size() == 1);
        return (String)this.names.get(0);
    }

    public boolean isStar() {
        return Util.last(this.names).equals("");
    }

    public boolean isSimple() {
        return this.names.size() == 1 && !this.isStar();
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlValidatorScope scope) {
        if (Util.last(this.names).equals("") || DynamicRecordType.isDynamicStarColName(Util.last(this.names))) {
            return SqlMonotonicity.NOT_MONOTONIC;
        }
        SqlValidator validator = scope.getValidator();
        SqlCall call = SqlUtil.makeCall(validator.getOperatorTable(), this);
        if (call != null) {
            return call.getMonotonicity(scope);
        }
        SqlQualified qualified = scope.fullyQualify(this);
        SqlIdentifier fqId = qualified.identifier;
        return qualified.namespace.resolve().getMonotonicity(Util.last(fqId.names));
    }
}

