/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionPopupMenuItem;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class PopupMenuExportURLs
extends ExtensionPopupMenuItem {
    private static final long serialVersionUID = 1L;
    protected final Extension extension;
    private static Logger log = Logger.getLogger(PopupMenuExportURLs.class);

    public PopupMenuExportURLs(String label, Extension extension) {
        super(label);
        if (extension == null) {
            throw new IllegalArgumentException("Parameter extension must not be null.");
        }
        this.extension = extension;
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PopupMenuExportURLs.this.performAction();
            }
        });
    }

    @Override
    public boolean isEnableForComponent(Component invoker) {
        if ("treeSite".equals(invoker.getName())) {
            JTree sitesTree = (JTree)invoker;
            this.setEnabled(sitesTree.getRowCount() > 1);
            return true;
        }
        return false;
    }

    protected void performAction() {
        File file = this.getOutputFile();
        if (file == null) {
            return;
        }
        this.writeURLs(file, this.getOutputSet((SiteNode)this.extension.getView().getSiteTreePanel().getTreeSite().getModel().getRoot()));
    }

    protected SortedSet<String> getOutputSet(SiteNode startingPoint) {
        TreeSet<String> outputSet = new TreeSet<String>();
        Enumeration<TreeNode> en = startingPoint.preorderEnumeration();
        while (en.hasMoreElements()) {
            SiteNode node = (SiteNode)en.nextElement();
            if (node.isRoot()) continue;
            outputSet.add(node.getHistoryReference().getURI().toString());
        }
        return outputSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeURLs(File file, SortedSet<String> aSet) {
        boolean html = file.getName().toLowerCase().endsWith(".htm") || file.getName().toLowerCase().endsWith(".html");
        BufferedWriter fw = null;
        try {
            fw = new BufferedWriter(new FileWriter(file, false));
            for (String item : aSet) {
                item = html ? this.wrapHTML(item) : item;
                fw.write(item);
                fw.newLine();
            }
        }
        catch (Exception e1) {
            log.warn((Object)"An error occurred while writing the URLs:", (Throwable)e1);
            this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath());
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (Exception e2) {
                log.warn((Object)e2.getStackTrace(), (Throwable)e2);
            }
        }
    }

    private String wrapHTML(String input) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("<a href=\"").append(input).append("\">");
        sb.append(input).append("</a><br>");
        return sb.toString();
    }

    protected File getOutputFile() {
        FileNameExtensionFilter textFilesFilter = new FileNameExtensionFilter(Constant.messages.getString("file.format.ascii"), "txt");
        final FileNameExtensionFilter htmlFilesFilter = new FileNameExtensionFilter(Constant.messages.getString("file.format.html"), "html", "htm");
        WritableFileChooser chooser = new WritableFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory()){
            private static final long serialVersionUID = 1L;

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (file != null) {
                    String ext = null;
                    String filePath = file.getAbsolutePath();
                    String fileNameLc = filePath.toLowerCase(Locale.ROOT);
                    if (htmlFilesFilter.equals(this.getFileFilter())) {
                        if (!fileNameLc.endsWith(".htm") && !fileNameLc.endsWith(".html")) {
                            ext = ".html";
                        }
                    } else if (!fileNameLc.endsWith(".txt")) {
                        ext = ".txt";
                    }
                    if (ext != null) {
                        this.setSelectedFile(new File(filePath + ext));
                    }
                }
                super.approveSelection();
            }
        };
        chooser.addChoosableFileFilter(textFilesFilter);
        chooser.addChoosableFileFilter(htmlFilesFilter);
        chooser.setFileFilter(textFilesFilter);
        int rc = chooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (rc == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }
}

