/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import org.fife.ui.rsyntaxtextarea.CodeTemplate;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.DefaultToken;
import org.fife.ui.rsyntaxtextarea.Parser;
import org.fife.ui.rsyntaxtextarea.ParserManager;
import org.fife.ui.rsyntaxtextarea.ParserNotice;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.RtfGenerator;
import org.fife.ui.rsyntaxtextarea.RtfTransferable;
import org.fife.ui.rsyntaxtextarea.SquiggleUnderlineHighlightPainter;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.SyntaxHighlightingColorScheme;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.SyntaxView;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

public class RSyntaxTextArea
extends RTextArea
implements SyntaxConstants {
    public static final String ANTIALIAS_PROPERTY = "RSTA.antiAlias";
    public static final String AUTO_INDENT_PROPERTY = "RSTA.autoIndent";
    public static final String BRACKET_MATCHING_PROPERTY = "RSTA.bracketMatching";
    public static final String CLEAR_WHITESPACE_LINES_PROPERTY = "RSTA.clearWhitespaceLines";
    public static final String FRACTIONAL_FONTMETRICS_PROPERTY = "RSTA.fractionalFontMetrics";
    public static final String SYNTAX_SCHEME_PROPERTY = "RSTA.syntaxScheme";
    public static final String SYNTAX_STYLE_PROPERTY = "RSTA.syntaxStyle";
    public static final String VISIBLE_WHITESPACE_PROPERTY = "RSTA.visibleWhitespace";
    private static final Color DEFAULT_BRACKET_MATCH_BG_COLOR = new Color(234, 234, 255);
    private static final Color DEFAULT_BRACKET_MATCH_BORDER_COLOR = new Color(0, 0, 128);
    private int syntaxStyle = 0;
    private SyntaxHighlightingColorScheme colorScheme;
    private static CodeTemplateManager codeTemplateManager;
    private static boolean templatesEnabled;
    Rectangle match;
    private Color matchedBracketBGColor;
    private Color matchedBracketBorderColor;
    private boolean bracketMatchingEnabled;
    private boolean autoIndentEnabled;
    private boolean clearWhitespaceLines;
    private boolean whitespaceVisible = false;
    private RtfGenerator rtfGenerator;
    private FontMetrics defaultFontMetrics;
    private ParserManager parserManager;
    private List parserNoticeHighlights;
    private SquiggleUnderlineHighlightPainter parserErrorHighlightPainter = new SquiggleUnderlineHighlightPainter(Color.RED);
    private int lineHeight;
    private int maxAscent;
    private String aaHintFieldName;
    private Object aaHint;
    private boolean fractionalFontMetricsEnabled;

    public int getMaxAscent() {
        return this.maxAscent;
    }

    private void refreshFontMetrics(Graphics2D graphics2D) {
        this.defaultFontMetrics = graphics2D.getFontMetrics(this.getFont());
        for (int i = 0; i < this.colorScheme.syntaxSchemes.length; ++i) {
            SyntaxScheme syntaxScheme = this.colorScheme.syntaxSchemes[i];
            if (syntaxScheme == null) continue;
            syntaxScheme.fontMetrics = syntaxScheme.font == null ? null : graphics2D.getFontMetrics(syntaxScheme.font);
        }
        if (!this.getLineWrap()) {
            ((SyntaxView)this.getUI().getRootView(this).getView(0)).calculateLongestLine();
        }
    }

    public void setFractionalFontMetricsEnabled(boolean bl) {
        if (this.fractionalFontMetricsEnabled != bl) {
            this.fractionalFontMetricsEnabled = bl;
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(FRACTIONAL_FONTMETRICS_PROPERTY, !bl, bl);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
    }

    public RSyntaxTextArea() {
        this(false, 0);
    }

    public RSyntaxTextArea(boolean bl, int n) {
        super(new Font("Monospaced", 0, 13), bl, n);
        this.setMatchedBracketBGColor(RSyntaxTextArea.getDefaultBracketMatchBGColor());
        this.setMatchedBracketBorderColor(RSyntaxTextArea.getDefaultBracketMatchBorderColor());
        this.setBracketMatchingEnabled(true);
        this.setAutoIndentEnabled(true);
        this.setClearWhitespaceLinesEnabled(true);
    }

    public static void addCodeTemplate(String string, String string2, String string3) {
        if (RSyntaxTextArea.getTemplatesEnabled()) {
            CodeTemplate codeTemplate = new CodeTemplate(string, string2, string3);
            RSyntaxTextArea.getCodeTemplateManager().addTemplate(codeTemplate);
        }
    }

    private void calculateLineHeight() {
        int n;
        Object object;
        this.maxAscent = 0;
        this.lineHeight = 0;
        for (int i = 0; i < this.colorScheme.syntaxSchemes.length; ++i) {
            int n2;
            object = this.colorScheme.syntaxSchemes[i];
            if (object == null || ((SyntaxScheme)object).font == null) continue;
            FontMetrics fontMetrics = this.getFontMetrics(((SyntaxScheme)object).font);
            n = fontMetrics.getHeight();
            if (n > this.lineHeight) {
                this.lineHeight = n;
            }
            if ((n2 = fontMetrics.getMaxAscent()) <= this.maxAscent) continue;
            this.maxAscent = n2;
        }
        Font font = this.getFont();
        object = this.getFontMetrics(font);
        int n3 = ((FontMetrics)object).getHeight();
        if (n3 > this.lineHeight) {
            this.lineHeight = n3;
        }
        if ((n = ((FontMetrics)object).getMaxAscent()) > this.maxAscent) {
            this.maxAscent = n;
        }
    }

    protected void clearParserNoticeHighlights() {
        Highlighter highlighter = this.getHighlighter();
        if (highlighter != null && this.parserNoticeHighlights != null) {
            int n = this.parserNoticeHighlights.size();
            for (int i = 0; i < n; ++i) {
                highlighter.removeHighlight(this.parserNoticeHighlights.get(i));
            }
            this.parserNoticeHighlights.clear();
        }
        this.repaint();
    }

    private Token cloneTokenList(Token token) {
        if (token == null) {
            return null;
        }
        DefaultToken defaultToken = new DefaultToken();
        defaultToken.copyFrom(token);
        DefaultToken defaultToken2 = defaultToken;
        while ((token = token.getNextToken()) != null) {
            DefaultToken defaultToken3 = new DefaultToken();
            defaultToken3.copyFrom(token);
            defaultToken2.setNextToken(defaultToken3);
            defaultToken2 = defaultToken3;
        }
        return defaultToken;
    }

    public void copyAsRtf() {
        Object object;
        int n;
        int n2 = this.getSelectionStart();
        if (n2 == (n = this.getSelectionEnd())) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkSystemClipboardAccess();
            }
            catch (SecurityException securityException) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        RtfGenerator rtfGenerator = this.getRTFGenerator();
        Token token = this.getTokenListFor(n2, n);
        for (object = token; object != null; object = ((Token)object).getNextToken()) {
            if (!((Token)object).isPaintable()) continue;
            if (((Token)object).textCount == 1 && ((Token)object).text[((Token)object).textOffset] == '\n') {
                rtfGenerator.appendNewline();
                continue;
            }
            Font font = this.getFontForTokenType(((Token)object).type);
            Color color = this.getBackgroundForTokenType(((Token)object).type);
            boolean bl = this.getUnderlineForTokenType(((Token)object).type);
            if (((Token)object).isWhitespace()) {
                rtfGenerator.appendToDocNoFG(((Token)object).getLexeme(), font, color, bl);
                continue;
            }
            Color color2 = this.getForegroundForTokenType(((Token)object).type);
            rtfGenerator.appendToDoc(((Token)object).getLexeme(), font, color2, color, bl);
        }
        object = new RtfTransferable(rtfGenerator.getRtf().getBytes());
        try {
            clipboard.setContents((Transferable)object, null);
        }
        catch (IllegalStateException illegalStateException) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
    }

    protected Document createDefaultModel() {
        return new RSyntaxDocument(0);
    }

    protected RTextAreaUI createRTextAreaUI() {
        return new RSyntaxTextAreaUI(this);
    }

    protected final void doBracketMatching() {
        int n;
        if (this.match != null) {
            this.repaint(this.match);
        }
        if ((n = RSyntaxUtilities.getMatchingBracketPosition(this)) > -1) {
            try {
                this.match = this.modelToView(n);
                this.repaint(this.match);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        } else {
            this.match = null;
        }
    }

    protected void fireCaretUpdate(CaretEvent caretEvent) {
        super.fireCaretUpdate(caretEvent);
        if (this.bracketMatchingEnabled) {
            this.doBracketMatching();
        }
    }

    public Color getBackgroundForTokenType(int n) {
        return this.colorScheme.syntaxSchemes[n].background;
    }

    public static int getCodeTemplateCount() {
        return RSyntaxTextArea.getTemplatesEnabled() ? codeTemplateManager.getTemplateCount() : -1;
    }

    static CodeTemplateManager getCodeTemplateManager() {
        return codeTemplateManager;
    }

    public static final Color getDefaultBracketMatchBGColor() {
        return DEFAULT_BRACKET_MATCH_BG_COLOR;
    }

    public static final Color getDefaultBracketMatchBorderColor() {
        return DEFAULT_BRACKET_MATCH_BORDER_COLOR;
    }

    public SyntaxHighlightingColorScheme getDefaultSyntaxHighlightingColorScheme() {
        return new SyntaxHighlightingColorScheme(true);
    }

    public Font getFontForTokenType(int n) {
        Font font = this.colorScheme.syntaxSchemes[n].font;
        return font != null ? font : this.getFont();
    }

    public FontMetrics getFontMetricsForTokenType(int n) {
        FontMetrics fontMetrics = this.colorScheme.syntaxSchemes[n].fontMetrics;
        return fontMetrics != null ? fontMetrics : this.defaultFontMetrics;
    }

    public Color getForegroundForTokenType(int n) {
        Color color = this.colorScheme.syntaxSchemes[n].foreground;
        return color != null ? color : this.getForeground();
    }

    public boolean getFractionalFontMetricsEnabled() {
        return this.fractionalFontMetricsEnabled;
    }

    private final Graphics2D getGraphics2D(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.aaHint != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.aaHint);
        }
        if (this.fractionalFontMetricsEnabled) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        return graphics2D;
    }

    public int getLineHeight() {
        return this.lineHeight;
    }

    public final Color getMatchedBracketBGColor() {
        return this.matchedBracketBGColor;
    }

    public final Color getMatchedBracketBorderColor() {
        return this.matchedBracketBorderColor;
    }

    public final Rectangle getMatchRectangle() {
        return this.match;
    }

    private RtfGenerator getRTFGenerator() {
        if (this.rtfGenerator == null) {
            this.rtfGenerator = new RtfGenerator();
        } else {
            this.rtfGenerator.reset();
        }
        return this.rtfGenerator;
    }

    public int getSyntaxEditingStyle() {
        return this.syntaxStyle;
    }

    public SyntaxHighlightingColorScheme getSyntaxHighlightingColorScheme() {
        return this.colorScheme;
    }

    public static synchronized boolean getTemplatesEnabled() {
        return templatesEnabled;
    }

    public String getTextAntiAliasHint() {
        return this.aaHintFieldName;
    }

    private Token getTokenListFor(int n, int n2) {
        Token token;
        Token token2 = null;
        Token token3 = null;
        Element element = this.getDocument().getDefaultRootElement();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n2);
        for (int i = n3; i <= n4; ++i) {
            Token token4 = this.getTokenListForLine(i);
            token4 = this.cloneTokenList(token4);
            if (token2 == null) {
                token3 = token2 = token4;
                while (token3.getNextToken() != null && token3.getNextToken().isPaintable()) {
                    token3 = token3.getNextToken();
                }
            } else {
                token3.setNextToken(token4);
                while (token3.getNextToken() != null && token3.getNextToken().isPaintable()) {
                    token3 = token3.getNextToken();
                }
            }
            if (i >= n4) continue;
            int n5 = element.getElement(i).getEndOffset() - 1;
            token4 = new DefaultToken(new char[]{'\n'}, 0, 0, n5, 18);
            token3.setNextToken(token4);
            token3 = token4;
        }
        if (n >= token2.offset) {
            while (!token2.containsPosition(n)) {
                token2 = token2.getNextToken();
            }
            token2.makeStartAt(n);
        }
        for (token = token2; token != null && !token.containsPosition(n2); token = token.getNextToken()) {
        }
        if (token != null) {
            token.textCount = n2 - token.offset;
            token.setNextToken(null);
        }
        return token2;
    }

    public Token getTokenListForLine(int n) {
        return ((RSyntaxDocument)this.getDocument()).getTokenListForLine(n);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = this.parserManager == null ? null : this.parserManager.getToolTipText(mouseEvent);
        return string != null ? string : super.getToolTipText(mouseEvent);
    }

    public boolean getUnderlineForTokenType(int n) {
        return this.colorScheme.syntaxSchemes[n].underline;
    }

    public boolean isAutoIndentEnabled() {
        return this.autoIndentEnabled;
    }

    public final boolean isBracketMatchingEnabled() {
        return this.bracketMatchingEnabled;
    }

    public boolean isClearWhitespaceLinesEnabled() {
        return this.clearWhitespaceLines;
    }

    public boolean isWhitespaceVisible() {
        return this.whitespaceVisible;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(this.getGraphics2D(graphics));
    }

    void refreshParserNoticeHighlights(Iterator iterator) {
        this.clearParserNoticeHighlights();
        if (this.parserNoticeHighlights == null) {
            this.parserNoticeHighlights = new ArrayList();
        }
        Highlighter highlighter = this.getHighlighter();
        while (iterator.hasNext()) {
            ParserNotice parserNotice = (ParserNotice)iterator.next();
            int n = parserNotice.getOffset();
            int n2 = parserNotice.getLength();
            try {
                this.parserNoticeHighlights.add(highlighter.addHighlight(n, n + n2, this.parserErrorHighlightPainter));
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void removeNotify() {
        if (this.parserManager != null) {
            this.parserManager.stopParsing();
        }
        super.removeNotify();
    }

    public void restoreDefaultSyntaxHighlightingColorScheme() {
        this.setSyntaxHighlightingColorScheme(this.getDefaultSyntaxHighlightingColorScheme());
    }

    public static synchronized boolean saveTemplates() {
        if (!RSyntaxTextArea.getTemplatesEnabled() || codeTemplateManager == null) {
            return false;
        }
        return codeTemplateManager.saveTemplates();
    }

    public void setAutoIndentEnabled(boolean bl) {
        if (this.autoIndentEnabled != bl) {
            this.autoIndentEnabled = bl;
            this.firePropertyChange(AUTO_INDENT_PROPERTY, !bl, bl);
        }
    }

    public void setBracketMatchingEnabled(boolean bl) {
        if (bl != this.bracketMatchingEnabled) {
            this.bracketMatchingEnabled = bl;
            this.repaint();
            this.firePropertyChange(BRACKET_MATCHING_PROPERTY, !bl, bl);
        }
    }

    public void setClearWhitespaceLinesEnabled(boolean bl) {
        if (bl != this.clearWhitespaceLines) {
            this.clearWhitespaceLines = bl;
            this.firePropertyChange(CLEAR_WHITESPACE_LINES_PROPERTY, !bl, bl);
        }
    }

    public void setDocument(Document document) {
        if (!(document instanceof RSyntaxDocument)) {
            throw new IllegalArgumentException("Documents for RSyntaxTextArea must be instances of RSyntaxDocument!");
        }
        super.setDocument(document);
    }

    public void setFont(Font font) {
        Font font2 = super.getFont();
        super.setFont(font);
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            this.calculateLineHeight();
            this.updateMarginLineX();
            this.forceCurrentLineHighlightRepaint();
            this.firePropertyChange("font", font2, font);
            this.revalidate();
        }
    }

    public void setMatchedBracketBGColor(Color color) {
        this.matchedBracketBGColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setMatchedBracketBorderColor(Color color) {
        this.matchedBracketBorderColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setParser(Parser parser) {
        if (this.parserManager == null) {
            this.parserManager = new ParserManager(this);
        }
        this.clearParserNoticeHighlights();
        this.parserManager.setParser(parser);
    }

    public void setSyntaxEditingStyle(int n) {
        if (n < 0 || n > 21) {
            n = 0;
        }
        if (n != this.syntaxStyle) {
            int n2 = this.syntaxStyle;
            this.syntaxStyle = n;
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle(n);
            this.firePropertyChange(SYNTAX_STYLE_PROPERTY, n2, this.syntaxStyle);
        }
    }

    public void setSyntaxHighlightingColorScheme(SyntaxHighlightingColorScheme syntaxHighlightingColorScheme) {
        SyntaxHighlightingColorScheme syntaxHighlightingColorScheme2 = this.colorScheme;
        this.colorScheme = syntaxHighlightingColorScheme;
        this.calculateLineHeight();
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
        }
        this.updateMarginLineX();
        this.forceCurrentLineHighlightRepaint();
        this.revalidate();
        this.firePropertyChange(SYNTAX_SCHEME_PROPERTY, syntaxHighlightingColorScheme2, this.colorScheme);
    }

    public static synchronized boolean setTemplateDirectory(String string) {
        if (RSyntaxTextArea.getTemplatesEnabled() && string != null) {
            File file = new File(string);
            if (file.isDirectory()) {
                return codeTemplateManager.setTemplateDirectory(file) > -1;
            }
            boolean bl = file.mkdir();
            if (bl) {
                return codeTemplateManager.setTemplateDirectory(file) > -1;
            }
        }
        return false;
    }

    public static synchronized void setTemplatesEnabled(boolean bl) {
        if (bl != templatesEnabled) {
            templatesEnabled = bl;
            codeTemplateManager = bl ? new CodeTemplateManager() : null;
        }
    }

    public void setTextAntiAliasHint(String string) {
        if (string == null && this.aaHintFieldName != null) {
            String string2 = this.aaHintFieldName;
            this.aaHint = null;
            this.aaHintFieldName = null;
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(ANTIALIAS_PROPERTY, string2, null);
            this.repaint();
        } else if (string != null && !string.equals(this.aaHintFieldName)) {
            String string3 = this.aaHintFieldName;
            try {
                Field field = RenderingHints.class.getDeclaredField(string);
                this.aaHint = field.get(null);
                this.aaHintFieldName = string;
            }
            catch (RuntimeException runtimeException) {
            }
            catch (Exception exception) {
                this.aaHint = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                this.aaHintFieldName = "VALUE_TEXT_ANTIALIAS_OFF";
            }
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(ANTIALIAS_PROPERTY, string3, this.aaHintFieldName);
            this.repaint();
        }
    }

    public void setWhitespaceVisible(boolean bl) {
        if (this.whitespaceVisible != bl) {
            this.whitespaceVisible = bl;
            ((RSyntaxDocument)this.getDocument()).setWhitespaceVisible(bl, this);
            this.repaint();
            this.firePropertyChange(VISIBLE_WHITESPACE_PROPERTY, !bl, bl);
        }
    }
}

