/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import java.util.Locale;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;
import org.apache.commons.codec.binary.StringUtils;

public class DoubleMetaphone
implements StringEncoder {
    private static final String VOWELS = "AEIOUY";
    private static final String[] SILENT_START = new String[]{"GN", "KN", "PN", "WR", "PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"L", "R", "N", "M", "B", "H", "F", "V", "W", " "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"ES", "EP", "EB", "EL", "EY", "IB", "IL", "IN", "IE", "EI", "ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"L", "T", "K", "S", "N", "M", "B", "Z"};
    private int maxCodeLen = 4;

    public String doubleMetaphone(String value) {
        return this.doubleMetaphone(value, false);
    }

    public String doubleMetaphone(String value, boolean alternate) {
        if ((value = this.cleanInput(value)) == null) {
            return null;
        }
        boolean slavoGermanic = this.isSlavoGermanic(value);
        int index2 = this.isSilentStart(value) ? 1 : 0;
        DoubleMetaphoneResult result = new DoubleMetaphoneResult(this.getMaxCodeLen());
        block25: while (!result.isComplete() && index2 <= value.length() - 1) {
            switch (value.charAt(index2)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    index2 = this.handleAEIOUY(result, index2);
                    continue block25;
                }
                case 'B': {
                    result.append('P');
                    index2 = this.charAt(value, index2 + 1) == 'B' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case '\u00c7': {
                    result.append('S');
                    ++index2;
                    continue block25;
                }
                case 'C': {
                    index2 = this.handleC(value, result, index2);
                    continue block25;
                }
                case 'D': {
                    index2 = this.handleD(value, result, index2);
                    continue block25;
                }
                case 'F': {
                    result.append('F');
                    index2 = this.charAt(value, index2 + 1) == 'F' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'G': {
                    index2 = this.handleG(value, result, index2, slavoGermanic);
                    continue block25;
                }
                case 'H': {
                    index2 = this.handleH(value, result, index2);
                    continue block25;
                }
                case 'J': {
                    index2 = this.handleJ(value, result, index2, slavoGermanic);
                    continue block25;
                }
                case 'K': {
                    result.append('K');
                    index2 = this.charAt(value, index2 + 1) == 'K' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'L': {
                    index2 = this.handleL(value, result, index2);
                    continue block25;
                }
                case 'M': {
                    result.append('M');
                    index2 = this.conditionM0(value, index2) ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'N': {
                    result.append('N');
                    index2 = this.charAt(value, index2 + 1) == 'N' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case '\u00d1': {
                    result.append('N');
                    ++index2;
                    continue block25;
                }
                case 'P': {
                    index2 = this.handleP(value, result, index2);
                    continue block25;
                }
                case 'Q': {
                    result.append('K');
                    index2 = this.charAt(value, index2 + 1) == 'Q' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'R': {
                    index2 = this.handleR(value, result, index2, slavoGermanic);
                    continue block25;
                }
                case 'S': {
                    index2 = this.handleS(value, result, index2, slavoGermanic);
                    continue block25;
                }
                case 'T': {
                    index2 = this.handleT(value, result, index2);
                    continue block25;
                }
                case 'V': {
                    result.append('F');
                    index2 = this.charAt(value, index2 + 1) == 'V' ? index2 + 2 : index2 + 1;
                    continue block25;
                }
                case 'W': {
                    index2 = this.handleW(value, result, index2);
                    continue block25;
                }
                case 'X': {
                    index2 = this.handleX(value, result, index2);
                    continue block25;
                }
                case 'Z': {
                    index2 = this.handleZ(value, result, index2, slavoGermanic);
                    continue block25;
                }
            }
            ++index2;
        }
        return alternate ? result.getAlternate() : result.getPrimary();
    }

    @Override
    public Object encode(Object obj) throws EncoderException {
        if (!(obj instanceof String)) {
            throw new EncoderException("DoubleMetaphone encode parameter is not of type String");
        }
        return this.doubleMetaphone((String)obj);
    }

    @Override
    public String encode(String value) {
        return this.doubleMetaphone(value);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2) {
        return this.isDoubleMetaphoneEqual(value1, value2, false);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2, boolean alternate) {
        return StringUtils.equals(this.doubleMetaphone(value1, alternate), this.doubleMetaphone(value2, alternate));
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    public void setMaxCodeLen(int maxCodeLen) {
        this.maxCodeLen = maxCodeLen;
    }

    private int handleAEIOUY(DoubleMetaphoneResult result, int index2) {
        if (index2 == 0) {
            result.append('A');
        }
        return index2 + 1;
    }

    private int handleC(String value, DoubleMetaphoneResult result, int index2) {
        if (this.conditionC0(value, index2)) {
            result.append('K');
            index2 += 2;
        } else if (index2 == 0 && DoubleMetaphone.contains(value, index2, 6, "CAESAR")) {
            result.append('S');
            index2 += 2;
        } else if (DoubleMetaphone.contains(value, index2, 2, "CH")) {
            index2 = this.handleCH(value, result, index2);
        } else if (DoubleMetaphone.contains(value, index2, 2, "CZ") && !DoubleMetaphone.contains(value, index2 - 2, 4, "WICZ")) {
            result.append('S', 'X');
            index2 += 2;
        } else if (DoubleMetaphone.contains(value, index2 + 1, 3, "CIA")) {
            result.append('X');
            index2 += 3;
        } else {
            if (DoubleMetaphone.contains(value, index2, 2, "CC") && (index2 != 1 || this.charAt(value, 0) != 'M')) {
                return this.handleCC(value, result, index2);
            }
            if (DoubleMetaphone.contains(value, index2, 2, "CK", "CG", "CQ")) {
                result.append('K');
                index2 += 2;
            } else if (DoubleMetaphone.contains(value, index2, 2, "CI", "CE", "CY")) {
                if (DoubleMetaphone.contains(value, index2, 3, "CIO", "CIE", "CIA")) {
                    result.append('S', 'X');
                } else {
                    result.append('S');
                }
                index2 += 2;
            } else {
                result.append('K');
                index2 = DoubleMetaphone.contains(value, index2 + 1, 2, " C", " Q", " G") ? (index2 += 3) : (DoubleMetaphone.contains(value, index2 + 1, 1, "C", "K", "Q") && !DoubleMetaphone.contains(value, index2 + 1, 2, "CE", "CI") ? (index2 += 2) : ++index2);
            }
        }
        return index2;
    }

    private int handleCC(String value, DoubleMetaphoneResult result, int index2) {
        if (DoubleMetaphone.contains(value, index2 + 2, 1, "I", "E", "H") && !DoubleMetaphone.contains(value, index2 + 2, 2, "HU")) {
            if (index2 == 1 && this.charAt(value, index2 - 1) == 'A' || DoubleMetaphone.contains(value, index2 - 1, 5, "UCCEE", "UCCES")) {
                result.append("KS");
            } else {
                result.append('X');
            }
            index2 += 3;
        } else {
            result.append('K');
            index2 += 2;
        }
        return index2;
    }

    private int handleCH(String value, DoubleMetaphoneResult result, int index2) {
        if (index2 > 0 && DoubleMetaphone.contains(value, index2, 4, "CHAE")) {
            result.append('K', 'X');
            return index2 + 2;
        }
        if (this.conditionCH0(value, index2)) {
            result.append('K');
            return index2 + 2;
        }
        if (this.conditionCH1(value, index2)) {
            result.append('K');
            return index2 + 2;
        }
        if (index2 > 0) {
            if (DoubleMetaphone.contains(value, 0, 2, "MC")) {
                result.append('K');
            } else {
                result.append('X', 'K');
            }
        } else {
            result.append('X');
        }
        return index2 + 2;
    }

    private int handleD(String value, DoubleMetaphoneResult result, int index2) {
        if (DoubleMetaphone.contains(value, index2, 2, "DG")) {
            if (DoubleMetaphone.contains(value, index2 + 2, 1, "I", "E", "Y")) {
                result.append('J');
                index2 += 3;
            } else {
                result.append("TK");
                index2 += 2;
            }
        } else if (DoubleMetaphone.contains(value, index2, 2, "DT", "DD")) {
            result.append('T');
            index2 += 2;
        } else {
            result.append('T');
            ++index2;
        }
        return index2;
    }

    private int handleG(String value, DoubleMetaphoneResult result, int index2, boolean slavoGermanic) {
        if (this.charAt(value, index2 + 1) == 'H') {
            index2 = this.handleGH(value, result, index2);
        } else if (this.charAt(value, index2 + 1) == 'N') {
            if (index2 == 1 && this.isVowel(this.charAt(value, 0)) && !slavoGermanic) {
                result.append("KN", "N");
            } else if (!DoubleMetaphone.contains(value, index2 + 2, 2, "EY") && this.charAt(value, index2 + 1) != 'Y' && !slavoGermanic) {
                result.append("N", "KN");
            } else {
                result.append("KN");
            }
            index2 += 2;
        } else if (DoubleMetaphone.contains(value, index2 + 1, 2, "LI") && !slavoGermanic) {
            result.append("KL", "L");
            index2 += 2;
        } else if (index2 == 0 && (this.charAt(value, index2 + 1) == 'Y' || DoubleMetaphone.contains(value, index2 + 1, 2, ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
            result.append('K', 'J');
            index2 += 2;
        } else if (!(!DoubleMetaphone.contains(value, index2 + 1, 2, "ER") && this.charAt(value, index2 + 1) != 'Y' || DoubleMetaphone.contains(value, 0, 6, "DANGER", "RANGER", "MANGER") || DoubleMetaphone.contains(value, index2 - 1, 1, "E", "I") || DoubleMetaphone.contains(value, index2 - 1, 3, "RGY", "OGY"))) {
            result.append('K', 'J');
            index2 += 2;
        } else if (DoubleMetaphone.contains(value, index2 + 1, 1, "E", "I", "Y") || DoubleMetaphone.contains(value, index2 - 1, 4, "AGGI", "OGGI")) {
            if (DoubleMetaphone.contains(value, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(value, 0, 3, "SCH") || DoubleMetaphone.contains(value, index2 + 1, 2, "ET")) {
                result.append('K');
            } else if (DoubleMetaphone.contains(value, index2 + 1, 3, "IER")) {
                result.append('J');
            } else {
                result.append('J', 'K');
            }
            index2 += 2;
        } else if (this.charAt(value, index2 + 1) == 'G') {
            index2 += 2;
            result.append('K');
        } else {
            ++index2;
            result.append('K');
        }
        return index2;
    }

    private int handleGH(String value, DoubleMetaphoneResult result, int index2) {
        if (index2 > 0 && !this.isVowel(this.charAt(value, index2 - 1))) {
            result.append('K');
            index2 += 2;
        } else if (index2 == 0) {
            if (this.charAt(value, index2 + 2) == 'I') {
                result.append('J');
            } else {
                result.append('K');
            }
            index2 += 2;
        } else if (index2 > 1 && DoubleMetaphone.contains(value, index2 - 2, 1, "B", "H", "D") || index2 > 2 && DoubleMetaphone.contains(value, index2 - 3, 1, "B", "H", "D") || index2 > 3 && DoubleMetaphone.contains(value, index2 - 4, 1, "B", "H")) {
            index2 += 2;
        } else {
            if (index2 > 2 && this.charAt(value, index2 - 1) == 'U' && DoubleMetaphone.contains(value, index2 - 3, 1, "C", "G", "L", "R", "T")) {
                result.append('F');
            } else if (index2 > 0 && this.charAt(value, index2 - 1) != 'I') {
                result.append('K');
            }
            index2 += 2;
        }
        return index2;
    }

    private int handleH(String value, DoubleMetaphoneResult result, int index2) {
        if ((index2 == 0 || this.isVowel(this.charAt(value, index2 - 1))) && this.isVowel(this.charAt(value, index2 + 1))) {
            result.append('H');
            index2 += 2;
        } else {
            ++index2;
        }
        return index2;
    }

    private int handleJ(String value, DoubleMetaphoneResult result, int index2, boolean slavoGermanic) {
        if (DoubleMetaphone.contains(value, index2, 4, "JOSE") || DoubleMetaphone.contains(value, 0, 4, "SAN ")) {
            if (index2 == 0 && this.charAt(value, index2 + 4) == ' ' || value.length() == 4 || DoubleMetaphone.contains(value, 0, 4, "SAN ")) {
                result.append('H');
            } else {
                result.append('J', 'H');
            }
            ++index2;
        } else {
            if (index2 == 0 && !DoubleMetaphone.contains(value, index2, 4, "JOSE")) {
                result.append('J', 'A');
            } else if (this.isVowel(this.charAt(value, index2 - 1)) && !slavoGermanic && (this.charAt(value, index2 + 1) == 'A' || this.charAt(value, index2 + 1) == 'O')) {
                result.append('J', 'H');
            } else if (index2 == value.length() - 1) {
                result.append('J', ' ');
            } else if (!DoubleMetaphone.contains(value, index2 + 1, 1, L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains(value, index2 - 1, 1, "S", "K", "L")) {
                result.append('J');
            }
            index2 = this.charAt(value, index2 + 1) == 'J' ? (index2 += 2) : ++index2;
        }
        return index2;
    }

    private int handleL(String value, DoubleMetaphoneResult result, int index2) {
        if (this.charAt(value, index2 + 1) == 'L') {
            if (this.conditionL0(value, index2)) {
                result.appendPrimary('L');
            } else {
                result.append('L');
            }
            index2 += 2;
        } else {
            ++index2;
            result.append('L');
        }
        return index2;
    }

    private int handleP(String value, DoubleMetaphoneResult result, int index2) {
        if (this.charAt(value, index2 + 1) == 'H') {
            result.append('F');
            index2 += 2;
        } else {
            result.append('P');
            index2 = DoubleMetaphone.contains(value, index2 + 1, 1, "P", "B") ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private int handleR(String value, DoubleMetaphoneResult result, int index2, boolean slavoGermanic) {
        if (index2 == value.length() - 1 && !slavoGermanic && DoubleMetaphone.contains(value, index2 - 2, 2, "IE") && !DoubleMetaphone.contains(value, index2 - 4, 2, "ME", "MA")) {
            result.appendAlternate('R');
        } else {
            result.append('R');
        }
        return this.charAt(value, index2 + 1) == 'R' ? index2 + 2 : index2 + 1;
    }

    private int handleS(String value, DoubleMetaphoneResult result, int index2, boolean slavoGermanic) {
        if (DoubleMetaphone.contains(value, index2 - 1, 3, "ISL", "YSL")) {
            ++index2;
        } else if (index2 == 0 && DoubleMetaphone.contains(value, index2, 5, "SUGAR")) {
            result.append('X', 'S');
            ++index2;
        } else if (DoubleMetaphone.contains(value, index2, 2, "SH")) {
            if (DoubleMetaphone.contains(value, index2 + 1, 4, "HEIM", "HOEK", "HOLM", "HOLZ")) {
                result.append('S');
            } else {
                result.append('X');
            }
            index2 += 2;
        } else if (DoubleMetaphone.contains(value, index2, 3, "SIO", "SIA") || DoubleMetaphone.contains(value, index2, 4, "SIAN")) {
            if (slavoGermanic) {
                result.append('S');
            } else {
                result.append('S', 'X');
            }
            index2 += 3;
        } else if (index2 == 0 && DoubleMetaphone.contains(value, index2 + 1, 1, "M", "N", "L", "W") || DoubleMetaphone.contains(value, index2 + 1, 1, "Z")) {
            result.append('S', 'X');
            index2 = DoubleMetaphone.contains(value, index2 + 1, 1, "Z") ? index2 + 2 : index2 + 1;
        } else if (DoubleMetaphone.contains(value, index2, 2, "SC")) {
            index2 = this.handleSC(value, result, index2);
        } else {
            if (index2 == value.length() - 1 && DoubleMetaphone.contains(value, index2 - 2, 2, "AI", "OI")) {
                result.appendAlternate('S');
            } else {
                result.append('S');
            }
            index2 = DoubleMetaphone.contains(value, index2 + 1, 1, "S", "Z") ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private int handleSC(String value, DoubleMetaphoneResult result, int index2) {
        if (this.charAt(value, index2 + 2) == 'H') {
            if (DoubleMetaphone.contains(value, index2 + 3, 2, "OO", "ER", "EN", "UY", "ED", "EM")) {
                if (DoubleMetaphone.contains(value, index2 + 3, 2, "ER", "EN")) {
                    result.append("X", "SK");
                } else {
                    result.append("SK");
                }
            } else if (index2 == 0 && !this.isVowel(this.charAt(value, 3)) && this.charAt(value, 3) != 'W') {
                result.append('X', 'S');
            } else {
                result.append('X');
            }
        } else if (DoubleMetaphone.contains(value, index2 + 2, 1, "I", "E", "Y")) {
            result.append('S');
        } else {
            result.append("SK");
        }
        return index2 + 3;
    }

    private int handleT(String value, DoubleMetaphoneResult result, int index2) {
        if (DoubleMetaphone.contains(value, index2, 4, "TION")) {
            result.append('X');
            index2 += 3;
        } else if (DoubleMetaphone.contains(value, index2, 3, "TIA", "TCH")) {
            result.append('X');
            index2 += 3;
        } else if (DoubleMetaphone.contains(value, index2, 2, "TH") || DoubleMetaphone.contains(value, index2, 3, "TTH")) {
            if (DoubleMetaphone.contains(value, index2 + 2, 2, "OM", "AM") || DoubleMetaphone.contains(value, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(value, 0, 3, "SCH")) {
                result.append('T');
            } else {
                result.append('0', 'T');
            }
            index2 += 2;
        } else {
            result.append('T');
            index2 = DoubleMetaphone.contains(value, index2 + 1, 1, "T", "D") ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private int handleW(String value, DoubleMetaphoneResult result, int index2) {
        if (DoubleMetaphone.contains(value, index2, 2, "WR")) {
            result.append('R');
            index2 += 2;
        } else if (index2 == 0 && (this.isVowel(this.charAt(value, index2 + 1)) || DoubleMetaphone.contains(value, index2, 2, "WH"))) {
            if (this.isVowel(this.charAt(value, index2 + 1))) {
                result.append('A', 'F');
            } else {
                result.append('A');
            }
            ++index2;
        } else if (index2 == value.length() - 1 && this.isVowel(this.charAt(value, index2 - 1)) || DoubleMetaphone.contains(value, index2 - 1, 5, "EWSKI", "EWSKY", "OWSKI", "OWSKY") || DoubleMetaphone.contains(value, 0, 3, "SCH")) {
            result.appendAlternate('F');
            ++index2;
        } else if (DoubleMetaphone.contains(value, index2, 4, "WICZ", "WITZ")) {
            result.append("TS", "FX");
            index2 += 4;
        } else {
            ++index2;
        }
        return index2;
    }

    private int handleX(String value, DoubleMetaphoneResult result, int index2) {
        if (index2 == 0) {
            result.append('S');
            ++index2;
        } else {
            if (index2 != value.length() - 1 || !DoubleMetaphone.contains(value, index2 - 3, 3, "IAU", "EAU") && !DoubleMetaphone.contains(value, index2 - 2, 2, "AU", "OU")) {
                result.append("KS");
            }
            index2 = DoubleMetaphone.contains(value, index2 + 1, 1, "C", "X") ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private int handleZ(String value, DoubleMetaphoneResult result, int index2, boolean slavoGermanic) {
        if (this.charAt(value, index2 + 1) == 'H') {
            result.append('J');
            index2 += 2;
        } else {
            if (DoubleMetaphone.contains(value, index2 + 1, 2, "ZO", "ZI", "ZA") || slavoGermanic && index2 > 0 && this.charAt(value, index2 - 1) != 'T') {
                result.append("S", "TS");
            } else {
                result.append('S');
            }
            index2 = this.charAt(value, index2 + 1) == 'Z' ? index2 + 2 : index2 + 1;
        }
        return index2;
    }

    private boolean conditionC0(String value, int index2) {
        if (DoubleMetaphone.contains(value, index2, 4, "CHIA")) {
            return true;
        }
        if (index2 <= 1) {
            return false;
        }
        if (this.isVowel(this.charAt(value, index2 - 2))) {
            return false;
        }
        if (!DoubleMetaphone.contains(value, index2 - 1, 3, "ACH")) {
            return false;
        }
        char c = this.charAt(value, index2 + 2);
        return c != 'I' && c != 'E' || DoubleMetaphone.contains(value, index2 - 2, 6, "BACHER", "MACHER");
    }

    private boolean conditionCH0(String value, int index2) {
        if (index2 != 0) {
            return false;
        }
        if (!DoubleMetaphone.contains(value, index2 + 1, 5, "HARAC", "HARIS") && !DoubleMetaphone.contains(value, index2 + 1, 3, "HOR", "HYM", "HIA", "HEM")) {
            return false;
        }
        return !DoubleMetaphone.contains(value, 0, 5, "CHORE");
    }

    private boolean conditionCH1(String value, int index2) {
        return DoubleMetaphone.contains(value, 0, 4, "VAN ", "VON ") || DoubleMetaphone.contains(value, 0, 3, "SCH") || DoubleMetaphone.contains(value, index2 - 2, 6, "ORCHES", "ARCHIT", "ORCHID") || DoubleMetaphone.contains(value, index2 + 2, 1, "T", "S") || (DoubleMetaphone.contains(value, index2 - 1, 1, "A", "O", "U", "E") || index2 == 0) && (DoubleMetaphone.contains(value, index2 + 2, 1, L_R_N_M_B_H_F_V_W_SPACE) || index2 + 1 == value.length() - 1);
    }

    private boolean conditionL0(String value, int index2) {
        if (index2 == value.length() - 3 && DoubleMetaphone.contains(value, index2 - 1, 4, "ILLO", "ILLA", "ALLE")) {
            return true;
        }
        return (DoubleMetaphone.contains(value, value.length() - 2, 2, "AS", "OS") || DoubleMetaphone.contains(value, value.length() - 1, 1, "A", "O")) && DoubleMetaphone.contains(value, index2 - 1, 4, "ALLE");
    }

    private boolean conditionM0(String value, int index2) {
        if (this.charAt(value, index2 + 1) == 'M') {
            return true;
        }
        return DoubleMetaphone.contains(value, index2 - 1, 3, "UMB") && (index2 + 1 == value.length() - 1 || DoubleMetaphone.contains(value, index2 + 2, 2, "ER"));
    }

    private boolean isSlavoGermanic(String value) {
        return value.indexOf(87) > -1 || value.indexOf(75) > -1 || value.indexOf("CZ") > -1 || value.indexOf("WITZ") > -1;
    }

    private boolean isVowel(char ch) {
        return VOWELS.indexOf(ch) != -1;
    }

    private boolean isSilentStart(String value) {
        boolean result = false;
        for (String element : SILENT_START) {
            if (!value.startsWith(element)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String cleanInput(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return null;
        }
        return input.toUpperCase(Locale.ENGLISH);
    }

    protected char charAt(String value, int index2) {
        if (index2 < 0 || index2 >= value.length()) {
            return '\u0000';
        }
        return value.charAt(index2);
    }

    protected static boolean contains(String value, int start, int length, String ... criteria) {
        boolean result = false;
        if (start >= 0 && start + length <= value.length()) {
            String target = value.substring(start, start + length);
            for (String element : criteria) {
                if (!target.equals(element)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public class DoubleMetaphoneResult {
        private final StringBuilder primary;
        private final StringBuilder alternate;
        private final int maxLength;

        public DoubleMetaphoneResult(int maxLength) {
            this.primary = new StringBuilder(DoubleMetaphone.this.getMaxCodeLen());
            this.alternate = new StringBuilder(DoubleMetaphone.this.getMaxCodeLen());
            this.maxLength = maxLength;
        }

        public void append(char value) {
            this.appendPrimary(value);
            this.appendAlternate(value);
        }

        public void append(char primary, char alternate) {
            this.appendPrimary(primary);
            this.appendAlternate(alternate);
        }

        public void appendPrimary(char value) {
            if (this.primary.length() < this.maxLength) {
                this.primary.append(value);
            }
        }

        public void appendAlternate(char value) {
            if (this.alternate.length() < this.maxLength) {
                this.alternate.append(value);
            }
        }

        public void append(String value) {
            this.appendPrimary(value);
            this.appendAlternate(value);
        }

        public void append(String primary, String alternate) {
            this.appendPrimary(primary);
            this.appendAlternate(alternate);
        }

        public void appendPrimary(String value) {
            int addChars = this.maxLength - this.primary.length();
            if (value.length() <= addChars) {
                this.primary.append(value);
            } else {
                this.primary.append(value.substring(0, addChars));
            }
        }

        public void appendAlternate(String value) {
            int addChars = this.maxLength - this.alternate.length();
            if (value.length() <= addChars) {
                this.alternate.append(value);
            } else {
                this.alternate.append(value.substring(0, addChars));
            }
        }

        public String getPrimary() {
            return this.primary.toString();
        }

        public String getAlternate() {
            return this.alternate.toString();
        }

        public boolean isComplete() {
            return this.primary.length() >= this.maxLength && this.alternate.length() >= this.maxLength;
        }
    }
}

