/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.grok.Grok;
import org.elasticsearch.grok.MatcherWatchdog;
import org.elasticsearch.ingest.DropProcessor;
import org.elasticsearch.ingest.PipelineProcessor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.common.AppendProcessor;
import org.elasticsearch.ingest.common.BytesProcessor;
import org.elasticsearch.ingest.common.ConvertProcessor;
import org.elasticsearch.ingest.common.CsvProcessor;
import org.elasticsearch.ingest.common.DateIndexNameProcessor;
import org.elasticsearch.ingest.common.DateProcessor;
import org.elasticsearch.ingest.common.DissectProcessor;
import org.elasticsearch.ingest.common.DotExpanderProcessor;
import org.elasticsearch.ingest.common.FailProcessor;
import org.elasticsearch.ingest.common.ForEachProcessor;
import org.elasticsearch.ingest.common.GrokProcessor;
import org.elasticsearch.ingest.common.GrokProcessorGetAction;
import org.elasticsearch.ingest.common.GsubProcessor;
import org.elasticsearch.ingest.common.HtmlStripProcessor;
import org.elasticsearch.ingest.common.JoinProcessor;
import org.elasticsearch.ingest.common.JsonProcessor;
import org.elasticsearch.ingest.common.KeyValueProcessor;
import org.elasticsearch.ingest.common.LowercaseProcessor;
import org.elasticsearch.ingest.common.RemoveProcessor;
import org.elasticsearch.ingest.common.RenameProcessor;
import org.elasticsearch.ingest.common.ScriptProcessor;
import org.elasticsearch.ingest.common.SetProcessor;
import org.elasticsearch.ingest.common.SortProcessor;
import org.elasticsearch.ingest.common.SplitProcessor;
import org.elasticsearch.ingest.common.TrimProcessor;
import org.elasticsearch.ingest.common.URLDecodeProcessor;
import org.elasticsearch.ingest.common.UppercaseProcessor;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.IngestPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;

public class IngestCommonPlugin
extends Plugin
implements ActionPlugin,
IngestPlugin {
    static final Map<String, String> GROK_PATTERNS = Grok.getBuiltinPatterns();
    static final Setting<TimeValue> WATCHDOG_INTERVAL = Setting.timeSetting((String)"ingest.grok.watchdog.interval", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<TimeValue> WATCHDOG_MAX_EXECUTION_TIME = Setting.timeSetting((String)"ingest.grok.watchdog.max_execution_time", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public Map<String, Processor.Factory> getProcessors(Processor.Parameters parameters) {
        HashMap<String, Object> processors = new HashMap<String, Object>();
        processors.put("date", new DateProcessor.Factory(parameters.scriptService));
        processors.put("set", new SetProcessor.Factory(parameters.scriptService));
        processors.put("append", new AppendProcessor.Factory(parameters.scriptService));
        processors.put("rename", new RenameProcessor.Factory(parameters.scriptService));
        processors.put("remove", new RemoveProcessor.Factory(parameters.scriptService));
        processors.put("split", new SplitProcessor.Factory());
        processors.put("join", new JoinProcessor.Factory());
        processors.put("uppercase", new UppercaseProcessor.Factory());
        processors.put("lowercase", new LowercaseProcessor.Factory());
        processors.put("trim", new TrimProcessor.Factory());
        processors.put("convert", new ConvertProcessor.Factory());
        processors.put("gsub", new GsubProcessor.Factory());
        processors.put("fail", new FailProcessor.Factory(parameters.scriptService));
        processors.put("foreach", new ForEachProcessor.Factory(parameters.scriptService));
        processors.put("date_index_name", new DateIndexNameProcessor.Factory(parameters.scriptService));
        processors.put("sort", new SortProcessor.Factory());
        processors.put("grok", new GrokProcessor.Factory(GROK_PATTERNS, IngestCommonPlugin.createGrokThreadWatchdog(parameters)));
        processors.put("script", new ScriptProcessor.Factory(parameters.scriptService));
        processors.put("dot_expander", new DotExpanderProcessor.Factory());
        processors.put("json", new JsonProcessor.Factory());
        processors.put("kv", new KeyValueProcessor.Factory());
        processors.put("urldecode", new URLDecodeProcessor.Factory());
        processors.put("bytes", new BytesProcessor.Factory());
        processors.put("pipeline", new PipelineProcessor.Factory(parameters.ingestService));
        processors.put("dissect", new DissectProcessor.Factory());
        processors.put("drop", new DropProcessor.Factory());
        processors.put("html_strip", new HtmlStripProcessor.Factory());
        processors.put("csv", new CsvProcessor.Factory());
        return Collections.unmodifiableMap(processors);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)GrokProcessorGetAction.INSTANCE, GrokProcessorGetAction.TransportAction.class, new Class[0]));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Collections.singletonList(new GrokProcessorGetAction.RestAction());
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(WATCHDOG_INTERVAL, WATCHDOG_MAX_EXECUTION_TIME);
    }

    private static MatcherWatchdog createGrokThreadWatchdog(Processor.Parameters parameters) {
        long intervalMillis = ((TimeValue)WATCHDOG_INTERVAL.get(parameters.env.settings())).getMillis();
        long maxExecutionTimeMillis = ((TimeValue)WATCHDOG_MAX_EXECUTION_TIME.get(parameters.env.settings())).getMillis();
        return MatcherWatchdog.newInstance((long)intervalMillis, (long)maxExecutionTimeMillis, (LongSupplier)parameters.relativeTimeSupplier, parameters.scheduler::apply);
    }
}

