/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;

class MapperMergeValidator {
    MapperMergeValidator() {
    }

    public static void validateNewMappers(Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        HashSet<String> objectFullNames = new HashSet<String>();
        for (ObjectMapper objectMapper : objectMappers) {
            String fullPath = objectMapper.fullPath();
            if (objectFullNames.add(fullPath)) continue;
            throw new IllegalArgumentException("Object mapper [" + fullPath + "] is defined twice.");
        }
        HashSet<String> fieldNames = new HashSet<String>();
        for (FieldMapper fieldMapper : fieldMappers) {
            String name = fieldMapper.name();
            if (objectFullNames.contains(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined both as an object and a field.");
            }
            if (fieldNames.add(name)) continue;
            throw new IllegalArgumentException("Field [" + name + "] is defined twice.");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String name = fieldAliasMapper.name();
            if (objectFullNames.contains(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined both as an object and a field.");
            }
            if (fieldNames.contains(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined both as an alias and a concrete field.");
            }
            if (!hashSet.add(name)) {
                throw new IllegalArgumentException("Field [" + name + "] is defined twice.");
            }
            MapperMergeValidator.validateFieldAliasMapper(name, fieldAliasMapper.path(), fieldNames, hashSet);
        }
    }

    private static void validateFieldAliasMapper(String aliasName, String path, Set<String> fieldMappers, Set<String> fieldAliasMappers) {
        if (path.equals(aliasName)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias cannot refer to itself.");
        }
        if (fieldAliasMappers.contains(path)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias cannot refer to another alias.");
        }
        if (!fieldMappers.contains(path)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias must refer to an existing field in the mappings.");
        }
    }

    public static void validateFieldReferences(List<FieldMapper> fieldMappers, List<FieldAliasMapper> fieldAliasMappers, Map<String, ObjectMapper> fullPathObjectMappers, FieldTypeLookup fieldTypes, MetadataFieldMapper[] metadataMappers, DocumentMapper newMapper) {
        MapperMergeValidator.validateCopyTo(fieldMappers, fullPathObjectMappers, fieldTypes);
        MapperMergeValidator.validateFieldAliasTargets(fieldAliasMappers, fullPathObjectMappers);
        MapperMergeValidator.validateMetadataFieldMappers(metadataMappers, newMapper);
    }

    private static void validateCopyTo(List<FieldMapper> fieldMappers, Map<String, ObjectMapper> fullPathObjectMappers, FieldTypeLookup fieldTypes) {
        for (FieldMapper mapper : fieldMappers) {
            if (mapper.copyTo() == null || mapper.copyTo().copyToFields().isEmpty()) continue;
            String sourceParent = MapperMergeValidator.parentObject(mapper.name());
            if (sourceParent != null && fieldTypes.get(sourceParent) != null) {
                throw new IllegalArgumentException("[copy_to] may not be used to copy from a multi-field: [" + mapper.name() + "]");
            }
            String sourceScope = MapperMergeValidator.getNestedScope(mapper.name(), fullPathObjectMappers);
            for (String copyTo : mapper.copyTo().copyToFields()) {
                String copyToParent = MapperMergeValidator.parentObject(copyTo);
                if (copyToParent != null && fieldTypes.get(copyToParent) != null) {
                    throw new IllegalArgumentException("[copy_to] may not be used to copy to a multi-field: [" + copyTo + "]");
                }
                if (fullPathObjectMappers.containsKey(copyTo)) {
                    throw new IllegalArgumentException("Cannot copy to field [" + copyTo + "] since it is mapped as an object");
                }
                String targetScope = MapperMergeValidator.getNestedScope(copyTo, fullPathObjectMappers);
                MapperMergeValidator.checkNestedScopeCompatibility(sourceScope, targetScope);
            }
        }
    }

    private static void validateFieldAliasTargets(List<FieldAliasMapper> fieldAliasMappers, Map<String, ObjectMapper> fullPathObjectMappers) {
        for (FieldAliasMapper mapper : fieldAliasMappers) {
            String pathScope;
            String aliasName = mapper.name();
            String path = mapper.path();
            String aliasScope = MapperMergeValidator.getNestedScope(aliasName, fullPathObjectMappers);
            if (Objects.equals(aliasScope, pathScope = MapperMergeValidator.getNestedScope(path, fullPathObjectMappers))) continue;
            StringBuilder message = new StringBuilder("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias must have the same nested scope as its target. ");
            message.append(aliasScope == null ? "The alias is not nested" : "The alias's nested scope is [" + aliasScope + "]");
            message.append(", but ");
            message.append(pathScope == null ? "the target is not nested." : "the target's nested scope is [" + pathScope + "].");
            throw new IllegalArgumentException(message.toString());
        }
    }

    private static void validateMetadataFieldMappers(MetadataFieldMapper[] metadataMappers, DocumentMapper newMapper) {
        for (MetadataFieldMapper metadataFieldMapper : metadataMappers) {
            metadataFieldMapper.validate(newMapper.mappers());
        }
    }

    private static String getNestedScope(String path, Map<String, ObjectMapper> fullPathObjectMappers) {
        String parentPath = MapperMergeValidator.parentObject(path);
        while (parentPath != null) {
            ObjectMapper objectMapper = fullPathObjectMappers.get(parentPath);
            if (objectMapper != null && objectMapper.nested().isNested()) {
                return parentPath;
            }
            parentPath = MapperMergeValidator.parentObject(parentPath);
        }
        return null;
    }

    private static void checkNestedScopeCompatibility(String source, String target) {
        boolean targetIsParentOfSource;
        if (source == null || target == null) {
            targetIsParentOfSource = target == null;
        } else {
            boolean bl = targetIsParentOfSource = source.equals(target) || source.startsWith(target + ".");
        }
        if (!targetIsParentOfSource) {
            throw new IllegalArgumentException("Illegal combination of [copy_to] and [nested] mappings: [copy_to] may only copy data to the current nested document or any of its parents, however one [copy_to] directive is trying to copy data from nested object [" + source + "] to [" + target + "]");
        }
    }

    private static String parentObject(String field) {
        int lastDot = field.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return field.substring(0, lastDot);
    }
}

