/*
 * Decompiled with CFR 0.152.
 */
package docking.event.mouse;

import ghidra.util.Msg;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class GMouseListenerAdapter
extends MouseAdapter {
    private static final int LEFT = 1;
    private int lastMouseButton = -1;
    private boolean didConsume;
    private boolean didPopup;

    public boolean shouldConsume(MouseEvent e) {
        return false;
    }

    public void doubleClickTriggered(MouseEvent e) {
    }

    public void popupTriggered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.trace("'pressed'");
        if (e.isConsumed()) {
            return;
        }
        this.reset();
        if (this.consume(e)) {
            this.trace("\tevent consumed");
            return;
        }
        if (this.popup(e)) {
            this.trace("\tpopup triggered");
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.trace("'released'");
        if (e.isConsumed()) {
            return;
        }
        if (this.consume(e)) {
            this.trace("\tevent consumed");
            return;
        }
        if (this.popup(e)) {
            this.trace("\tpopup triggered");
            return;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            this.doMouseClicked(e);
        }
        finally {
            this.reset();
        }
    }

    private void doMouseClicked(MouseEvent e) {
        int currentButton;
        this.trace("'clicked'");
        int previousButton = this.lastMouseButton;
        this.lastMouseButton = currentButton = e.getButton();
        if (e.isConsumed()) {
            return;
        }
        if (this.consume(e) || this.didConsume) {
            this.trace("\tevent consumed on or before 'clicked'");
            return;
        }
        if (this.popup(e) || this.didPopup) {
            this.trace("\t popup triggered on or before 'clicked'");
            return;
        }
        if (e.getClickCount() % 2 == 0) {
            this.trace("\tdouble-click");
            if (this.bothClicksFromLeftButton(previousButton, currentButton)) {
                this.trace("\tdouble-click from left");
                this.doubleClickTriggered(e);
            }
        }
    }

    private boolean popup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.didPopup = true;
            this.popupTriggered(e);
            return true;
        }
        return false;
    }

    private boolean consume(MouseEvent e) {
        if (this.shouldConsume(e)) {
            this.didConsume = true;
            e.consume();
            return true;
        }
        return false;
    }

    private boolean bothClicksFromLeftButton(int previousButton, int currentButton) {
        if (previousButton != 1) {
            return false;
        }
        boolean isLeft = currentButton == 1;
        return isLeft;
    }

    private void reset() {
        this.didConsume = false;
        this.didPopup = false;
    }

    private void trace(String message) {
        Msg.trace(GMouseListenerAdapter.class, (Object)message);
    }
}

