/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import ghidra.util.filechooser.GhidraFileChooserModel;
import java.io.File;
import java.util.Comparator;

class FileComparator
implements Comparator<File> {
    static final int SORT_BY_NAME = 1111;
    static final int SORT_BY_SIZE = 2222;
    static final int SORT_BY_TIME = 3333;
    private GhidraFileChooserModel model;
    private int sortBy = 1111;

    FileComparator(GhidraFileChooserModel model) {
        this(model, 1111);
    }

    FileComparator(GhidraFileChooserModel model, int sortBy) {
        this.model = model;
        this.sortBy = sortBy;
    }

    @Override
    public int compare(File file1, File file2) {
        if (this.sortBy == 1111 || this.sortBy == 2222) {
            if (this.model.isDirectory(file1)) {
                if (this.model.isDirectory(file2)) {
                    int value = file1.getAbsolutePath().compareToIgnoreCase(file2.getAbsolutePath());
                    return value;
                }
                return -1;
            }
            if (this.model.isDirectory(file2)) {
                return 1;
            }
        } else if (this.sortBy == 3333) {
            if (this.model.isDirectory(file1)) {
                if (this.model.isDirectory(file2)) {
                    return this.compare(file1.lastModified(), file2.lastModified());
                }
                return -1;
            }
            if (this.model.isDirectory(file2)) {
                return 1;
            }
        }
        int value = 0;
        if (this.sortBy == 1111) {
            value = file1.getName().compareToIgnoreCase(file2.getName());
        } else if (this.sortBy == 2222) {
            value = this.compare(file1.length(), file2.length());
        } else if (this.sortBy == 3333) {
            value = this.compare(file1.lastModified(), file2.lastModified());
        }
        return value;
    }

    @Override
    private int compare(long l1, long l2) {
        if (l1 == l2) {
            return 0;
        }
        if (l1 - l2 > 0L) {
            return 1;
        }
        return -1;
    }
}

