/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data.rtti;

import ghidra.app.cmd.data.AbstractCreateDataBackgroundCmd;
import ghidra.app.cmd.data.CreateTypeDescriptorBackgroundCmd;
import ghidra.app.cmd.data.EHDataTypeUtilities;
import ghidra.app.cmd.data.TypeDescriptorModel;
import ghidra.app.cmd.data.rtti.Rtti1Model;
import ghidra.app.cmd.data.rtti.RttiUtil;
import ghidra.app.util.datatype.microsoft.DataApplyOptions;
import ghidra.app.util.datatype.microsoft.DataValidationOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.exception.CancelledException;

public class CreateRtti1BackgroundCmd
extends AbstractCreateDataBackgroundCmd<Rtti1Model> {
    private static final String RTTI_1_NAME = "RTTI Base Class Descriptor";

    public CreateRtti1BackgroundCmd(Address address, DataValidationOptions validationOptions, DataApplyOptions applyOptions) {
        super("RTTIBaseClassDescriptor", address, 1, validationOptions, applyOptions);
    }

    CreateRtti1BackgroundCmd(Rtti1Model rtti1Model, DataApplyOptions applyOptions) {
        super(rtti1Model, applyOptions);
    }

    @Override
    protected Rtti1Model createModel(Program program) {
        if (this.model == null || program != ((Rtti1Model)this.model).getProgram()) {
            this.model = new Rtti1Model(program, this.address, this.validationOptions);
        }
        return (Rtti1Model)this.model;
    }

    @Override
    protected boolean createAssociatedData() throws CancelledException {
        return this.createRtti0();
    }

    private boolean createRtti0() throws CancelledException {
        this.monitor.checkCanceled();
        CreateTypeDescriptorBackgroundCmd cmd = new CreateTypeDescriptorBackgroundCmd(((Rtti1Model)this.model).getRtti0Model(), this.applyOptions);
        return cmd.applyTo((DomainObject)((Rtti1Model)this.model).getProgram(), this.monitor);
    }

    @Override
    protected boolean createMarkup() throws CancelledException {
        this.monitor.checkCanceled();
        Program program = ((Rtti1Model)this.model).getProgram();
        TypeDescriptorModel rtti0Model = ((Rtti1Model)this.model).getRtti0Model();
        this.monitor.checkCanceled();
        if (rtti0Model != null) {
            Object suffix = "";
            try {
                suffix = " at " + this.getPMDAttrList(program);
            }
            catch (InvalidDataTypeException e) {
                String message = "Unable to get PMD and attributes for RTTI1 at " + this.address + ".";
                this.handleError(message);
            }
            EHDataTypeUtilities.createPlateCommentIfNeeded(program, RttiUtil.getDescriptorTypeNamespace(rtti0Model) + "::", RTTI_1_NAME, (String)suffix, this.address, this.applyOptions);
            this.monitor.checkCanceled();
            if (this.applyOptions.shouldCreateLabel()) {
                Object rtti1Suffix = RTTI_1_NAME + (String)suffix;
                rtti1Suffix = SymbolUtilities.replaceInvalidChars((String)rtti1Suffix, (boolean)true);
                RttiUtil.createSymbolFromDemangledType(program, this.address, rtti0Model, (String)rtti1Suffix);
            }
        }
        return true;
    }

    private String getPMDAttrList(Program program) throws InvalidDataTypeException {
        int mDisp = ((Rtti1Model)this.model).getMDisp();
        int pDisp = ((Rtti1Model)this.model).getPDisp();
        int vDisp = ((Rtti1Model)this.model).getVDisp();
        int attributes = ((Rtti1Model)this.model).getAttributes();
        return "(" + mDisp + "," + pDisp + "," + vDisp + "," + attributes + ")";
    }
}

