/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.odex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.odex.OdexConstants;
import ghidra.file.formats.android.odex.OdexHeader;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.BoundedInputStream;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

@FileSystemInfo(type="odex", description="ODEX", factory=GFileSystemBaseFactory.class)
public class OdexFileSystem
extends GFileSystemBase {
    private OdexHeader odexHeader;
    private GFileImpl dexFile;
    private GFileImpl depsFile;
    private GFileImpl auxFile;

    public OdexFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        if (file != null) {
            if (file.equals(this.dexFile)) {
                return new BoundedInputStream(this.provider.getInputStream((long)this.odexHeader.getDexOffset()), (long)this.odexHeader.getDexLength());
            }
            if (file.equals(this.depsFile)) {
                return new BoundedInputStream(this.provider.getInputStream((long)this.odexHeader.getDepsOffset()), (long)this.odexHeader.getDepsLength());
            }
            if (file.equals(this.auxFile)) {
                return new BoundedInputStream(this.provider.getInputStream((long)this.odexHeader.getAuxOffset()), (long)this.odexHeader.getAuxLength());
            }
        }
        return null;
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        StringBuilder builder = new StringBuilder();
        builder.append("Magic:       " + this.odexHeader.getMagic()).append("\n");
        builder.append("Dex Offset:  " + Integer.toHexString(this.odexHeader.getDexOffset())).append("\n");
        builder.append("Dex Length:  " + Integer.toHexString(this.odexHeader.getDexLength())).append("\n");
        builder.append("Deps Offset: " + Integer.toHexString(this.odexHeader.getDepsOffset())).append("\n");
        builder.append("Deps Length: " + Integer.toHexString(this.odexHeader.getDepsLength())).append("\n");
        builder.append("Aux Offset:  " + Integer.toHexString(this.odexHeader.getAuxOffset())).append("\n");
        builder.append("Aux Length:  " + Integer.toHexString(this.odexHeader.getAuxLength())).append("\n");
        builder.append("Flags:       " + Integer.toHexString(this.odexHeader.getFlags())).append("\n");
        return builder.toString();
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        ArrayList<GFile> list = new ArrayList<GFile>();
        if (directory == null || directory.equals(this.root)) {
            list.add((GFile)this.dexFile);
            list.add((GFile)this.depsFile);
            list.add((GFile)this.auxFile);
        }
        return list;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        return OdexConstants.isOdexFile(this.provider);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        BinaryReader reader = new BinaryReader(this.provider, true);
        this.odexHeader = new OdexHeader(reader);
        this.dexFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"dex", (boolean)false, (long)this.odexHeader.getDexLength(), null);
        this.depsFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"deps", (boolean)false, (long)this.odexHeader.getDepsLength(), null);
        this.auxFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"aux", (boolean)false, (long)this.odexHeader.getAuxLength(), null);
    }

    public void close() throws IOException {
        super.close();
        this.odexHeader = null;
        this.dexFile = null;
    }
}

