/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.ProgramContext;
import java.math.BigInteger;

public class ProgramProcessorContext
implements ProcessorContext {
    private Address addr;
    private ProgramContext context;

    public ProgramProcessorContext(ProgramContext context, Address addr) {
        this.context = context;
        this.addr = addr;
    }

    @Override
    public Register getBaseContextRegister() {
        return this.context.getBaseContextRegister();
    }

    @Override
    public Register[] getRegisters() {
        return this.context.getRegisters();
    }

    @Override
    public Register getRegister(String name) {
        return this.context.getRegister(name);
    }

    @Override
    public BigInteger getValue(Register register, boolean signed) {
        return this.context.getValue(register, this.addr, signed);
    }

    @Override
    public RegisterValue getRegisterValue(Register register) {
        return this.context.getRegisterValue(register, this.addr);
    }

    @Override
    public void setValue(Register register, BigInteger value) throws ContextChangeException {
        this.context.setValue(register, this.addr, this.addr, value);
    }

    @Override
    public void setRegisterValue(RegisterValue value) throws ContextChangeException {
        this.context.setRegisterValue(this.addr, this.addr, value);
    }

    @Override
    public void clearRegister(Register register) throws ContextChangeException {
        this.context.remove(this.addr, this.addr, register);
    }

    @Override
    public boolean hasValue(Register register) {
        return this.context.getValue(register, this.addr, true) != null;
    }
}

