/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.model.listing.FunctionTagManager;

public class CreateFunctionTagCmd
implements Command {
    private String name;
    private String comment;

    public CreateFunctionTagCmd(String name) {
        this.name = name;
        this.comment = "";
    }

    public CreateFunctionTagCmd(String name, String comment) {
        this.name = name;
        this.comment = comment;
    }

    public boolean applyTo(DomainObject obj) {
        ProgramDB program = (ProgramDB)obj;
        FunctionManagerDB functionManagerDB = (FunctionManagerDB)program.getFunctionManager();
        FunctionTagManager functionTagManager = functionManagerDB.getFunctionTagManager();
        functionTagManager.createFunctionTag(this.name, this.comment);
        return true;
    }

    public String getName() {
        return "Create Function Tag";
    }

    public String getStatusMsg() {
        return null;
    }
}

