/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.data.CreateStringCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.disassembler.AddressTable;
import ghidra.app.plugin.core.function.FunctionAnalyzer;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.cmd.CompoundBackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.OffsetReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class OperandReferenceAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Reference";
    private static final String DESCRIPTION = "Analyzes data referenced by instructions.";
    private static final String OPTION_NAME_ASCII = "Ascii String References";
    private static final String OPTION_NAME_UNICODE = "Unicode String References";
    private static final String OPTION_NAME_ALIGN_STRINGS = "Align End of Strings";
    private static final String OPTION_NAME_MIN_STRING_LENGTH = "Minimum String Length";
    private static final String OPTION_NAME_POINTER = "References to Pointers";
    private static final String OPTION_NAME_RELOCATION_GUIDE = "Relocation Table Guide";
    private static final String OPTION_NAME_SUBROUTINE = "Subroutine References";
    private static final String OPTION_NAME_ADDRESS_TABLE = "Create Address Tables";
    private static final String OPTION_NAME_SWITCH = "Switch Table References";
    private static final String OPTION_NAME_SWITCH_ALIGNMENT = "Address Table Alignment";
    private static final String OPTION_NAME_MINIMUM_TABLE_SIZE = "Address Table Minimum Size";
    private static final String OPTION_NAME_RESPECT_EXECUTE_FLAG = "Respect Execute Flag";
    private static final String OPTION_DESCRIPTION_ASCII = "Select this check box to create an ascii string if there is a reference to it.";
    private static final String OPTION_DESCRIPTION_UNICODE = "Select this check box to create a unicode string if there is a reference to it.";
    private static final String OPTION_DESCRIPTION_ALIGN_STRINGS = "Select this check box to align string length to the processors alignment if the trailing bytes are '0's";
    private static final String OPTION_DESCRIPTION_MIN_STRING_LENGTH = "Minimum number of bytes for a string to be valid.";
    private static final String OPTION_DESCRIPTION_POINTER = "Select this check box to create pointers if there is a reference to it.";
    private static final String OPTION_DESCRIPTION_RELOCATION_GUIDE = "Select this check box to use relocation table entries to guide pointer analysis.";
    private static final String OPTION_DESCRIPTION_SUBROUTINE = "Select this check box to bookmark code that is a valid subroutine code flow and disassemble there.\nNOTE: this no longer makes a function.";
    private static final String OPTION_DESCRIPTION_ADDRESS_TABLE = "Select this check box to create an address table if there is a reference to it.";
    private static final String OPTION_DESCRIPTION_SWITCH = "Select this check box to create a switch table if there is a reference to it.";
    private static final String OPTION_DESCRIPTION_SWITCH_ALIGNMENT = "Align Address Tables on this number of bytes.";
    private static final String OPTION_DESCRIPTION_MINIMUM_TABLE_SIZE = "Minimum run of valid pointers to be considered an address table.";
    private static final String OPTION_DESCRIPTION_RESPECT_EXECUTE_FLAG = "Respect Execute flag on memory blocks when checking entry points for code.";
    private static final boolean OPTION_DEFAULT_ASCII_ENABLED = true;
    private static final boolean OPTION_DEFAULT_UNICODE_ENABLED = true;
    private static final boolean OPTION_DEFAULT_ALIGN_STRINGS_ENABLED = false;
    private static final int OPTION_DEFAULT_MIN_STRING_LENGTH = 5;
    private static final boolean OPTION_DEFAULT_POINTER_ENABLED = true;
    private static final boolean OPTION_DEFAULT_RELOCATION_GUIDE_ENABLED = true;
    private static final boolean OPTION_DEFAULT_SUBROUTINES_ENABLED = true;
    private static final boolean OPTION_DEFAULT_ADDRESS_TABLES_ENABLED = true;
    private static final boolean OPTION_DEFAULT_SWITCH_TABLE_ENABLED = false;
    private static final int OPTION_DEFAULT_SWITCH_TABLE_ALIGNMENT = 1;
    private static final boolean OPTION_DEFAULT_RESPECT_EXECUTE_ENABLED = true;
    private static final int MINIMUM_POTENTIAL_TABLE_SIZE = 3;
    private static final int NOTIFICATION_INTERVAL = 256;
    private static final int MAX_NEG_ENTRIES = 32;
    private boolean asciiEnabled = true;
    private boolean unicodeEnabled = true;
    private boolean alignStringsEnabled = false;
    private int minStringLength = 5;
    private boolean pointerEnabled = true;
    private boolean relocationGuideEnabled = true;
    private boolean subroutinesEnabled = true;
    private boolean addressTablesEnabled = true;
    private int minimumAddressTableSize = -1;
    private boolean switchTableEnabled = false;
    private int switchTableAlignment = 1;
    private boolean newCodeFound = false;
    private int processorAlignment = 1;
    private MemoryBlock externalBlock;
    private boolean respectExecuteFlags = true;

    public OperandReferenceAnalyzer() {
        this(NAME, DESCRIPTION, AnalyzerType.INSTRUCTION_ANALYZER);
    }

    public OperandReferenceAnalyzer(String name, String description, AnalyzerType analyzerType) {
        super(name, description, analyzerType);
        this.setPriority(AnalysisPriority.REFERENCE_ANALYSIS);
    }

    @Override
    public boolean canAnalyze(Program program) {
        int bitSize;
        AddressSpace defaultAddressSpace = program.getAddressFactory().getDefaultAddressSpace();
        if (defaultAddressSpace instanceof SegmentedAddressSpace) {
            this.pointerEnabled = false;
            this.addressTablesEnabled = false;
        }
        return (bitSize = defaultAddressSpace.getSize()) > 16;
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        if (this.minimumAddressTableSize == -1) {
            this.calculateMinimumAddressTableSize(program);
        }
        this.addressTablesEnabled = "Portable Executable (PE)".equals(program.getExecutableFormat());
        if (this.minimumAddressTableSize == -1) {
            this.calculateMinimumAddressTableSize(program);
        }
        return true;
    }

    private void calculateMinimumAddressTableSize(Program program) {
        this.minimumAddressTableSize = AddressTable.getThresholdRunOfValidPointers(program, 0x40000000L);
        if (this.minimumAddressTableSize < 2) {
            this.minimumAddressTableSize = 2;
        }
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address target;
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
        if (!(this.asciiEnabled || this.unicodeEnabled || this.subroutinesEnabled)) {
            String message = "ASCII, Unicode, and Subroutines are all disabled.";
            log.appendMsg(this.getName(), message);
            log.setStatus(message);
            return false;
        }
        this.processorAlignment = program.getLanguage().getInstructionAlignment();
        this.externalBlock = program.getMemory().getBlock("EXTERNAL");
        this.newCodeFound = false;
        int count = 256;
        long initial_count = set.getNumAddresses();
        monitor.initialize(initial_count);
        AddressSet leftSet = new AddressSet(set);
        Listing listing = program.getListing();
        Memory memory = program.getMemory();
        AddressSet executeSet = this.getExecuteSet(memory);
        if (!this.respectExecuteFlags) {
            executeSet = null;
        }
        AddressSet ignoreNewPointers = new AddressSet();
        AddressIterator iter = program.getReferenceManager().getReferenceSourceIterator(set, true);
        PseudoDisassembler pdis = new PseudoDisassembler(program);
        pdis.setRespectExecuteFlag(this.respectExecuteFlags);
        monitor.setMessage("Analyze Operand References " + set.getMinAddress());
        AddressSet disTargets = new AddressSet();
        AddressSet foundCodeBookmarkLocations = new AddressSet();
        AddressSet doneSubTest = new AddressSet();
        AddressSet checkedTargets = new AddressSet();
        block0: while (iter.hasNext() && !this.newCodeFound) {
            CodeUnit cu;
            monitor.checkCanceled();
            Address addr = iter.next();
            if (++count > 256) {
                leftSet.deleteRange(leftSet.getMinAddress(), addr);
                monitor.setProgress(initial_count - leftSet.getNumAddresses());
                monitor.setMessage("Analyze OpRefs : " + addr);
                count = 0;
            }
            if (ignoreNewPointers.contains(addr) || (cu = listing.getCodeUnitContaining(addr)) == null) continue;
            Reference[] memRefs = cu.getReferencesFrom();
            ignoreNewPointers.addRange(cu.getMinAddress(), cu.getMaxAddress());
            for (int m = 0; m < memRefs.length && !monitor.isCancelled(); ++m) {
                RefType refType;
                AddressTable table;
                Reference reference = memRefs[m];
                target = reference.getToAddress();
                RefType memRefType = reference.getReferenceType();
                if (memRefType.isFlow() && !memRefType.isIndirect() && !(cu instanceof Data)) {
                    CreateFunctionCmd createFunctionCmd;
                    FunctionManager funcMgr;
                    Function func;
                    Function func2;
                    if (memRefType.isCall() && memRefType.isComputed() && (func2 = listing.getFunctionAt(target)) == null) {
                        FunctionAnalyzer anal = new FunctionAnalyzer();
                        AddressSet funcSet = new AddressSet(reference.getFromAddress());
                        mgr.scheduleOneTimeAnalysis(anal, (AddressSetView)funcSet);
                    }
                    if (memRefType.isJump()) {
                        this.checkForExternalJump(program, reference, monitor);
                    }
                    Instruction instr = (Instruction)cu;
                    if (!memRefType.isComputed() || memRefs.length > 2 || memRefType.isCall() && instr.getFlowType() != RefType.COMPUTED_CALL_TERMINATOR || (func = (funcMgr = program.getFunctionManager()).getFunctionContaining(reference.getFromAddress())) == null || func.isThunk() || !CreateThunkFunctionCmd.isThunk(program, func) || !(createFunctionCmd = new CreateFunctionCmd(null, func.getEntryPoint(), null, SourceType.ANALYSIS, false, true)).applyTo((DomainObject)program)) continue;
                    AutoAnalysisManager amgr = AutoAnalysisManager.getAnalysisManager(program);
                    amgr.functionDefined((AddressSetView)new AddressSet(func.getEntryPoint(), func.getEntryPoint()));
                    checkedTargets.delete(target, target);
                    continue;
                }
                if (checkedTargets.contains(target)) continue;
                checkedTargets.add(target);
                if (!reference.isMemoryReference() || !memory.contains(target) || ignoreNewPointers.contains(target)) continue;
                boolean stuffDefined = false;
                boolean isUndefinedStuff = false;
                Data data = listing.getDefinedDataContaining(target);
                if (data != null) {
                    DataType dt = data.getDataType();
                    stuffDefined = true;
                    if (!(dt instanceof StringDataType) && !data.isPointer()) {
                        if (!(dt instanceof Undefined)) continue;
                        isUndefinedStuff = true;
                    }
                } else {
                    Instruction targetInstr = listing.getInstructionContaining(target);
                    if (targetInstr != null) {
                        doneSubTest.addRange(targetInstr.getMinAddress(), targetInstr.getMaxAddress());
                        if (cu instanceof Instruction) {
                            if (!((Instruction)cu).getFlowType().isComputed()) {
                                if (!this.shouldBeValidFunction(program, targetInstr)) continue;
                                disTargets.addRange(target, target);
                                continue;
                            }
                        } else {
                            if (!this.shouldBeValidFunction(program, targetInstr)) continue;
                            disTargets.addRange(target, target);
                            continue;
                        }
                    }
                }
                Instruction instr = null;
                if (cu instanceof Instruction) {
                    instr = (Instruction)cu;
                }
                if (instr != null && (table = this.getAddressTable(program, instr, reference.getOperandIndex(), target, monitor)) != null && table.getNumberAddressEntries() >= this.minimumAddressTableSize) {
                    this.createFlowTable(program, instr, reference.getOperandIndex(), table, monitor);
                    if (!this.newCodeFound) continue;
                    leftSet = new AddressSet(set);
                    leftSet.deleteRange(leftSet.getMinAddress(), addr);
                    leftSet.addRange(addr, addr);
                    continue block0;
                }
                if (!(!this.subroutinesEnabled || isUndefinedStuff || doneSubTest.contains(target) || (refType = reference.getReferenceType()).isRead() || refType.isWrite() || this.hasDataAccessReferences(program, target))) {
                    if (instr != null && (instr.getFlowType().isJump() || instr.getFlowType().isCall())) continue;
                    if (instr == null || !this.isUsedForCalculation(instr, target)) {
                        Address fromAddress = reference.getFromAddress();
                        if (executeSet == null || executeSet.contains(target) || this.isFunctionPointer(listing, fromAddress)) {
                            doneSubTest.addRange(target, target);
                            Symbol sym = program.getSymbolTable().getSymbol(reference);
                            if (pdis.isValidSubroutine(target, instr == null)) {
                                if (instr != null) {
                                    foundCodeBookmarkLocations.addRange(target, target);
                                }
                                if (sym == null || !sym.getName().startsWith("AddrTable")) {
                                    disTargets.addRange(target, target);
                                }
                            }
                        }
                    }
                }
                if (stuffDefined && !isUndefinedStuff || this.asciiEnabled && this.checkForAscii(program, pdis, target) || this.unicodeEnabled && this.checkForUnicode(program, pdis, target) || !this.pointerEnabled || disTargets.contains(target) || !this.checkForPointer(program, pdis, target, true) || (data = program.getListing().getDefinedDataAt(target)) == null || !data.isPointer()) continue;
                Address ptrAddr = data.getAddress(0);
                ignoreNewPointers.addRange(ptrAddr, ptrAddr);
            }
        }
        AddressIterator aiter = disTargets.getAddresses(true);
        AddressSet throwOutSet = new AddressSet();
        AddressSet doneDisSet = new AddressSet();
        while (aiter.hasNext()) {
            Address addr = aiter.next();
            Data data = program.getListing().getDataContaining(addr);
            if (data != null) {
                if (!data.isDefined()) continue;
                throwOutSet.add(addr);
                continue;
            }
            Instruction instr = program.getListing().getInstructionContaining(addr);
            if (instr == null) continue;
            doneDisSet.add(addr);
        }
        if (!(disTargets = disTargets.subtract((AddressSetView)throwOutSet)).isEmpty()) {
            AddressSet doDisTargets = disTargets.subtract((AddressSetView)doneDisSet);
            if (!doDisTargets.isEmpty()) {
                CompoundBackgroundCommand cmd = this.createDisassemblyCommandsForAddress(program, doDisTargets);
                mgr.schedule((BackgroundCommand)cmd, AnalysisPriority.REFERENCE_ANALYSIS.after().after().priority());
            }
            this.createFunctions(program, disTargets);
            foundCodeBookmarkLocations = foundCodeBookmarkLocations.subtract((AddressSetView)throwOutSet);
            AddressIterator foundIter = foundCodeBookmarkLocations.getAddresses(true);
            while (foundIter.hasNext()) {
                target = foundIter.next();
                program.getBookmarkManager().setBookmark(target, "Analysis", "Found Code", "Found code from operand reference");
            }
        }
        if (this.newCodeFound && !leftSet.isEmpty()) {
            mgr.scheduleOneTimeAnalysis(this, (AddressSetView)leftSet);
        }
        return true;
    }

    private CompoundBackgroundCommand createDisassemblyCommandsForAddress(Program program, AddressSet locations) {
        CompoundBackgroundCommand backCmd = new CompoundBackgroundCommand(OPTION_NAME_SUBROUTINE, false, true);
        Listing listing = program.getListing();
        int align = program.getLanguage().getInstructionAlignment();
        AddressIterator iter = locations.getAddresses(true);
        for (Address addr : iter) {
            Address targetAddr = PseudoDisassembler.getNormalizedDisassemblyAddress((Program)program, (Address)addr);
            if (targetAddr.getOffset() % (long)align != 0L || listing.getUndefinedDataAt(targetAddr) == null) continue;
            DisassembleCommand disassembleCmd = new DisassembleCommand(addr, null, true);
            RegisterValue rval = PseudoDisassembler.getTargetContextRegisterValueForDisassembly((Program)program, (Address)addr);
            disassembleCmd.setInitialContext(rval);
            backCmd.add((BackgroundCommand)disassembleCmd);
        }
        return backCmd;
    }

    private boolean hasDataAccessReferences(Program program, Address target) {
        ReferenceIterator referencesTo = program.getReferenceManager().getReferencesTo(target);
        while (referencesTo.hasNext()) {
            Reference reference = referencesTo.next();
            RefType referenceType = reference.getReferenceType();
            if (!referenceType.isRead() && !referenceType.isWrite()) continue;
            return true;
        }
        return false;
    }

    private boolean checkForExternalJump(Program program, Reference reference, TaskMonitor monitor) throws CancelledException {
        Function func;
        if (this.externalBlock == null) {
            return false;
        }
        Address toAddr = reference.getToAddress();
        if (!this.externalBlock.contains(toAddr)) {
            return false;
        }
        Address fromAddr = reference.getFromAddress();
        Instruction instr = program.getListing().getInstructionAt(fromAddr);
        if (instr != null && instr.getFlowType().isJump()) {
            instr.setFlowOverride(FlowOverride.CALL_RETURN);
            AddressSet set = new AddressSet(toAddr);
            program.getBookmarkManager().removeBookmarks((AddressSetView)set, "Error", "Bad Instruction", monitor);
        }
        if ((func = program.getFunctionManager().getFunctionAt(toAddr)) == null) {
            CreateFunctionCmd createFuncCmd = new CreateFunctionCmd(null, toAddr, (AddressSetView)new AddressSet(toAddr, toAddr), SourceType.ANALYSIS);
            createFuncCmd.applyTo((DomainObject)program);
        }
        return true;
    }

    protected void createFunctions(Program program, AddressSet functionStarts) {
    }

    private boolean shouldBeValidFunction(Program program, Instruction targetInstr) {
        Function func = program.getFunctionManager().getFunctionContaining(targetInstr.getMinAddress());
        if (func != null) {
            return false;
        }
        ReferenceIterator refs = program.getReferenceManager().getReferencesTo(targetInstr.getMinAddress());
        while (refs.hasNext()) {
            Reference ref = refs.next();
            RefType refType = ref.getReferenceType();
            if (refType.isFlow()) {
                return false;
            }
            if (!refType.isRead() && !refType.isWrite()) continue;
            return false;
        }
        return true;
    }

    private boolean isUsedForCalculation(Instruction instr, Address targetValue) {
        PcodeOp[] pcode = instr.getPcode();
        Varnode target = null;
        for (PcodeOp element : pcode) {
            Varnode[] inputs;
            int op = element.getOpcode();
            switch (op) {
                case 2: 
                case 3: {
                    if (!element.getInput(1).equals(target)) break;
                    return true;
                }
            }
            for (Varnode input : inputs = element.getInputs()) {
                if ((target == null || !target.equals((Object)input)) && (!input.isConstant() || input.getOffset() != targetValue.getUnsignedOffset()) || op == 2 || op == 3) continue;
                if (op != 1) {
                    return true;
                }
                Varnode pt = element.getOutput();
                if (pt == null) continue;
                target = pt;
            }
        }
        return false;
    }

    private boolean isFunctionPointer(Listing listing, Address fromAddress) {
        Pointer pointer;
        DataType pointerDataType;
        int offset;
        Data primitiveAt;
        DataType dataType3;
        Data fromData = listing.getDataContaining(fromAddress);
        return fromData != null && (dataType3 = (primitiveAt = fromData.getPrimitiveAt(offset = (int)fromAddress.subtract(fromData.getAddress()))).getDataType()) instanceof Pointer && (pointerDataType = (pointer = (Pointer)dataType3).getDataType()) instanceof FunctionDefinition;
    }

    private AddressSet getExecuteSet(Memory memory) {
        MemoryBlock[] blocks;
        AddressSet set = new AddressSet();
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            if (!block.isExecute()) continue;
            set.addRange(block.getStart(), block.getEnd());
        }
        return set.isEmpty() ? null : set;
    }

    private AddressTable getAddressTable(Program program, Instruction instr, int opIndex, Address target, TaskMonitor monitor) {
        int i;
        FlowType ftype = instr.getFlowType();
        if ((ftype.isJump() || ftype.isCall()) && ftype.isComputed() && instr.getNumOperands() == 1 && instr.getAddress(0) != null) {
            return null;
        }
        AddressTable table = AddressTable.getEntry(program, target, monitor, true, 3, this.switchTableAlignment, 0, 1024L, this.relocationGuideEnabled);
        if (table != null) {
            Reference[] refs;
            for (Reference ref : refs = instr.getOperandReferences(opIndex)) {
                OffsetReference oref;
                if (!ref.isOffsetReference() || (oref = (OffsetReference)ref).getOffset() >= -4L) continue;
                table.setNegativeTable(true);
            }
            return table;
        }
        if (!this.switchTableEnabled || !ftype.isJump() && !ftype.isCall() || !ftype.isComputed()) {
            return null;
        }
        Object[] opObjects = instr.getOpObjects(opIndex);
        long entryLen = 0L;
        for (Object opObject : opObjects) {
            Scalar sc;
            long value;
            if (!(opObject instanceof Scalar) || (value = (sc = (Scalar)opObject).getUnsignedValue()) != 4L && value != 2L && value != 8L) continue;
            entryLen = value;
            break;
        }
        if (entryLen == 0L) {
            return null;
        }
        AddressTable lastGoodTable = null;
        Address negAddr = null;
        for (i = 0; i < 32; ++i) {
            AddressTable negTable;
            try {
                negAddr = target.subtractNoWrap((long)(i + 3) * entryLen);
            }
            catch (AddressOverflowException e) {
                break;
            }
            if (program.getListing().getInstructionContaining(negAddr) != null || (negTable = AddressTable.getEntry(program, negAddr, monitor, false, 3, this.switchTableAlignment, 0, 1024L, this.relocationGuideEnabled)) == null) break;
            lastGoodTable = negTable;
            negTable.setNegativeTable(true);
        }
        if (i == 32) {
            return null;
        }
        if (lastGoodTable != null) {
            instr.removeOperandReference(opIndex, target);
            program.getReferenceManager().addOffsetMemReference(instr.getMinAddress(), lastGoodTable.getTopAddress(), -((long)(i + 3) * entryLen), RefType.DATA, SourceType.ANALYSIS, opIndex);
        }
        return lastGoodTable;
    }

    private void createFlowTable(Program program, Instruction instr, int opindex, AddressTable table, TaskMonitor monitor) {
        FlowType ftype = instr.getFlowType();
        if (ftype.isJump() || ftype.isCall()) {
            if (!this.switchTableEnabled) {
                return;
            }
            this.newCodeFound |= table.createSwitchTable(program, instr, opindex, true, monitor);
        }
        if (!this.addressTablesEnabled) {
            return;
        }
        if (this.clearAllUndefined(program, table.getTopAddress(), table.getByteLength())) {
            table.makeTable(program, 0, table.getNumberAddressEntries(), false);
        }
    }

    private boolean checkForAscii(Program program, PseudoDisassembler pdis, Address target) {
        int asciiLen = this.checkAnsiString(program.getMemory(), target);
        if (asciiLen > 0) {
            if (this.desiredDataMemoryContainsReference(program, target, asciiLen)) {
                return asciiLen > 4;
            }
            if (!this.isValidInstruction(pdis, target) && this.clearAllUndefined(program, target, asciiLen)) {
                CreateStringCmd cmd = new CreateStringCmd(target, asciiLen, false);
                cmd.applyTo((DomainObject)program);
            }
            return true;
        }
        return false;
    }

    private boolean checkForUnicode(Program program, PseudoDisassembler pdis, Address target) {
        int uniLen = this.checkUnicodeString(program.getMemory(), target);
        if (uniLen > 0) {
            if (this.desiredDataMemoryContainsReference(program, target, uniLen)) {
                return false;
            }
            if (!this.isValidInstruction(pdis, target) && this.clearAllUndefined(program, target, uniLen)) {
                CreateStringCmd cmd = new CreateStringCmd(target, 2 * (uniLen + 1), true);
                cmd.applyTo((DomainObject)program);
            }
            return true;
        }
        return false;
    }

    private boolean clearAllUndefined(Program program, Address start, int lenBytes) {
        if (lenBytes < 1) {
            return false;
        }
        AddressSet set = new AddressSet(start, start.add((long)(lenBytes - 1)));
        if (program.getListing().isUndefined(set.getMinAddress(), set.getMaxAddress())) {
            return true;
        }
        CodeUnitIterator iter = program.getListing().getCodeUnits((AddressSetView)set, true);
        while (iter.hasNext()) {
            CodeUnit codeUnit = iter.next();
            if (!(codeUnit instanceof Data)) {
                return false;
            }
            Data data = (Data)codeUnit;
            DataType dt = data.getDataType();
            if (Undefined.isUndefined((DataType)dt)) continue;
            return false;
        }
        program.getListing().clearCodeUnits(set.getMinAddress(), set.getMaxAddress(), false);
        return true;
    }

    private boolean desiredDataMemoryContainsReference(Program program, Address rangeStartAddress, int rangeLength) {
        AddressSpace nextSpace;
        Address nextAddress;
        try {
            nextAddress = rangeStartAddress.add(1L);
        }
        catch (AddressOutOfBoundsException e) {
            return false;
        }
        AddressIterator iterator = program.getReferenceManager().getReferenceDestinationIterator(nextAddress, true);
        Address referenceAddress = iterator.next();
        if (referenceAddress == null) {
            return false;
        }
        AddressSpace targetSpace = rangeStartAddress.getAddressSpace();
        if (!targetSpace.equals(nextSpace = referenceAddress.getAddressSpace())) {
            return false;
        }
        long distance = referenceAddress.subtract(rangeStartAddress);
        return distance < (long)rangeLength;
    }

    private boolean checkForPointer(Program program, PseudoDisassembler pdis, Address target, boolean doit) {
        try {
            Symbol[] syms;
            if (this.relocationGuideEnabled && !this.isValidRelocationAddress(program, target)) {
                return false;
            }
            Memory memory = program.getMemory();
            Address testAddr = PointerDataType.getAddressValue((MemBuffer)new DumbMemBufferImpl(memory, target), (int)program.getDefaultPointerSize(), (AddressSpace)target.getAddressSpace());
            if (testAddr == null || testAddr.getOffset() >= 0L && testAddr.getOffset() < 4096L) {
                return false;
            }
            if (testAddr.getOffset() % (long)this.switchTableAlignment != 0L) {
                return false;
            }
            if (!(memory.contains(testAddr) || (syms = program.getSymbolTable().getSymbols(testAddr)) != null && syms.length != 0 && syms[0].getSource() != SourceType.DEFAULT)) {
                return false;
            }
            if (this.desiredDataMemoryContainsReference(program, target, target.getPointerSize())) {
                return false;
            }
            CodeUnit cu = program.getListing().getCodeUnitContaining(testAddr);
            if (cu != null && !cu.getMinAddress().equals((Object)testAddr)) {
                return false;
            }
            if (cu instanceof Instruction) {
                Function func;
                Instruction instr = (Instruction)cu;
                if (instr.isInDelaySlot()) {
                    return false;
                }
                Address fallFrom = instr.getFallFrom();
                if (fallFrom != null ? program.getFunctionManager().getFunctionAt(instr.getMinAddress()) == null : (func = program.getFunctionManager().getFunctionContaining(testAddr)) != null && !func.getEntryPoint().equals((Object)testAddr)) {
                    return false;
                }
            }
            if (doit && this.clearAllUndefined(program, target, program.getDefaultPointerSize())) {
                DataType adt = program.getDataTypeManager().addDataType((DataType)new PointerDataType(), null);
                CreateDataCmd cmd = new CreateDataCmd(target, adt);
                cmd.applyTo((DomainObject)program);
            }
            return true;
        }
        catch (AddressOutOfBoundsException e) {
            return false;
        }
    }

    private boolean isValidRelocationAddress(Program program, Address target) {
        RelocationTable relocationTable = program.getRelocationTable();
        return !relocationTable.isRelocatable() || relocationTable.getSize() <= 0 || relocationTable.getRelocation(target) != null;
    }

    private boolean isValidInstruction(PseudoDisassembler pdis, Address target) {
        return false;
    }

    private int checkAnsiString(Memory mem, Address adref) {
        int len = this.getStringLength(mem, adref, this.processorAlignment);
        if (len <= 0) {
            return 0;
        }
        return len;
    }

    private int checkUnicodeString(Memory mem, Address adref) {
        int len = this.getWStrLen(mem, adref);
        if (len <= 0) {
            return 0;
        }
        int len2 = this.getWStrLen(mem, adref.subtractWrap(8L));
        if (len2 > len + 2) {
            return 0;
        }
        if (len > 3) {
            return len;
        }
        return 0;
    }

    int getStringLength(Memory memory, Address startAddress, int stringAlignment) {
        try {
            int numAlignBytes;
            int modAlignment;
            byte[] bytes = new byte[1000];
            int numBytes = memory.getBytes(startAddress, bytes);
            int nullOffset = this.getNullTerminatorOffset(bytes, numBytes);
            if (nullOffset < 0 || nullOffset < this.minStringLength) {
                return -1;
            }
            int length = nullOffset + 1;
            if (this.alignStringsEnabled && (modAlignment = length % stringAlignment) != 0 && (length += (numAlignBytes = stringAlignment - modAlignment)) > numBytes) {
                return -1;
            }
            return length;
        }
        catch (MemoryAccessException e) {
            return -1;
        }
    }

    private int getNullTerminatorOffset(byte[] bytes, int numBytes) {
        for (int i = 0; i < numBytes; ++i) {
            if (bytes[i] == 0) {
                return i;
            }
            if (this.isValidAsciiByte(bytes[i])) continue;
            return -1;
        }
        return -1;
    }

    private boolean isValidAsciiByte(byte b) {
        int TAB = 9;
        int CARRIAGE_RETURN = 10;
        int LINE_FEED = 13;
        if (b >= 127) {
            return false;
        }
        return b >= 32 || b == 9 || b == 10 || b == 13;
    }

    int getWStrLen(Memory memory, Address ad) {
        try {
            for (int i = 0; i < 1000; ++i) {
                short value = memory.getShort(ad.addWrap((long)(2 * i)));
                if (value == 0) {
                    return i;
                }
                if (value == 9 || value == 10 || value == 13 || value >= 32 && value < 127) continue;
                return -1;
            }
        }
        catch (MemoryAccessException e) {
            return -1;
        }
        return -1;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        HelpLocation helpLocation = new HelpLocation("AutoAnalysisPlugin", "Auto_Analysis_Option_Instruction" + this.getAnalysisType());
        if (this.minimumAddressTableSize == -1) {
            this.calculateMinimumAddressTableSize(program);
        }
        options.registerOption(OPTION_NAME_ASCII, (Object)this.asciiEnabled, helpLocation, OPTION_DESCRIPTION_ASCII);
        options.registerOption(OPTION_NAME_UNICODE, (Object)this.unicodeEnabled, helpLocation, OPTION_DESCRIPTION_UNICODE);
        options.registerOption(OPTION_NAME_ALIGN_STRINGS, (Object)this.alignStringsEnabled, helpLocation, OPTION_DESCRIPTION_ALIGN_STRINGS);
        options.registerOption(OPTION_NAME_MIN_STRING_LENGTH, (Object)this.minStringLength, helpLocation, OPTION_DESCRIPTION_MIN_STRING_LENGTH);
        options.registerOption(OPTION_NAME_POINTER, (Object)this.pointerEnabled, helpLocation, OPTION_DESCRIPTION_POINTER);
        options.registerOption(OPTION_NAME_RELOCATION_GUIDE, (Object)this.relocationGuideEnabled, helpLocation, OPTION_DESCRIPTION_RELOCATION_GUIDE);
        options.registerOption(OPTION_NAME_SUBROUTINE, (Object)this.subroutinesEnabled, helpLocation, OPTION_DESCRIPTION_SUBROUTINE);
        options.registerOption(OPTION_NAME_ADDRESS_TABLE, (Object)this.addressTablesEnabled, helpLocation, OPTION_DESCRIPTION_ADDRESS_TABLE);
        options.registerOption(OPTION_NAME_SWITCH, (Object)this.switchTableEnabled, helpLocation, OPTION_DESCRIPTION_SWITCH);
        options.registerOption(OPTION_NAME_SWITCH_ALIGNMENT, (Object)this.switchTableAlignment, helpLocation, OPTION_DESCRIPTION_SWITCH_ALIGNMENT);
        options.registerOption(OPTION_NAME_MINIMUM_TABLE_SIZE, (Object)this.minimumAddressTableSize, helpLocation, OPTION_DESCRIPTION_MINIMUM_TABLE_SIZE);
        options.registerOption(OPTION_NAME_RESPECT_EXECUTE_FLAG, (Object)this.respectExecuteFlags, helpLocation, OPTION_DESCRIPTION_RESPECT_EXECUTE_FLAG);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.minStringLength = options.getInt(OPTION_NAME_MIN_STRING_LENGTH, this.minStringLength);
        this.switchTableAlignment = options.getInt(OPTION_NAME_SWITCH_ALIGNMENT, this.switchTableAlignment);
        this.minimumAddressTableSize = options.getInt(OPTION_NAME_MINIMUM_TABLE_SIZE, this.minimumAddressTableSize);
        this.asciiEnabled = options.getBoolean(OPTION_NAME_ASCII, this.asciiEnabled);
        this.unicodeEnabled = options.getBoolean(OPTION_NAME_UNICODE, this.unicodeEnabled);
        this.alignStringsEnabled = options.getBoolean(OPTION_NAME_ALIGN_STRINGS, this.alignStringsEnabled);
        this.pointerEnabled = options.getBoolean(OPTION_NAME_POINTER, this.pointerEnabled);
        this.relocationGuideEnabled = options.getBoolean(OPTION_NAME_RELOCATION_GUIDE, this.relocationGuideEnabled);
        this.subroutinesEnabled = options.getBoolean(OPTION_NAME_SUBROUTINE, this.subroutinesEnabled);
        this.addressTablesEnabled = options.getBoolean(OPTION_NAME_ADDRESS_TABLE, this.addressTablesEnabled);
        this.switchTableEnabled = options.getBoolean(OPTION_NAME_SWITCH, this.switchTableEnabled);
        this.respectExecuteFlags = options.getBoolean(OPTION_NAME_RESPECT_EXECUTE_FLAG, this.respectExecuteFlags);
    }
}

