/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.html.DataTypeLine;
import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.util.exception.AssertException;
import java.awt.Color;

public class EmptyDataTypeLine
extends DataTypeLine
implements PlaceHolderLine {
    public EmptyDataTypeLine() {
        super("", "", "", null, false);
    }

    @Override
    public ValidatableLine copy() {
        return new EmptyDataTypeLine();
    }

    @Override
    public void updateColor(ValidatableLine otherValidatableLine, Color invalidColor) {
        if (invalidColor == null) {
            throw new NullPointerException("Color cannot be null");
        }
        if (otherValidatableLine == null || otherValidatableLine instanceof EmptyDataTypeLine) {
            return;
        }
        if (!(otherValidatableLine instanceof DataTypeLine)) {
            throw new AssertException("DataTypeLine can only be matched against other DataTypeLine implementations.");
        }
        DataTypeLine otherLine = (DataTypeLine)otherValidatableLine;
        otherLine.setAllColors(invalidColor);
    }

    boolean matches(DataTypeLine otherLine) {
        return false;
    }

    @Override
    boolean matchesName(String otherName) {
        return false;
    }

    @Override
    boolean matchesType(String otherType) {
        return false;
    }

    @Override
    boolean matchesComment(String otherComment) {
        return false;
    }

    @Override
    public boolean isValidated() {
        return true;
    }

    @Override
    public String toString() {
        return "<Empty Line>";
    }
}

