/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import generic.continues.GenericFactory;
import generic.continues.RethrowContinuesFactory;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.elf.ElfException;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.util.StringUtilities;
import java.util.List;

public class ElfLoaderOptionsFactory {
    public static final String PERFORM_RELOCATIONS_NAME = "Perform Symbol Relocations";
    static final boolean PERFORM_RELOCATIONS_DEFAULT = true;
    public static final String IMAGE_BASE_OPTION_NAME = "Image Base";
    public static final long IMAGE_BASE_DEFAULT = 65536L;
    public static final long IMAGE64_BASE_DEFAULT = 0x100000L;
    public static final String INCLUDE_OTHER_BLOCKS = "Import Non-Loaded Data";
    static final boolean INCLUDE_OTHER_BLOCKS_DEFAULT = true;
    public static final String RESOLVE_EXTERNAL_SYMBOLS_OPTION_NAME = "Fixup Unresolved External Symbols";
    public static final boolean RESOLVE_EXTERNAL_SYMBOLS_DEFAULT = true;

    private ElfLoaderOptionsFactory() {
    }

    static void addOptions(List<Option> options, ByteProvider provider, LoadSpec loadSpec) throws ElfException, LanguageNotFoundException {
        options.add(new Option(PERFORM_RELOCATIONS_NAME, true, Boolean.class, "-loader-applyRelocations"));
        ElfHeader elf = ElfHeader.createElfHeader((GenericFactory)RethrowContinuesFactory.INSTANCE, provider);
        long imageBase = elf.findImageBase();
        if (imageBase == 0L && (elf.isRelocatable() || elf.isSharedObject())) {
            imageBase = elf.is64Bit() ? 0x100000L : 65536L;
        }
        AddressSpace defaultSpace = loadSpec.getLanguageCompilerSpec().getLanguage().getDefaultSpace();
        String baseOffsetStr = ElfLoaderOptionsFactory.getBaseOffsetString(imageBase, defaultSpace);
        options.add(new Option(IMAGE_BASE_OPTION_NAME, baseOffsetStr, String.class, "-loader-imagebase"));
        options.add(new Option(INCLUDE_OTHER_BLOCKS, true, Boolean.class, "-loader-includeOtherBlocks"));
        options.add(new Option(RESOLVE_EXTERNAL_SYMBOLS_OPTION_NAME, true, Boolean.class, "-loader-resolveExternalSymbols"));
    }

    private static String getBaseOffsetString(long imageBase, AddressSpace defaultSpace) {
        long maxOffset = defaultSpace.getMaxAddress().getAddressableWordOffset();
        while (Long.compareUnsigned(imageBase, maxOffset) > 0) {
            imageBase >>>= 4;
        }
        String baseOffsetStr = Long.toHexString(imageBase);
        int minNibbles = Math.min(8, defaultSpace.getSize() / 4);
        int baseOffsetStrLen = baseOffsetStr.length();
        if (baseOffsetStrLen < minNibbles) {
            baseOffsetStr = StringUtilities.pad((String)baseOffsetStr, (char)'0', (int)(minNibbles - baseOffsetStrLen));
        }
        return baseOffsetStr;
    }

    static String validateOptions(LoadSpec loadSpec, List<Option> options) {
        for (Option option : options) {
            String name = option.getName();
            if (name.equals(PERFORM_RELOCATIONS_NAME)) {
                if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
            if (name.equals(INCLUDE_OTHER_BLOCKS)) {
                if (Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
            if (!name.equals(IMAGE_BASE_OPTION_NAME)) continue;
            if (!String.class.isAssignableFrom(option.getValueClass())) {
                return "Invalid type for option: " + name + " - " + option.getValueClass();
            }
            String value = (String)option.getValue();
            try {
                AddressSpace space = loadSpec.getLanguageCompilerSpec().getLanguage().getDefaultSpace();
                space.getAddress(Long.parseUnsignedLong(value, 16));
            }
            catch (NumberFormatException e) {
                return "Invalid " + name + " - expecting hexidecimal address offset";
            }
            catch (AddressOutOfBoundsException e) {
                return "Invalid " + name + " - " + e.getMessage();
            }
            catch (LanguageNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static boolean performRelocations(List<Option> options) {
        return OptionUtils.getOption(PERFORM_RELOCATIONS_NAME, options, true);
    }

    static boolean includeOtherBlocks(List<Option> options) {
        return OptionUtils.getOption(INCLUDE_OTHER_BLOCKS, options, true);
    }

    static boolean hasImageBaseOption(List<Option> options) {
        return OptionUtils.containsOption(IMAGE_BASE_OPTION_NAME, options);
    }

    public static String getImageBaseOption(List<Option> options) {
        return OptionUtils.getOption(IMAGE_BASE_OPTION_NAME, options, null);
    }
}

