/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.mvc;

import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

public class FGData {
    private FunctionGraph graph;
    private final String errorMessage;
    private final Function function;

    public FGData(Function function, FunctionGraph graph) {
        this(function, graph, null);
    }

    public FGData(Function function, FunctionGraph graph, String errorMessage) {
        this.function = function;
        this.graph = graph;
        this.errorMessage = errorMessage;
    }

    public FunctionGraph getFunctionGraph() {
        return this.graph;
    }

    public boolean hasResults() {
        return true;
    }

    public String getMessage() {
        return this.errorMessage;
    }

    public boolean containsLocation(ProgramLocation location) {
        if (!this.hasResults()) {
            return false;
        }
        if (location == null) {
            return false;
        }
        Address address = location.getAddress();
        return this.function.getBody().contains(address);
    }

    public boolean containsSelection(ProgramSelection selection) {
        if (!this.hasResults()) {
            return false;
        }
        if (selection == null || selection.isEmpty()) {
            return true;
        }
        return this.function.getBody().intersects((AddressSetView)selection);
    }

    public Function getFunction() {
        return this.function;
    }

    public FunctionGraphOptions getOptions() {
        if (this.graph == null) {
            return null;
        }
        return this.graph.getOptions();
    }

    public void dispose() {
        if (this.graph == null) {
            return;
        }
        this.graph.dispose();
        this.graph = null;
    }

    public String toString() {
        return "FunctionGraphData[" + this.function.getName() + "]";
    }
}

