/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.List;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingComboBox;
import org.openstreetmap.josm.gui.widgets.ComboBoxHistory;
import org.openstreetmap.josm.spi.preferences.Config;

public class HistoryComboBox
extends AutoCompletingComboBox {
    private final ComboBoxHistory model;
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 15;

    public HistoryComboBox() {
        int maxsize = Config.getPref().getInt("search.history-size", 15);
        this.model = new ComboBoxHistory(maxsize);
        this.setModel(this.model);
        this.setEditable(true);
    }

    public String getText() {
        return this.getEditorComponent().getText();
    }

    public void setText(String value) {
        this.setAutocompleteEnabled(false);
        this.getEditorComponent().setText(value);
        this.setAutocompleteEnabled(true);
    }

    public void addCurrentItemToHistory() {
        this.model.addElement((String)this.getEditor().getItem());
    }

    public void setHistory(List<String> history) {
        this.model.setItemsAsString(history);
    }

    public List<String> getHistory() {
        return this.model.asStringList();
    }
}

