"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var constants_1 = require("../../../../specs/constants");
var get_chart_container_dimensions_1 = require("../../../../state/selectors/get_chart_container_dimensions");
var get_chart_theme_1 = require("../../../../state/selectors/get_chart_theme");
var utils_1 = require("../../../../state/utils");
var viewmodel_types_1 = require("../../layout/types/viewmodel_types");
var scenegraph_1 = require("./scenegraph");
var tree_1 = require("./tree");
var getSpecs = function (state) { return state.specs; };
exports.partitionGeometries = re_reselect_1.default([getSpecs, get_chart_container_dimensions_1.getChartContainerDimensionsSelector, tree_1.getTree, get_chart_theme_1.getChartThemeSelector], function (specs, parentDimensions, tree, _a) {
    var background = _a.background;
    var pieSpecs = utils_1.getSpecsFromStore(specs, __1.ChartTypes.Partition, constants_1.SpecTypes.Series);
    return pieSpecs.length === 1
        ? scenegraph_1.render(pieSpecs[0], parentDimensions, tree, background.color)
        : viewmodel_types_1.nullShapeViewModel();
})(function (state) { return state.chartId; });
//# sourceMappingURL=geometries.js.map