"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var redux_1 = require("redux");
var resize_observer_polyfill_1 = __importDefault(require("resize-observer-polyfill"));
var ts_debounce_1 = require("ts-debounce");
var chart_settings_1 = require("../state/actions/chart_settings");
var get_settings_specs_1 = require("../state/selectors/get_settings_specs");
var commons_1 = require("../utils/commons");
var DEFAULT_RESIZE_DEBOUNCE = 200;
var Resizer = (function (_super) {
    __extends(Resizer, _super);
    function Resizer(props) {
        var _this = _super.call(this, props) || this;
        _this.initialResizeComplete = false;
        _this.onResize = function (entries) {
            if (!Array.isArray(entries)) {
                return;
            }
            if (entries.length === 0 || !entries[0]) {
                return;
            }
            var _a = entries[0].contentRect, width = _a.width, height = _a.height;
            _this.animationFrameID = window.requestAnimationFrame(function () {
                _this.props.updateParentDimensions({ width: width, height: height, top: 0, left: 0 });
            });
        };
        _this.handleResize = function (entries) {
            if (_this.initialResizeComplete) {
                _this.onResizeDebounced(entries);
            }
            else {
                _this.initialResizeComplete = true;
                _this.onResize(entries);
            }
        };
        _this.containerRef = react_1.default.createRef();
        _this.ro = new resize_observer_polyfill_1.default(_this.handleResize);
        _this.animationFrameID = null;
        _this.onResizeDebounced = function () { };
        return _this;
    }
    Resizer.prototype.componentDidMount = function () {
        this.onResizeDebounced = ts_debounce_1.debounce(this.onResize, this.props.resizeDebounce);
        if (this.containerRef.current) {
            this.ro.observe(this.containerRef.current);
        }
    };
    Resizer.prototype.componentWillUnmount = function () {
        if (this.animationFrameID) {
            window.cancelAnimationFrame(this.animationFrameID);
        }
        this.ro.disconnect();
    };
    Resizer.prototype.render = function () {
        return react_1.default.createElement("div", { ref: this.containerRef, className: "echChartResizer" });
    };
    return Resizer;
}(react_1.default.Component));
var mapDispatchToProps = function (dispatch) {
    return redux_1.bindActionCreators({
        updateParentDimensions: chart_settings_1.updateParentDimensions,
    }, dispatch);
};
var mapStateToProps = function (state) {
    var settings = get_settings_specs_1.getSettingsSpecSelector(state);
    var resizeDebounce = settings.resizeDebounce === undefined || settings.resizeDebounce === null
        ? 200 : settings.resizeDebounce;
    return {
        resizeDebounce: !commons_1.isDefined(resizeDebounce) || Number.isNaN(resizeDebounce) ? DEFAULT_RESIZE_DEBOUNCE : resizeDebounce,
    };
};
exports.ChartResizer = react_redux_1.connect(mapStateToProps, mapDispatchToProps)(Resizer);
//# sourceMappingURL=chart_resizer.js.map