"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiExpression = exports.COLORS = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _icon = require("../icon");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var colorToClassNameMap = {
  subdued: 'euiExpression--subdued',
  primary: 'euiExpression--primary',
  secondary: 'euiExpression--secondary',
  accent: 'euiExpression--accent',
  warning: 'euiExpression--warning',
  danger: 'euiExpression--danger'
};
var textWrapToClassNameMap = {
  'break-word': null,
  truncate: 'euiExpression--truncate'
};
var COLORS = (0, _common.keysOf)(colorToClassNameMap);
exports.COLORS = COLORS;
var displayToClassNameMap = {
  inline: null,
  columns: 'euiExpression--columns'
};

var EuiExpression = function EuiExpression(_ref) {
  var className = _ref.className,
      description = _ref.description,
      descriptionProps = _ref.descriptionProps,
      value = _ref.value,
      valueProps = _ref.valueProps,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'secondary' : _ref$color,
      _ref$uppercase = _ref.uppercase,
      uppercase = _ref$uppercase === void 0 ? true : _ref$uppercase,
      _ref$isActive = _ref.isActive,
      isActive = _ref$isActive === void 0 ? false : _ref$isActive,
      _ref$display = _ref.display,
      display = _ref$display === void 0 ? 'inline' : _ref$display,
      _ref$descriptionWidth = _ref.descriptionWidth,
      descriptionWidth = _ref$descriptionWidth === void 0 ? '20%' : _ref$descriptionWidth,
      onClick = _ref.onClick,
      _ref$isInvalid = _ref.isInvalid,
      isInvalid = _ref$isInvalid === void 0 ? false : _ref$isInvalid,
      _ref$textWrap = _ref.textWrap,
      textWrap = _ref$textWrap === void 0 ? 'break-word' : _ref$textWrap,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "description", "descriptionProps", "value", "valueProps", "color", "uppercase", "isActive", "display", "descriptionWidth", "onClick", "isInvalid", "textWrap"]);
  var calculatedColor = isInvalid ? 'danger' : color;
  var classes = (0, _classnames.default)('euiExpression', className, {
    'euiExpression-isActive': isActive,
    'euiExpression-isClickable': onClick,
    'euiExpression-isUppercase': uppercase
  }, displayToClassNameMap[display], colorToClassNameMap[calculatedColor], textWrapToClassNameMap[textWrap]);
  var Component = onClick ? 'button' : 'span';
  var descriptionStyle = descriptionProps && descriptionProps.style;
  var customWidth = display === 'columns' && descriptionWidth ? _objectSpread({
    flexBasis: descriptionWidth
  }, descriptionStyle) : undefined;
  var invalidIcon = isInvalid ? _react.default.createElement(_icon.EuiIcon, {
    className: "euiExpression__icon",
    type: "alert",
    color: calculatedColor
  }) : undefined;
  return _react.default.createElement(Component, (0, _extends2.default)({
    className: classes,
    onClick: onClick
  }, rest), _react.default.createElement("span", (0, _extends2.default)({
    className: "euiExpression__description",
    style: customWidth
  }, descriptionProps), description), ' ', _react.default.createElement("span", (0, _extends2.default)({
    className: "euiExpression__value"
  }, valueProps), value), invalidIcon);
};

exports.EuiExpression = EuiExpression;
EuiExpression.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
     * First part of the expression
     */

  /**
     * First part of the expression
     */
  description: _propTypes.default.node.isRequired,
  descriptionProps: _propTypes.default.any,

  /**
     * Second part of the expression
     */

  /**
     * Second part of the expression
     */
  value: _propTypes.default.node.isRequired,
  valueProps: _propTypes.default.any,

  /**
     * Color of the `description`
     */

  /**
     * Color of the `description`
     */
  color: _propTypes.default.oneOf(["subdued", "primary", "secondary", "accent", "warning", "danger"]),

  /**
     * Should the `description` auto-uppercase?
     */

  /**
     * Should the `description` auto-uppercase?
     */
  uppercase: _propTypes.default.bool,

  /**
     * Adds an solid border at the bottom
     */

  /**
     * Adds an solid border at the bottom
     */
  isActive: _propTypes.default.bool,

  /**
     * Turns the component into a button and adds an editable style border at the bottom
     */

  /**
     * Turns the component into a button and adds an editable style border at the bottom
     */
  onClick: _propTypes.default.oneOfType([_propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.func.isRequired]), _propTypes.default.func]),

  /**
     * Sets the display style for the expression. Defaults to `inline`
     */

  /**
     * Sets the display style for the expression. Defaults to `inline`
     */
  display: _propTypes.default.oneOf(["inline", "columns"]),

  /**
     * Forces color to display as `danger` and shows an `alert` icon
     */

  /**
     * Forces color to display as `danger` and shows an `alert` icon
     */
  isInvalid: _propTypes.default.bool,

  /**
     * Sets a custom width for the description when using the columns layout.
     * Set to a number for a custom width in `px`.
     * Set to a string for a custom width in custom measurement.
     * Defaults to `20%`
     */

  /**
     * Sets a custom width for the description when using the columns layout.
     * Set to a number for a custom width in `px`.
     * Set to a string for a custom width in custom measurement.
     * Defaults to `20%`
     */
  descriptionWidth: _propTypes.default.oneOfType([_propTypes.default.number.isRequired, _propTypes.default.string.isRequired]),

  /**
     * Sets how to handle the wrapping of long text.
     */

  /**
     * Sets how to handle the wrapping of long text.
     */
  textWrap: _propTypes.default.oneOf(["break-word", "truncate"])
};
EuiExpression.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiExpression",
  "props": {
    "color": {
      "defaultValue": {
        "value": "'secondary'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"subdued\"",
          "computed": false
        }, {
          "value": "\"primary\"",
          "computed": false
        }, {
          "value": "\"secondary\"",
          "computed": false
        }, {
          "value": "\"accent\"",
          "computed": false
        }, {
          "value": "\"warning\"",
          "computed": false
        }, {
          "value": "\"danger\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Color of the `description`"
    },
    "uppercase": {
      "defaultValue": {
        "value": "true",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Should the `description` auto-uppercase?"
    },
    "isActive": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Adds an solid border at the bottom"
    },
    "display": {
      "defaultValue": {
        "value": "'inline'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"inline\"",
          "computed": false
        }, {
          "value": "\"columns\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Sets the display style for the expression. Defaults to `inline`"
    },
    "descriptionWidth": {
      "defaultValue": {
        "value": "'20%'",
        "computed": false
      },
      "type": {
        "name": "union",
        "value": [{
          "name": "number"
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": "Sets a custom width for the description when using the columns layout.\nSet to a number for a custom width in `px`.\nSet to a string for a custom width in custom measurement.\nDefaults to `20%`"
    },
    "isInvalid": {
      "defaultValue": {
        "value": "false",
        "computed": false
      },
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": "Forces color to display as `danger` and shows an `alert` icon"
    },
    "textWrap": {
      "defaultValue": {
        "value": "'break-word'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"break-word\"",
          "computed": false
        }, {
          "value": "\"truncate\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Sets how to handle the wrapping of long text."
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "description": {
      "type": {
        "name": "node"
      },
      "required": true,
      "description": "First part of the expression"
    },
    "descriptionProps": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "value": {
      "type": {
        "name": "node"
      },
      "required": true,
      "description": "Second part of the expression"
    },
    "valueProps": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    },
    "onClick": {
      "type": {
        "name": "union",
        "value": [{
          "name": "union",
          "value": [{
            "name": "func"
          }, {
            "name": "func"
          }]
        }, {
          "name": "func"
        }]
      },
      "required": false,
      "description": "Turns the component into a button and adds an editable style border at the bottom"
    }
  }
};