function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { isNumber, keys, values, find, each, cloneDeep, flatten } from 'lodash';
import { buildExistsFilter, buildPhrasesFilter, buildQueryFromFilters } from '../../../../common';
import { AggGroupNames } from '../agg_groups';

/**
 * walks the aggregation DSL and returns DSL starting at aggregation with id of startFromAggId
 * @param aggNestedDsl: aggregation config DSL (top level)
 * @param startFromId: id of an aggregation from where we want to get the nested DSL
 */
var getNestedAggDSL = function getNestedAggDSL(aggNestedDsl, startFromAggId) {
  if (aggNestedDsl[startFromAggId]) {
    return aggNestedDsl[startFromAggId];
  }

  var nestedAggs = values(aggNestedDsl);
  var aggs;

  for (var i = 0; i < nestedAggs.length; i++) {
    if (nestedAggs[i].aggs && (aggs = getNestedAggDSL(nestedAggs[i].aggs, startFromAggId))) {
      return aggs;
    }
  }
};
/**
 * returns buckets from response for a specific other bucket
 * @param aggConfigs: configuration for the aggregations
 * @param response: response from elasticsearch
 * @param aggWithOtherBucket: AggConfig of the aggregation with other bucket enabled
 * @param key: key from the other bucket request for a specific other bucket
 */


var getAggResultBuckets = function getAggResultBuckets(aggConfigs, response, aggWithOtherBucket, key) {
  var keyParts = key.split('-');
  var responseAgg = response;

  var _loop = function _loop(i) {
    if (keyParts[i]) {
      var responseAggs = values(responseAgg); // If you have multi aggs, we cannot just assume the first one is the `other` bucket,
      // so we need to loop over each agg until we find it.

      var _loop2 = function _loop2(aggId) {
        var aggById = responseAggs[aggId];
        var aggKey = keys(responseAgg)[aggId];
        var aggConfig = find(aggConfigs.aggs, function (agg) {
          return agg.id === aggKey;
        });

        if (aggConfig) {
          var aggResultBucket = find(aggById.buckets, function (bucket, bucketObjKey) {
            var bucketKey = aggConfig.getKey(bucket, isNumber(bucketObjKey) ? undefined : bucketObjKey).toString();
            return bucketKey === keyParts[i];
          });

          if (aggResultBucket) {
            responseAgg = aggResultBucket;
            return "break";
          }
        }
      };

      for (var aggId = 0; aggId < responseAggs.length; aggId++) {
        var _ret = _loop2(aggId);

        if (_ret === "break") break;
      }
    }
  };

  for (var i in keyParts) {
    _loop(i);
  }

  if (responseAgg[aggWithOtherBucket.id]) {
    return responseAgg[aggWithOtherBucket.id].buckets;
  }

  return [];
};
/**
 * gets all the missing buckets in our response for a specific aggregation id
 * @param responseAggs: array of aggregations from response
 * @param aggId: id of the aggregation with missing bucket
 */


var getAggConfigResultMissingBuckets = function getAggConfigResultMissingBuckets(responseAggs, aggId) {
  var missingKey = '__missing__';
  var resultBuckets = [];

  if (responseAggs[aggId]) {
    var matchingBucket = responseAggs[aggId].buckets.find(function (bucket) {
      return bucket.key === missingKey;
    });
    if (matchingBucket) resultBuckets.push(matchingBucket);
    return resultBuckets;
  }

  each(responseAggs, function (agg) {
    if (agg.buckets) {
      each(agg.buckets, function (bucket) {
        resultBuckets = [].concat(_toConsumableArray(resultBuckets), _toConsumableArray(getAggConfigResultMissingBuckets(bucket, aggId)));
      });
    }
  });
  return resultBuckets;
};
/**
 * gets all the terms that are NOT in the other bucket
 * @param requestAgg: an aggregation we are looking at
 * @param key: the key for this specific other bucket
 * @param otherAgg: AggConfig of the aggregation with other bucket
 */


var getOtherAggTerms = function getOtherAggTerms(requestAgg, key, otherAgg) {
  return requestAgg['other-filter'].filters.filters[key].bool.must_not.filter(function (filter) {
    return filter.match_phrase && filter.match_phrase[otherAgg.params.field.name];
  }).map(function (filter) {
    return filter.match_phrase[otherAgg.params.field.name];
  });
};

export var buildOtherBucketAgg = function buildOtherBucketAgg(aggConfigs, aggWithOtherBucket, response) {
  var bucketAggs = aggConfigs.aggs.filter(function (agg) {
    return agg.type.type === AggGroupNames.Buckets;
  });
  var index = bucketAggs.findIndex(function (agg) {
    return agg.id === aggWithOtherBucket.id;
  });
  var aggs = aggConfigs.toDsl();
  var indexPattern = aggWithOtherBucket.params.field.indexPattern; // create filters aggregation

  var filterAgg = aggConfigs.createAggConfig({
    type: 'filters',
    id: 'other',
    params: {
      filters: []
    },
    enabled: false
  }, {
    addToAggConfigs: false
  }); // nest all the child aggregations of aggWithOtherBucket

  var resultAgg = {
    aggs: getNestedAggDSL(aggs, aggWithOtherBucket.id).aggs,
    filters: filterAgg.toDsl()
  };
  var noAggBucketResults = false; // recursively create filters for all parent aggregation buckets

  var walkBucketTree = function walkBucketTree(aggIndex, aggregations, aggId, filters, key) {
    // make sure there are actually results for the buckets
    if (aggregations[aggId].buckets.length < 1) {
      noAggBucketResults = true;
      return;
    }

    var agg = aggregations[aggId];
    var newAggIndex = aggIndex + 1;
    var newAgg = bucketAggs[newAggIndex];
    var currentAgg = bucketAggs[aggIndex];

    if (aggIndex < index) {
      each(agg.buckets, function (bucket, bucketObjKey) {
        var bucketKey = currentAgg.getKey(bucket, isNumber(bucketObjKey) ? undefined : bucketObjKey);
        var filter = cloneDeep(bucket.filters) || currentAgg.createFilter(bucketKey);
        var newFilters = flatten([].concat(_toConsumableArray(filters), [filter]));
        walkBucketTree(newAggIndex, bucket, newAgg.id, newFilters, "".concat(key, "-").concat(bucketKey.toString()));
      });
      return;
    }

    var hasScriptedField = !!aggWithOtherBucket.params.field.scripted;
    var hasMissingBucket = !!aggWithOtherBucket.params.missingBucket;
    var hasMissingBucketKey = agg.buckets.some(function (bucket) {
      return bucket.key === '__missing__';
    });

    if (!hasScriptedField && (!hasMissingBucket || hasMissingBucketKey)) {
      filters.push(buildExistsFilter(aggWithOtherBucket.params.field, aggWithOtherBucket.params.field.indexPattern));
    } // create not filters for all the buckets


    each(agg.buckets, function (bucket) {
      if (bucket.key === '__missing__') return;
      var filter = currentAgg.createFilter(bucket.key);
      filter.meta.negate = true;
      filters.push(filter);
    });
    resultAgg.filters.filters[key] = {
      bool: buildQueryFromFilters(filters, indexPattern)
    };
  };

  walkBucketTree(0, response.aggregations, bucketAggs[0].id, [], ''); // bail if there were no bucket results

  if (noAggBucketResults) {
    return false;
  }

  return function () {
    return {
      'other-filter': resultAgg
    };
  };
};
export var mergeOtherBucketAggResponse = function mergeOtherBucketAggResponse(aggsConfig, response, otherResponse, otherAgg, requestAgg) {
  var updatedResponse = cloneDeep(response);
  each(otherResponse.aggregations['other-filter'].buckets, function (bucket, key) {
    if (!bucket.doc_count || key === undefined) return;
    var bucketKey = key.replace(/^-/, '');
    var aggResultBuckets = getAggResultBuckets(aggsConfig, updatedResponse.aggregations, otherAgg, bucketKey);
    var requestFilterTerms = getOtherAggTerms(requestAgg, key, otherAgg);
    var phraseFilter = buildPhrasesFilter(otherAgg.params.field, requestFilterTerms, otherAgg.params.field.indexPattern);
    phraseFilter.meta.negate = true;
    bucket.filters = [phraseFilter];
    bucket.key = '__other__';

    if (aggResultBuckets.some(function (aggResultBucket) {
      return aggResultBucket.key === '__missing__';
    })) {
      bucket.filters.push(buildExistsFilter(otherAgg.params.field, otherAgg.params.field.indexPattern));
    }

    aggResultBuckets.push(bucket);
  });
  return updatedResponse;
};
export var updateMissingBucket = function updateMissingBucket(response, aggConfigs, agg) {
  var updatedResponse = cloneDeep(response);
  var aggResultBuckets = getAggConfigResultMissingBuckets(updatedResponse.aggregations, agg.id);
  aggResultBuckets.forEach(function (bucket) {
    bucket.key = '__missing__';
  });
  return updatedResponse;
};