/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './fetch_error.scss';
import React, { Fragment } from 'react';
import { FormattedMessage, I18nProvider } from '@kbn/i18n/react';
import { EuiFlexGroup, EuiFlexItem, EuiCallOut, EuiCodeBlock, EuiSpacer } from '@elastic/eui';
import { getAngularModule, getServices } from '../../../kibana_services';

var DiscoverFetchError = function DiscoverFetchError(_ref) {
  var fetchError = _ref.fetchError;

  if (!fetchError) {
    return null;
  }

  var body;

  if (fetchError.lang === 'painless') {
    var _getServices = getServices(),
        chrome = _getServices.chrome;

    var mangagementUrlObj = chrome.navLinks.get('kibana:stack_management');
    var managementUrl = mangagementUrlObj ? mangagementUrlObj.url : '';
    var url = "".concat(managementUrl, "/kibana/indexPatterns");
    body = /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "discover.fetchError.howToAddressErrorDescription",
      defaultMessage: "You can address this error by editing the {fetchErrorScript} field in {managementLink}, under the {scriptedFields} tab.",
      values: {
        fetchErrorScript: "'".concat(fetchError.script, "'"),
        scriptedFields: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "discover.fetchError.scriptedFieldsText",
          defaultMessage: "\u201CScripted fields\u201D"
        }),
        managementLink: /*#__PURE__*/React.createElement("a", {
          href: url
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "discover.fetchError.managmentLinkText",
          defaultMessage: "Management > Index Patterns"
        }))
      }
    }));
  }

  return /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "center",
    "data-test-subj": "discoverFetchError"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false,
    className: "discoverFetchError"
  }, /*#__PURE__*/React.createElement(EuiCallOut, {
    title: fetchError.message,
    color: "danger",
    iconType: "cross"
  }, body, /*#__PURE__*/React.createElement(EuiCodeBlock, null, fetchError.error)))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "xl"
  })));
};

export function createFetchErrorDirective(reactDirective) {
  return reactDirective(DiscoverFetchError);
}
getAngularModule().directive('discoverFetchError', createFetchErrorDirective);