function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useState } from 'react';
import { EmbeddableRoot } from './embeddable_root';
import { isErrorEmbeddable } from './error_embeddable';
/**
 * This type is a publicly exposed props of {@link EmbeddableRenderer}
 * Union is used to validate that or factory or embeddable is passed in, but it can't be both simultaneously
 * In case when embeddable is passed in, input is optional, because there is already an input inside of embeddable object
 * In case when factory is used, then input is required, because it will be used as initial input to create an embeddable object
 */

function isWithEmbeddable(props) {
  return 'embeddable' in props;
}

function isWithFactory(props) {
  return 'factory' in props;
}
/**
 * Helper react component to render an embeddable
 * Can be used if you have an embeddable object or an embeddable factory
 * Supports updating input by passing `input` prop
 *
 * @remarks
 * This component shouldn't be used inside an embeddable container to render embeddable children
 * because children may lose inherited input, here is why:
 *
 * When passing `input` inside a prop, internally there is a call:
 *
 * ```ts
 * embeddable.updateInput(input);
 * ```
 * If you are simply rendering an embeddable, it's no problem.
 *
 * However when you are dealing with containers,
 * you want to be sure to only pass into updateInput the actual state that changed.
 * This is because calling child.updateInput({ foo }) will make foo explicit state.
 * It cannot be inherited from it's parent.
 *
 * For example, on a dashboard, the time range is inherited by all children,
 * unless they had their time range set explicitly.
 * This is how "per panel time range" works.
 * That action calls embeddable.updateInput({ timeRange }),
 * and the time range will no longer be inherited from the container.
 *
 * see: https://github.com/elastic/kibana/pull/67783#discussion_r435447657 for more details.
 * refer to: examples/embeddable_explorer for examples with correct usage of this component.
 *
 * @public
 * @param props - {@link EmbeddableRendererProps}
 */


export var EmbeddableRenderer = function EmbeddableRenderer(props) {
  var input = props.input,
      onInputUpdated = props.onInputUpdated;

  var _useState = useState(isWithEmbeddable(props) ? props.embeddable : undefined),
      _useState2 = _slicedToArray(_useState, 2),
      embeddable = _useState2[0],
      setEmbeddable = _useState2[1];

  var _useState3 = useState(!isWithEmbeddable(props)),
      _useState4 = _slicedToArray(_useState3, 2),
      loading = _useState4[0],
      setLoading = _useState4[1];

  var _useState5 = useState(),
      _useState6 = _slicedToArray(_useState5, 2),
      error = _useState6[0],
      setError = _useState6[1];

  var latestInput = React.useRef(props.input);
  useEffect(function () {
    latestInput.current = input;
  }, [input]);
  var factoryFromProps = isWithFactory(props) ? props.factory : undefined;
  var embeddableFromProps = isWithEmbeddable(props) ? props.embeddable : undefined;
  useEffect(function () {
    var canceled = false;

    if (embeddableFromProps) {
      setEmbeddable(embeddableFromProps);
      return;
    } // keeping track of embeddables created by this component to be able to destroy them


    var createdEmbeddableRef;

    if (factoryFromProps) {
      setEmbeddable(undefined);
      setLoading(true);
      factoryFromProps.create(latestInput.current).then(function (createdEmbeddable) {
        if (canceled) {
          if (createdEmbeddable) {
            createdEmbeddable.destroy();
          }
        } else {
          createdEmbeddableRef = createdEmbeddable;
          setEmbeddable(createdEmbeddable);
        }
      }).catch(function (err) {
        if (canceled) return;
        setError(err === null || err === void 0 ? void 0 : err.message);
      }).finally(function () {
        if (canceled) return;
        setLoading(false);
      });
    }

    return function () {
      canceled = true;

      if (createdEmbeddableRef) {
        createdEmbeddableRef.destroy();
      }
    };
  }, [factoryFromProps, embeddableFromProps]);
  useEffect(function () {
    if (!embeddable) return;
    if (isErrorEmbeddable(embeddable)) return;
    if (!onInputUpdated) return;
    var sub = embeddable.getInput$().subscribe(function (newInput) {
      onInputUpdated(newInput);
    });
    return function () {
      sub.unsubscribe();
    };
  }, [embeddable, onInputUpdated]);
  return /*#__PURE__*/React.createElement(EmbeddableRoot, {
    embeddable: embeddable,
    loading: loading,
    error: error,
    input: input
  });
};