function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useRef, useEffect, useState, useLayoutEffect } from 'react';
import classNames from 'classnames';
import { filter } from 'rxjs/operators';
import useShallowCompareEffect from 'react-use/lib/useShallowCompareEffect';
import { EuiLoadingChart, EuiProgress } from '@elastic/eui';
import theme from '@elastic/eui/dist/eui_theme_light.json';
import { ExpressionLoader } from './loader';
var defaultState = {
  isEmpty: true,
  isLoading: false,
  error: null
};
export var ReactExpressionRenderer = function ReactExpressionRenderer(_ref) {
  var className = _ref.className,
      dataAttrs = _ref.dataAttrs,
      padding = _ref.padding,
      renderError = _ref.renderError,
      expression = _ref.expression,
      onEvent = _ref.onEvent,
      reload$ = _ref.reload$,
      expressionLoaderOptions = _objectWithoutProperties(_ref, ["className", "dataAttrs", "padding", "renderError", "expression", "onEvent", "reload$"]);

  var mountpoint = useRef(null);

  var _useState = useState(_objectSpread({}, defaultState)),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  var hasCustomRenderErrorHandler = !!renderError;
  var expressionLoaderRef = useRef(null); // flag to skip next render$ notification,
  // because of just handled error

  var hasHandledErrorRef = useRef(false); // will call done() in LayoutEffect when done with rendering custom error state

  var errorRenderHandlerRef = useRef(null);
  /* eslint-disable react-hooks/exhaustive-deps */
  // OK to ignore react-hooks/exhaustive-deps because options update is handled by calling .update()

  useEffect(function () {
    var subs = [];
    expressionLoaderRef.current = new ExpressionLoader(mountpoint.current, expression, _objectSpread(_objectSpread({}, expressionLoaderOptions), {}, {
      // react component wrapper provides different
      // error handling api which is easier to work with from react
      // if custom renderError is not provided then we fallback to default error handling from ExpressionLoader
      onRenderError: hasCustomRenderErrorHandler ? function (domNode, error, handlers) {
        errorRenderHandlerRef.current = handlers;
        setState(function () {
          return _objectSpread(_objectSpread({}, defaultState), {}, {
            isEmpty: false,
            error: error
          });
        });

        if (expressionLoaderOptions.onRenderError) {
          expressionLoaderOptions.onRenderError(domNode, error, handlers);
        }
      } : expressionLoaderOptions.onRenderError
    }));

    if (onEvent) {
      subs.push(expressionLoaderRef.current.events$.subscribe(function (event) {
        onEvent(event);
      }));
    }

    subs.push(expressionLoaderRef.current.loading$.subscribe(function () {
      hasHandledErrorRef.current = false;
      setState(function (prevState) {
        return _objectSpread(_objectSpread({}, prevState), {}, {
          isLoading: true
        });
      });
    }), expressionLoaderRef.current.render$.pipe(filter(function () {
      return !hasHandledErrorRef.current;
    })).subscribe(function (item) {
      setState(function () {
        return _objectSpread(_objectSpread({}, defaultState), {}, {
          isEmpty: false
        });
      });
    }));
    return function () {
      subs.forEach(function (s) {
        return s.unsubscribe();
      });

      if (expressionLoaderRef.current) {
        expressionLoaderRef.current.destroy();
        expressionLoaderRef.current = null;
      }

      errorRenderHandlerRef.current = null;
    };
  }, [hasCustomRenderErrorHandler, onEvent]);
  useEffect(function () {
    var subscription = reload$ === null || reload$ === void 0 ? void 0 : reload$.subscribe(function () {
      if (expressionLoaderRef.current) {
        expressionLoaderRef.current.update(expression, expressionLoaderOptions);
      }
    });
    return function () {
      return subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
    };
  }, [reload$, expression].concat(_toConsumableArray(Object.values(expressionLoaderOptions)))); // Re-fetch data automatically when the inputs change

  useShallowCompareEffect(function () {
    if (expressionLoaderRef.current) {
      expressionLoaderRef.current.update(expression, expressionLoaderOptions);
    }
  }, // when expression is changed by reference and when any other loaderOption is changed by reference
  [_objectSpread({
    expression: expression
  }, expressionLoaderOptions)]);
  /* eslint-enable react-hooks/exhaustive-deps */
  // call expression loader's done() handler when finished rendering custom error state

  useLayoutEffect(function () {
    if (state.error && errorRenderHandlerRef.current) {
      hasHandledErrorRef.current = true;
      errorRenderHandlerRef.current.done();
      errorRenderHandlerRef.current = null;
    }
  }, [state.error]);
  var classes = classNames('expExpressionRenderer', {
    'expExpressionRenderer-isEmpty': state.isEmpty,
    'expExpressionRenderer-hasError': !!state.error,
    className: className
  });
  var expressionStyles = {};

  if (padding) {
    expressionStyles.padding = theme.paddingSizes[padding];
  }

  return /*#__PURE__*/React.createElement("div", _extends({}, dataAttrs, {
    className: classes
  }), state.isEmpty && /*#__PURE__*/React.createElement(EuiLoadingChart, {
    mono: true,
    size: "l"
  }), state.isLoading && /*#__PURE__*/React.createElement(EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }), !state.isLoading && state.error && renderError && renderError(state.error.message), /*#__PURE__*/React.createElement("div", {
    className: "expExpressionRenderer__expression",
    style: expressionStyles,
    ref: mountpoint
  }));
};