function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiBadge, EuiFlexGroup, EuiFlexItem, EuiSpacer, EuiTable, EuiTableBody, EuiTableRow, EuiTableRowCell, EuiButtonEmpty, EuiContextMenuItem, EuiContextMenuPanel, EuiPagination, EuiPopover } from '@elastic/eui';
import { Pager } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { PER_PAGE_INCREMENTS } from '../../../../constants';
export var IndicesList = /*#__PURE__*/function (_React$Component) {
  _inherits(IndicesList, _React$Component);

  var _super = _createSuper(IndicesList);

  function IndicesList(props) {
    var _this;

    _classCallCheck(this, IndicesList);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "pager", void 0);

    _defineProperty(_assertThisInitialized(_this), "resetPageTo0", function () {
      return _this.onChangePage(0);
    });

    _defineProperty(_assertThisInitialized(_this), "onChangePage", function (page) {
      _this.pager.goToPageIndex(page);

      _this.setState({
        page: page
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onChangePerPage", function (perPage) {
      _this.pager.setItemsPerPage(perPage);

      _this.setState({
        perPage: perPage
      });

      _this.resetPageTo0();

      _this.closePerPageControl();
    });

    _defineProperty(_assertThisInitialized(_this), "openPerPageControl", function () {
      _this.setState({
        isPerPageControlOpen: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closePerPageControl", function () {
      _this.setState({
        isPerPageControlOpen: false
      });
    });

    _this.state = {
      page: 0,
      perPage: PER_PAGE_INCREMENTS[1],
      isPerPageControlOpen: false
    };
    _this.pager = new Pager(props.indices.length, _this.state.perPage, _this.state.page);
    return _this;
  }

  _createClass(IndicesList, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      if (nextProps.indices.length !== this.props.indices.length) {
        this.pager.setTotalItems(nextProps.indices.length);
        this.resetPageTo0();
      }
    }
  }, {
    key: "renderPagination",
    value: function renderPagination() {
      var _this2 = this;

      var _this$state = this.state,
          perPage = _this$state.perPage,
          page = _this$state.page,
          isPerPageControlOpen = _this$state.isPerPageControlOpen;
      var button = /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        size: "s",
        color: "text",
        iconType: "arrowDown",
        iconSide: "right",
        onClick: this.openPerPageControl
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.createIndexPattern.step.pagingLabel",
        defaultMessage: "Rows per page: {perPage}",
        values: {
          perPage: perPage
        }
      }));
      var items = PER_PAGE_INCREMENTS.map(function (increment) {
        return /*#__PURE__*/React.createElement(EuiContextMenuItem, {
          key: increment,
          icon: "empty",
          onClick: function onClick() {
            return _this2.onChangePerPage(increment);
          }
        }, increment);
      });
      var pageCount = this.pager.getTotalPages();
      var paginationControls = pageCount > 1 ? /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiPagination, {
        pageCount: pageCount,
        activePage: page,
        onPageClick: this.onChangePage
      })) : null;
      return /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "spaceBetween",
        alignItems: "center"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiPopover, {
        id: "customizablePagination",
        button: button,
        isOpen: isPerPageControlOpen,
        closePopover: this.closePerPageControl,
        panelPaddingSize: "none",
        withTitle: true
      }, /*#__PURE__*/React.createElement(EuiContextMenuPanel, {
        items: items
      }))), paginationControls);
    }
  }, {
    key: "highlightIndexName",
    value: function highlightIndexName(indexName, query) {
      var queryIdx = indexName.indexOf(query);

      if (!query || queryIdx === -1) {
        return indexName;
      }

      var preStr = indexName.substr(0, queryIdx);
      var postStr = indexName.substr(queryIdx + query.length);
      return /*#__PURE__*/React.createElement("span", null, preStr, /*#__PURE__*/React.createElement("strong", null, query), postStr);
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var _this$props = this.props,
          indices = _this$props.indices,
          query = _this$props.query,
          rest = _objectWithoutProperties(_this$props, ["indices", "query"]);

      var queryWithoutWildcard = query.endsWith('*') ? query.substr(0, query.length - 1) : query;
      var paginatedIndices = indices.slice(this.pager.firstItemIndex, this.pager.lastItemIndex + 1);
      var rows = paginatedIndices.map(function (index, key) {
        return /*#__PURE__*/React.createElement(EuiTableRow, {
          key: key
        }, /*#__PURE__*/React.createElement(EuiTableRowCell, null, _this3.highlightIndexName(index.name, queryWithoutWildcard)), /*#__PURE__*/React.createElement(EuiTableRowCell, null, index.tags.map(function (tag) {
          return /*#__PURE__*/React.createElement(EuiBadge, {
            key: "index_".concat(key, "_tag_").concat(tag.key),
            color: tag.color
          }, tag.name);
        })));
      });
      return /*#__PURE__*/React.createElement("div", rest, /*#__PURE__*/React.createElement(EuiTable, null, /*#__PURE__*/React.createElement(EuiTableBody, null, rows)), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), this.renderPagination());
    }
  }]);

  return IndicesList;
}(React.Component);