function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiFlyout, EuiFlyoutBody, EuiTabbedContent } from '@elastic/eui';
import { ScriptingSyntax } from './scripting_syntax';
import { TestScript } from './test_script';
export var ScriptingHelpFlyout = function ScriptingHelpFlyout(_ref) {
  var _ref2, _ref3;

  var _ref$isVisible = _ref.isVisible,
      isVisible = _ref$isVisible === void 0 ? false : _ref$isVisible,
      _ref$onClose = _ref.onClose,
      onClose = _ref$onClose === void 0 ? function () {} : _ref$onClose,
      indexPattern = _ref.indexPattern,
      lang = _ref.lang,
      name = _ref.name,
      script = _ref.script,
      executeScript = _ref.executeScript;
  var tabs = [(_ref2 = {
    id: 'syntax',
    name: 'Syntax'
  }, _defineProperty(_ref2, 'data-test-subj', 'syntaxTab'), _defineProperty(_ref2, "content", /*#__PURE__*/React.createElement(ScriptingSyntax, null)), _ref2), (_ref3 = {
    id: 'test',
    name: 'Preview results'
  }, _defineProperty(_ref3, 'data-test-subj', 'testTab'), _defineProperty(_ref3, "content", /*#__PURE__*/React.createElement(TestScript, {
    indexPattern: indexPattern,
    lang: lang,
    name: name,
    script: script,
    executeScript: executeScript
  })), _ref3)];
  return isVisible ? /*#__PURE__*/React.createElement(EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "scriptedFieldsHelpFlyout"
  }, /*#__PURE__*/React.createElement(EuiFlyoutBody, null, /*#__PURE__*/React.createElement(EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0]
  }))) : null;
};
ScriptingHelpFlyout.displayName = 'ScriptingHelpFlyout';