function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { debounce, keyBy, sortBy, uniq } from 'lodash';
import { EuiTitle, EuiInMemoryTable, EuiPage, EuiPageBody, EuiPageContent, EuiLink, EuiFlexGroup, EuiFlexItem, EuiButton, EuiSpacer, EuiOverlayMask, EuiConfirmModal, EuiCallOut } from '@elastic/eui';
import { toMountPoint } from '../util';

// saved object client does not support sorting by title because title is only mapped as analyzed
// the legacy implementation got around this by pulling `listingLimit` items and doing client side sorting
// and not supporting server-side paging.
// This component does not try to tackle these problems (yet) and is just feature matching the legacy component
// TODO support server side sorting/paging once title and description are sortable on the server.
var TableListView = /*#__PURE__*/function (_React$Component) {
  _inherits(TableListView, _React$Component);

  var _super = _createSuper(TableListView);

  function TableListView(props) {
    var _this;

    _classCallCheck(this, TableListView);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "pagination", {});

    _defineProperty(_assertThisInitialized(_this), "_isMounted", false);

    _defineProperty(_assertThisInitialized(_this), "debouncedFetch", debounce( /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(filter) {
        var response;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return _this.props.findItems(filter);

              case 3:
                response = _context.sent;

                if (_this._isMounted) {
                  _context.next = 6;
                  break;
                }

                return _context.abrupt("return");

              case 6:
                // We need this check to handle the case where search results come back in a different
                // order than they were sent out. Only load results for the most recent search.
                // Also, in case filter is empty, items are being pre-sorted alphabetically.
                if (filter === _this.state.filter) {
                  _this.setState({
                    hasInitialFetchReturned: true,
                    isFetchingItems: false,
                    items: !filter ? sortBy(response.hits, 'title') : response.hits,
                    totalItems: response.total,
                    showLimitError: response.total > _this.props.listingLimit
                  });
                }

                _context.next = 12;
                break;

              case 9:
                _context.prev = 9;
                _context.t0 = _context["catch"](0);

                _this.setState({
                  hasInitialFetchReturned: true,
                  isFetchingItems: false,
                  items: [],
                  totalItems: 0,
                  showLimitError: false,
                  fetchError: _context.t0
                });

              case 12:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 9]]);
      }));

      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }(), 300));

    _defineProperty(_assertThisInitialized(_this), "fetchItems", function () {
      _this.setState({
        isFetchingItems: true,
        fetchError: undefined
      }, _this.debouncedFetch.bind(null, _this.state.filter));
    });

    _defineProperty(_assertThisInitialized(_this), "deleteSelectedItems", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var itemsById;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              if (!(_this.state.isDeletingItems || !_this.props.deleteItems)) {
                _context2.next = 2;
                break;
              }

              return _context2.abrupt("return");

            case 2:
              _this.setState({
                isDeletingItems: true
              });

              _context2.prev = 3;
              itemsById = keyBy(_this.state.items, 'id');
              _context2.next = 7;
              return _this.props.deleteItems(_this.state.selectedIds.map(function (id) {
                return itemsById[id];
              }));

            case 7:
              _context2.next = 12;
              break;

            case 9:
              _context2.prev = 9;
              _context2.t0 = _context2["catch"](3);

              _this.props.toastNotifications.addDanger({
                title: toMountPoint( /*#__PURE__*/React.createElement(FormattedMessage, {
                  id: "kibana-react.tableListView.listing.unableToDeleteDangerMessage",
                  defaultMessage: "Unable to delete {entityName}(s)",
                  values: {
                    entityName: _this.props.entityName
                  }
                })),
                text: "".concat(_context2.t0)
              });

            case 12:
              _this.fetchItems();

              _this.setState({
                isDeletingItems: false,
                selectedIds: []
              });

              _this.closeDeleteModal();

            case 15:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, null, [[3, 9]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "closeDeleteModal", function () {
      _this.setState({
        showDeleteModal: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "openDeleteModal", function () {
      _this.setState({
        showDeleteModal: true
      });
    });

    _this.pagination = {
      initialPageIndex: 0,
      initialPageSize: props.initialPageSize,
      pageSizeOptions: uniq([10, 20, 50, props.initialPageSize]).sort()
    };
    _this.state = {
      items: [],
      totalItems: 0,
      hasInitialFetchReturned: false,
      isFetchingItems: false,
      isDeletingItems: false,
      showDeleteModal: false,
      showLimitError: false,
      filter: props.initialFilter,
      selectedIds: []
    };
    return _this;
  }

  _createClass(TableListView, [{
    key: "UNSAFE_componentWillMount",
    value: function UNSAFE_componentWillMount() {
      this._isMounted = true;
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
      this.debouncedFetch.cancel();
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.fetchItems();
    }
  }, {
    key: "setFilter",
    value: function setFilter(_ref3) {
      var queryText = _ref3.queryText;
      // If the user is searching, we want to clear the sort order so that
      // results are ordered by Elasticsearch's relevance.
      this.setState({
        filter: queryText
      }, this.fetchItems);
    }
  }, {
    key: "hasNoItems",
    value: function hasNoItems() {
      if (!this.state.isFetchingItems && this.state.items.length === 0 && !this.state.filter) {
        return true;
      }

      return false;
    }
  }, {
    key: "renderConfirmDeleteModal",
    value: function renderConfirmDeleteModal() {
      var deleteButton = /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "kibana-react.tableListView.listing.deleteSelectedItemsConfirmModal.confirmButtonLabel",
        defaultMessage: "Delete"
      });

      if (this.state.isDeletingItems) {
        deleteButton = /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "kibana-react.tableListView.listing.deleteSelectedItemsConfirmModal.confirmButtonLabelDeleting",
          defaultMessage: "Deleting"
        });
      }

      return /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(EuiConfirmModal, {
        title: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "kibana-react.tableListView.listing.deleteSelectedConfirmModal.title",
          defaultMessage: "Delete {itemCount} {entityName}?",
          values: {
            itemCount: this.state.selectedIds.length,
            entityName: this.state.selectedIds.length === 1 ? this.props.entityName : this.props.entityNamePlural
          }
        }),
        buttonColor: "danger",
        onCancel: this.closeDeleteModal,
        onConfirm: this.deleteSelectedItems,
        cancelButtonText: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "kibana-react.tableListView.listing.deleteSelectedItemsConfirmModal.cancelButtonLabel",
          defaultMessage: "Cancel"
        }),
        confirmButtonText: deleteButton,
        defaultFocusedButton: "cancel"
      }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "kibana-react.tableListView.listing.deleteConfirmModalDescription",
        defaultMessage: "You can't recover deleted {entityNamePlural}.",
        values: {
          entityNamePlural: this.props.entityNamePlural
        }
      }))));
    }
  }, {
    key: "renderListingLimitWarning",
    value: function renderListingLimitWarning() {
      if (this.state.showLimitError) {
        return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiCallOut, {
          title: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "kibana-react.tableListView.listing.listingLimitExceededTitle",
            defaultMessage: "Listing limit exceeded"
          }),
          color: "warning",
          iconType: "help"
        }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "kibana-react.tableListView.listing.listingLimitExceededDescription",
          defaultMessage: "You have {totalItems} {entityNamePlural}, but your {listingLimitText} setting prevents the table below from displaying more than {listingLimitValue}. You can change this setting under {advancedSettingsLink}.",
          values: {
            entityNamePlural: this.props.entityNamePlural,
            totalItems: this.state.totalItems,
            listingLimitValue: this.props.listingLimit,
            listingLimitText: /*#__PURE__*/React.createElement("strong", null, "listingLimit"),
            advancedSettingsLink: /*#__PURE__*/React.createElement(EuiLink, {
              href: "#/management/kibana/settings"
            }, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "kibana-react.tableListView.listing.listingLimitExceeded.advancedSettingsLinkText",
              defaultMessage: "Advanced Settings"
            }))
          }
        }))), /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "m"
        }));
      }
    }
  }, {
    key: "renderFetchError",
    value: function renderFetchError() {
      if (this.state.fetchError) {
        var _this$state$fetchErro;

        return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiCallOut, {
          title: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "kibana-react.tableListView.listing.fetchErrorTitle",
            defaultMessage: "Fetching listing failed"
          }),
          color: "danger",
          iconType: "alert"
        }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "kibana-react.tableListView.listing.fetchErrorDescription",
          defaultMessage: "The {entityName} listing could not be fetched: {message}.",
          values: {
            entityName: this.props.entityName,
            message: ((_this$state$fetchErro = this.state.fetchError.body) === null || _this$state$fetchErro === void 0 ? void 0 : _this$state$fetchErro.message) || this.state.fetchError.message
          }
        }))), /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "m"
        }));
      }
    }
  }, {
    key: "renderNoItemsMessage",
    value: function renderNoItemsMessage() {
      if (this.props.noItemsFragment) {
        return this.props.noItemsFragment;
      } else {
        return /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "kibana-react.tableListView.listing.noAvailableItemsMessage",
          defaultMessage: "No {entityNamePlural} available.",
          values: {
            entityNamePlural: this.props.entityNamePlural
          }
        });
      }
    }
  }, {
    key: "renderToolsLeft",
    value: function renderToolsLeft() {
      var _this2 = this;

      var selection = this.state.selectedIds;

      if (selection.length === 0) {
        return;
      }

      var onClick = function onClick() {
        _this2.openDeleteModal();
      };

      return /*#__PURE__*/React.createElement(EuiButton, {
        color: "danger",
        iconType: "trash",
        onClick: onClick,
        "data-test-subj": "deleteSelectedItems"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "kibana-react.tableListView.listing.deleteButtonMessage",
        defaultMessage: "Delete {itemCount} {entityName}",
        values: {
          itemCount: selection.length,
          entityName: selection.length === 1 ? this.props.entityName : this.props.entityNamePlural
        }
      }));
    }
  }, {
    key: "renderTable",
    value: function renderTable() {
      var _this3 = this;

      var selection = this.props.deleteItems ? {
        onSelectionChange: function onSelectionChange(obj) {
          _this3.setState({
            selectedIds: obj.map(function (item) {
              return item.id;
            }).filter(function (id) {
              return Boolean(id);
            })
          });
        }
      } : undefined;
      var actions = [{
        name: i18n.translate('kibana-react.tableListView.listing.table.editActionName', {
          defaultMessage: 'Edit'
        }),
        description: i18n.translate('kibana-react.tableListView.listing.table.editActionDescription', {
          defaultMessage: 'Edit'
        }),
        icon: 'pencil',
        type: 'icon',
        onClick: this.props.editItem
      }];
      var search = {
        onChange: this.setFilter.bind(this),
        toolsLeft: this.renderToolsLeft(),
        defaultQuery: this.state.filter,
        box: {
          incremental: true
        }
      };
      var columns = this.props.tableColumns.slice();

      if (this.props.editItem) {
        columns.push({
          name: i18n.translate('kibana-react.tableListView.listing.table.actionTitle', {
            defaultMessage: 'Actions'
          }),
          width: '100px',
          actions: actions
        });
      }

      var noItemsMessage = /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "kibana-react.tableListView.listing.noMatchedItemsMessage",
        defaultMessage: "No {entityNamePlural} matched your search.",
        values: {
          entityNamePlural: this.props.entityNamePlural
        }
      });
      return /*#__PURE__*/React.createElement(EuiInMemoryTable, {
        itemId: "id",
        items: this.state.items,
        columns: columns // EuiBasicTableColumn is stricter than Column
        ,
        pagination: this.pagination,
        loading: this.state.isFetchingItems,
        message: noItemsMessage,
        selection: selection,
        search: search,
        sorting: true,
        "data-test-subj": "itemsInMemTable"
      });
    }
  }, {
    key: "renderListingOrEmptyState",
    value: function renderListingOrEmptyState() {
      if (!this.state.fetchError && this.hasNoItems()) {
        return this.renderNoItemsMessage();
      }

      return this.renderListing();
    }
  }, {
    key: "renderListing",
    value: function renderListing() {
      var createButton;

      if (this.props.createItem) {
        createButton = /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement(EuiButton, {
          onClick: this.props.createItem,
          "data-test-subj": "newItemButton",
          iconType: "plusInCircle",
          fill: true
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "kibana-react.tableListView.listing.createNewItemButtonLabel",
          defaultMessage: "Create {entityName}",
          values: {
            entityName: this.props.entityName
          }
        })));
      }

      return /*#__PURE__*/React.createElement("div", null, this.state.showDeleteModal && this.renderConfirmDeleteModal(), /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "spaceBetween",
        alignItems: "flexEnd",
        "data-test-subj": "top-nav"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiTitle, {
        size: "l"
      }, /*#__PURE__*/React.createElement("h1", {
        id: this.props.headingId
      }, this.props.tableListTitle))), createButton), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "m"
      }), this.renderListingLimitWarning(), this.renderFetchError(), this.renderTable());
    }
  }, {
    key: "renderPageContent",
    value: function renderPageContent() {
      if (!this.state.hasInitialFetchReturned) {
        return;
      }

      return /*#__PURE__*/React.createElement(EuiPageContent, {
        horizontalPosition: "center"
      }, this.renderListingOrEmptyState());
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(EuiPage, {
        "data-test-subj": this.props.entityName + 'LandingPage',
        className: "itemListing__page",
        restrictWidth: true
      }, /*#__PURE__*/React.createElement(EuiPageBody, {
        "aria-labelledby": this.state.hasInitialFetchReturned ? this.props.headingId : undefined
      }, this.renderPageContent()));
    }
  }]);

  return TableListView;
}(React.Component);

export { TableListView };