/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import { EuiSpacer, EuiTitle, EuiFlexGroup, EuiFlexItem, EuiText, EuiTextColor, EuiButtonEmpty } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
export var Header = function Header(_ref) {
  var onExportAll = _ref.onExportAll,
      onImport = _ref.onImport,
      onRefresh = _ref.onRefresh,
      filteredCount = _ref.filteredCount;
  return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "baseline"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiTitle, null, /*#__PURE__*/React.createElement("h1", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.savedObjectsTitle",
    defaultMessage: "Saved Objects"
  })))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    size: "s",
    iconType: "exportAction",
    "data-test-subj": "exportAllObjects",
    onClick: onExportAll
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.exportButtonLabel",
    defaultMessage: "Export {filteredCount, plural, one{# object} other {# objects}}",
    values: {
      filteredCount: filteredCount
    }
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    size: "s",
    iconType: "importAction",
    "data-test-subj": "importObjects",
    onClick: onImport
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.importButtonLabel",
    defaultMessage: "Import"
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    size: "s",
    iconType: "refresh",
    onClick: onRefresh
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.header.refreshButtonLabel",
    defaultMessage: "Refresh"
  })))))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiText, {
    size: "s"
  }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "savedObjectsManagement.objectsTable.howToDeleteSavedObjectsDescription",
    defaultMessage: "From here you can delete saved objects, such as saved searches. You can also edit the raw data of saved objects. Typically objects are only modified via their associated application, which is probably what you should use instead of this screen."
  })))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }));
};