function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { EuiTitle, EuiFlyout, EuiFlyoutBody, EuiFlyoutHeader, EuiLink, EuiIcon, EuiCallOut, EuiLoadingKibana, EuiInMemoryTable, EuiToolTip, EuiText, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { getDefaultTitle, getSavedObjectLabel } from '../../../lib';
export var Relationships = /*#__PURE__*/function (_Component) {
  _inherits(Relationships, _Component);

  var _super = _createSuper(Relationships);

  function Relationships(props) {
    var _this;

    _classCallCheck(this, Relationships);

    _this = _super.call(this, props);
    _this.state = {
      relationships: [],
      isLoading: false,
      error: undefined
    };
    return _this;
  }

  _createClass(Relationships, [{
    key: "UNSAFE_componentWillMount",
    value: function UNSAFE_componentWillMount() {
      this.getRelationshipData();
    }
  }, {
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      if (nextProps.savedObject.id !== this.props.savedObject.id) {
        this.getRelationshipData();
      }
    }
  }, {
    key: "getRelationshipData",
    value: function () {
      var _getRelationshipData = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var _this$props, savedObject, getRelationships, relationships;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this$props = this.props, savedObject = _this$props.savedObject, getRelationships = _this$props.getRelationships;
                this.setState({
                  isLoading: true
                });
                _context.prev = 2;
                _context.next = 5;
                return getRelationships(savedObject.type, savedObject.id);

              case 5:
                relationships = _context.sent;
                this.setState({
                  relationships: relationships,
                  isLoading: false,
                  error: undefined
                });
                _context.next = 12;
                break;

              case 9:
                _context.prev = 9;
                _context.t0 = _context["catch"](2);
                this.setState({
                  error: _context.t0.message,
                  isLoading: false
                });

              case 12:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[2, 9]]);
      }));

      function getRelationshipData() {
        return _getRelationshipData.apply(this, arguments);
      }

      return getRelationshipData;
    }()
  }, {
    key: "renderError",
    value: function renderError() {
      var error = this.state.error;

      if (!error) {
        return null;
      }

      return /*#__PURE__*/React.createElement(EuiCallOut, {
        title: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.relationships.renderErrorMessage",
          defaultMessage: "Error"
        }),
        color: "danger"
      }, error);
    }
  }, {
    key: "renderRelationships",
    value: function renderRelationships() {
      var _this2 = this;

      var _this$props2 = this.props,
          goInspectObject = _this$props2.goInspectObject,
          savedObject = _this$props2.savedObject,
          basePath = _this$props2.basePath;
      var _this$state = this.state,
          relationships = _this$state.relationships,
          isLoading = _this$state.isLoading,
          error = _this$state.error;

      if (error) {
        return this.renderError();
      }

      if (isLoading) {
        return /*#__PURE__*/React.createElement(EuiLoadingKibana, {
          size: "xl"
        });
      }

      var columns = [{
        field: 'type',
        name: i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTypeName', {
          defaultMessage: 'Type'
        }),
        width: '50px',
        align: 'center',
        description: i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTypeDescription', {
          defaultMessage: 'Type of the saved object'
        }),
        sortable: false,
        render: function render(type, object) {
          return /*#__PURE__*/React.createElement(EuiToolTip, {
            position: "top",
            content: getSavedObjectLabel(type)
          }, /*#__PURE__*/React.createElement(EuiIcon, {
            "aria-label": getSavedObjectLabel(type),
            type: object.meta.icon || 'apps',
            size: "s",
            "data-test-subj": "relationshipsObjectType"
          }));
        }
      }, {
        field: 'relationship',
        name: i18n.translate('savedObjectsManagement.objectsTable.relationships.columnRelationshipName', {
          defaultMessage: 'Direct relationship'
        }),
        dataType: 'string',
        sortable: false,
        width: '125px',
        'data-test-subj': 'directRelationship',
        render: function render(relationship) {
          if (relationship === 'parent') {
            return /*#__PURE__*/React.createElement(EuiText, {
              size: "s"
            }, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "savedObjectsManagement.objectsTable.relationships.columnRelationship.parentAsValue",
              defaultMessage: "Parent"
            }));
          }

          if (relationship === 'child') {
            return /*#__PURE__*/React.createElement(EuiText, {
              size: "s"
            }, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "savedObjectsManagement.objectsTable.relationships.columnRelationship.childAsValue",
              defaultMessage: "Child"
            }));
          }
        }
      }, {
        field: 'meta.title',
        name: i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTitleName', {
          defaultMessage: 'Title'
        }),
        description: i18n.translate('savedObjectsManagement.objectsTable.relationships.columnTitleDescription', {
          defaultMessage: 'Title of the saved object'
        }),
        dataType: 'string',
        sortable: false,
        render: function render(title, object) {
          var _ref = object.meta.inAppUrl || {},
              _ref$path = _ref.path,
              path = _ref$path === void 0 ? '' : _ref$path;

          var canGoInApp = _this2.props.canGoInApp(object);

          if (!canGoInApp) {
            return /*#__PURE__*/React.createElement(EuiText, {
              size: "s",
              "data-test-subj": "relationshipsTitle"
            }, title || getDefaultTitle(object));
          }

          return /*#__PURE__*/React.createElement(EuiLink, {
            href: basePath.prepend(path),
            "data-test-subj": "relationshipsTitle"
          }, title || getDefaultTitle(object));
        }
      }, {
        name: i18n.translate('savedObjectsManagement.objectsTable.relationships.columnActionsName', {
          defaultMessage: 'Actions'
        }),
        actions: [{
          name: i18n.translate('savedObjectsManagement.objectsTable.relationships.columnActions.inspectActionName', {
            defaultMessage: 'Inspect'
          }),
          description: i18n.translate('savedObjectsManagement.objectsTable.relationships.columnActions.inspectActionDescription', {
            defaultMessage: 'Inspect this saved object'
          }),
          type: 'icon',
          icon: 'inspect',
          'data-test-subj': 'relationshipsTableAction-inspect',
          onClick: function onClick(object) {
            return goInspectObject(object);
          },
          available: function available(object) {
            return !!object.meta.editUrl;
          }
        }]
      }];
      var filterTypesMap = new Map(relationships.map(function (relationship) {
        return [relationship.type, {
          value: relationship.type,
          name: relationship.type,
          view: relationship.type
        }];
      }));
      var search = {
        filters: [{
          type: 'field_value_selection',
          field: 'relationship',
          name: i18n.translate('savedObjectsManagement.objectsTable.relationships.search.filters.relationship.name', {
            defaultMessage: 'Direct relationship'
          }),
          multiSelect: 'or',
          options: [{
            value: 'parent',
            name: 'parent',
            view: i18n.translate('savedObjectsManagement.objectsTable.relationships.search.filters.relationship.parentAsValue.view', {
              defaultMessage: 'Parent'
            })
          }, {
            value: 'child',
            name: 'child',
            view: i18n.translate('savedObjectsManagement.objectsTable.relationships.search.filters.relationship.childAsValue.view', {
              defaultMessage: 'Child'
            })
          }]
        }, {
          type: 'field_value_selection',
          field: 'type',
          name: i18n.translate('savedObjectsManagement.objectsTable.relationships.search.filters.type.name', {
            defaultMessage: 'Type'
          }),
          multiSelect: 'or',
          options: _toConsumableArray(filterTypesMap.values())
        }]
      };
      return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiCallOut, null, /*#__PURE__*/React.createElement("p", null, i18n.translate('savedObjectsManagement.objectsTable.relationships.relationshipsTitle', {
        defaultMessage: 'Here are the saved objects related to {title}. ' + 'Deleting this {type} affects its parent objects, but not its children.',
        values: {
          type: savedObject.type,
          title: savedObject.meta.title || getDefaultTitle(savedObject)
        }
      }))), /*#__PURE__*/React.createElement(EuiSpacer, null), /*#__PURE__*/React.createElement(EuiInMemoryTable, {
        items: relationships,
        columns: columns,
        pagination: true,
        search: search,
        rowProps: function rowProps() {
          return {
            'data-test-subj': "relationshipsTableRow"
          };
        }
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          close = _this$props3.close,
          savedObject = _this$props3.savedObject;
      return /*#__PURE__*/React.createElement(EuiFlyout, {
        onClose: close
      }, /*#__PURE__*/React.createElement(EuiFlyoutHeader, {
        hasBorder: true
      }, /*#__PURE__*/React.createElement(EuiTitle, {
        size: "m"
      }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(EuiToolTip, {
        position: "top",
        content: getSavedObjectLabel(savedObject.type)
      }, /*#__PURE__*/React.createElement(EuiIcon, {
        "aria-label": getSavedObjectLabel(savedObject.type),
        size: "m",
        type: savedObject.meta.icon || 'apps'
      })), "\xA0\xA0", savedObject.meta.title || getDefaultTitle(savedObject)))), /*#__PURE__*/React.createElement(EuiFlyoutBody, null, this.renderRelationships()));
    }
  }]);

  return Relationships;
}(Component);