function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect } from 'react';
import { StringParamEditor } from './string';
import { search } from '../../../../data/public';
import { SimpleNumberList } from './components/simple_number_list';
var isNumberType = search.aggs.isNumberType;
export function IncludeExcludeParamEditor(props) {
  var agg = props.agg,
      value = props.value,
      setValue = props.setValue;
  var isAggOfNumberType = isNumberType(agg); // This useEffect converts value from string type to number and back when the field type is changed

  useEffect(function () {
    if (isAggOfNumberType && !Array.isArray(value) && value !== undefined) {
      var numberArray = value.split('|').map(function (item) {
        return parseFloat(item);
      }).filter(function (number) {
        return Number.isFinite(number);
      });
      setValue(numberArray.length ? numberArray : ['']);
    } else if (!isAggOfNumberType && Array.isArray(value) && value !== undefined) {
      setValue(value.filter(function (item) {
        return item !== '';
      }).join('|'));
    }
  }, [isAggOfNumberType, setValue, value]);
  return isAggOfNumberType ? /*#__PURE__*/React.createElement(SimpleNumberList, _extends({}, props, {
    value: value
  })) : /*#__PURE__*/React.createElement(StringParamEditor, _extends({}, props, {
    value: value
  }));
}