function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiFormRow } from '@elastic/eui';
import { FromToList } from './components/from_to_list';
import { MaskList } from './components/mask_list';
import { IpRangeTypes } from './ip_range_type';

function IpRangesParamEditor(_ref) {
  var agg = _ref.agg,
      _ref$value = _ref.value,
      value = _ref$value === void 0 ? {
    fromTo: [],
    mask: []
  } : _ref$value,
      setTouched = _ref.setTouched,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      showValidation = _ref.showValidation;
  var handleMaskListChange = useCallback(function (items) {
    return setValue(_objectSpread(_objectSpread({}, value), {}, _defineProperty({}, IpRangeTypes.MASK, items)));
  }, [setValue, value]);
  var handleFromToListChange = useCallback(function (items) {
    return setValue(_objectSpread(_objectSpread({}, value), {}, _defineProperty({}, IpRangeTypes.FROM_TO, items)));
  }, [setValue, value]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    fullWidth: true,
    id: "visEditorIpRange".concat(agg.id),
    compressed: true
  }, agg.params.ipRangeType === IpRangeTypes.MASK ? /*#__PURE__*/React.createElement(MaskList, {
    list: value.mask,
    showValidation: showValidation,
    onBlur: setTouched,
    onChange: handleMaskListChange,
    setValidity: setValidity
  }) : /*#__PURE__*/React.createElement(FromToList, {
    list: value.fromTo,
    showValidation: showValidation,
    onBlur: setTouched,
    onChange: handleFromToListChange,
    setValidity: setValidity
  }));
}

export { IpRangesParamEditor };