/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadNameManager;
import com.intellij.diagnostic.startUpPerformanceReporter.ExposingCharArrayWriter;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeaFormatWriter;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeaFormatWriterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.IdeaFormatWriterKt$sam$java_util_Comparator$0;
import com.intellij.diagnostic.startUpPerformanceReporter.MyJsonPrettyPrinter;
import com.intellij.diagnostic.startUpPerformanceReporter.ServiceReporterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporter;
import com.intellij.diagnostic.startUpPerformanceReporter.StartUpPerformanceReporterKt;
import com.intellij.diagnostic.startUpPerformanceReporter.TraceEventFormatWriter;
import com.intellij.openapi.util.SystemInfo;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Closeable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b \u0018\u00002\u00020\u0001B'\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004H\u0014J\u0006\u0010\u0015\u001a\u00020\u0016JT\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0004JL\u0010\u001f\u001a\u00020\u00102\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a2\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00042\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060$2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010)\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0014J(\u0010*\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0014J\u0018\u0010-\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010.\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0004H\u0014J2\u0010/\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0006\u0010 \u001a\u00020\u0013H\u0002J(\u00100\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u00101\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0014R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/diagnostic/startUpPerformanceReporter/IdeaFormatWriter;", "", "activities", "", "", "", "Lcom/intellij/diagnostic/ActivityImpl;", "threadNameManager", "Lcom/intellij/diagnostic/ThreadNameManager;", "(Ljava/util/Map;Lcom/intellij/diagnostic/ThreadNameManager;)V", "logPrefix", "stringWriter", "Lcom/intellij/diagnostic/startUpPerformanceReporter/ExposingCharArrayWriter;", "getStringWriter", "()Lcom/intellij/diagnostic/startUpPerformanceReporter/ExposingCharArrayWriter;", "beforeActivityWrite", "", "item", "ownOrTotalDuration", "", "fieldName", "toByteBuffer", "Ljava/nio/ByteBuffer;", "write", "timeOffset", "items", "", "serviceActivities", "instantEvents", "end", "projectName", "writeActivities", "startTime", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "ownDurations", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "measureThreshold", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "writeAppInfo", "writeExtraData", "writeItemTimeInfo", "duration", "offset", "writeParallelActivities", "writeProjectName", "writeServiceEvents", "writeTotalDuration", "totalDuration", "intellij.platform.diagnostic"})
public abstract class IdeaFormatWriter {
    private final String logPrefix = "=== Start: StartUp Measurement ===\n";
    @NotNull
    private final ExposingCharArrayWriter stringWriter;
    private final Map<String, List<ActivityImpl>> activities;
    private final ThreadNameManager threadNameManager;

    @NotNull
    protected final ExposingCharArrayWriter getStringWriter() {
        return this.stringWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(long timeOffset, @NotNull List<ActivityImpl> items, @NotNull Map<String, ? extends List<ActivityImpl>> serviceActivities, @NotNull List<ActivityImpl> instantEvents, long end, @NotNull String projectName) {
        JsonGenerator writer;
        Intrinsics.checkParameterIsNotNull(items, (String)"items");
        Intrinsics.checkParameterIsNotNull(serviceActivities, (String)"serviceActivities");
        Intrinsics.checkParameterIsNotNull(instantEvents, (String)"instantEvents");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        this.stringWriter.write(this.logPrefix);
        JsonGenerator jsonGenerator = writer = new JsonFactory().createGenerator((Writer)this.stringWriter);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonGenerator, (String)"writer");
        jsonGenerator.setPrettyPrinter((PrettyPrinter)new MyJsonPrettyPrinter());
        Closeable closeable = (Closeable)writer;
        boolean bl = false;
        Throwable throwable = null;
        try {
            void $this$array$iv;
            void $this$array$iv2;
            JsonGenerator it = (JsonGenerator)closeable;
            boolean bl2 = false;
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl3 = false;
            writer.writeStringField("version", "22");
            this.writeAppInfo(writer);
            writer.writeStringField("generated", ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
            writer.writeStringField("os", SystemInfo.getOsNameAndVersion());
            writer.writeStringField("runtime", SystemInfo.JAVA_VENDOR + " " + SystemInfo.JAVA_VERSION + " " + SystemInfo.JAVA_RUNTIME_VERSION);
            this.writeProjectName(writer, projectName);
            this.writeExtraData(writer);
            JsonGenerator jsonGenerator2 = writer;
            String fieldName$iv2 = "traceEvents";
            boolean $i$f$array = false;
            String string = fieldName$iv2;
            boolean bl4 = false;
            boolean bl5 = false;
            String it$iv = string;
            boolean bl6 = false;
            $this$array$iv2.writeFieldName(it$iv);
            $this$array$iv2.writeStartArray();
            boolean bl7 = false;
            new TraceEventFormatWriter(timeOffset, instantEvents, this.threadNameManager).writeInstantEvents(writer);
            $this$array$iv2.writeEndArray();
            this.writeServiceEvents(writer, serviceActivities, timeOffset);
            long totalDuration = 0L;
            fieldName$iv2 = writer;
            String fieldName$iv3 = "items";
            boolean $i$f$array2 = false;
            String string2 = fieldName$iv3;
            bl5 = false;
            boolean bl8 = false;
            String it$iv2 = string2;
            $i$a$-let-JacksonKt$array$1$iv = false;
            $this$array$iv.writeFieldName(it$iv2);
            $this$array$iv.writeStartArray();
            boolean bl9 = false;
            boolean bl10 = false;
            for (ActivityImpl item : (Iterable)items) {
                void index;
                JsonGenerator $this$obj$iv2 = writer;
                String fieldName$iv4 = null;
                boolean $i$f$obj2 = false;
                $this$obj$iv2.writeStartObject();
                boolean bl11 = false;
                writer.writeStringField("name", item.getName());
                if (item.getDescription() != null) {
                    writer.writeStringField("description", item.getDescription());
                }
                long duration = item.getEnd() - item.getStart();
                if (!StartUpPerformanceReporterKt.isSubItem(item, (int)index, items)) {
                    totalDuration += duration;
                }
                this.writeItemTimeInfo(item, duration, timeOffset, writer);
                $this$obj$iv2.writeEndObject();
                ++index;
            }
            $this$array$iv.writeEndArray();
            this.writeParallelActivities(timeOffset, writer);
            this.writeTotalDuration(writer, totalDuration += end - ((ActivityImpl)CollectionsKt.last(items)).getEnd(), end, timeOffset);
            $this$obj$iv.writeEndObject();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    protected long writeTotalDuration(@NotNull JsonGenerator writer, long totalDuration, long end, long timeOffset) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.writeNumberField("totalDurationComputed", TimeUnit.NANOSECONDS.toMillis(totalDuration));
        long totalDurationActual = TimeUnit.NANOSECONDS.toMillis(end - timeOffset);
        writer.writeNumberField("totalDurationActual", totalDurationActual);
        return totalDurationActual;
    }

    protected void writeProjectName(@NotNull JsonGenerator writer, @NotNull String projectName) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        writer.writeStringField("project", projectName);
    }

    protected void writeExtraData(@NotNull JsonGenerator writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
    }

    protected void writeAppInfo(@NotNull JsonGenerator writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
    }

    private final void writeServiceEvents(JsonGenerator writer, Map<String, ? extends List<ActivityImpl>> serviceActivities, long startTime) {
        Object object = writeServiceEvents.comparator.1.INSTANCE;
        if (object != null) {
            Function2 function2 = object;
            object = new IdeaFormatWriterKt$sam$java_util_Comparator$0(function2);
        }
        Comparator comparator2 = (Comparator)object;
        for (String name : CollectionsKt.sorted((Iterable)serviceActivities.keySet())) {
            List list = CollectionsKt.sortedWith((Iterable)((Iterable)MapsKt.getValue(serviceActivities, (Object)name)), (Comparator)comparator2);
            Object2LongMap<ActivityImpl> ownDurations = ServiceReporterKt.computeOwnTime(list, this.threadNameManager);
            this.writeActivities(list, startTime, writer, name, ownDurations, 0L, TimeUnit.MICROSECONDS);
        }
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        return this.stringWriter.toByteBuffer(this.logPrefix.length());
    }

    private final void writeParallelActivities(long startTime, JsonGenerator writer) {
        for (String name : CollectionsKt.sorted((Iterable)this.activities.keySet())) {
            List list = (List)MapsKt.getValue(this.activities, (Object)name);
            StartUpPerformanceReporter.Companion.sortItems$intellij_platform_diagnostic(list);
            long measureThreshold = Intrinsics.areEqual((Object)name, (Object)ActivityCategory.APP_INIT.getJsonName()) || Intrinsics.areEqual((Object)name, (Object)ActivityCategory.REOPENING_EDITOR.getJsonName()) ? -1L : StartUpMeasurer.MEASURE_THRESHOLD;
            Object2LongOpenHashMap ownDurations = new Object2LongOpenHashMap();
            ownDurations.defaultReturnValue(-1L);
            this.writeActivities(list, startTime, writer, IdeaFormatWriterKt.access$activityNameToJsonFieldName(name), (Object2LongMap<ActivityImpl>)((Object2LongMap)ownDurations), measureThreshold, TimeUnit.MILLISECONDS);
        }
    }

    private final void writeActivities(List<ActivityImpl> activities, long startTime, JsonGenerator writer, String fieldName, Object2LongMap<ActivityImpl> ownDurations, long measureThreshold, TimeUnit timeUnit) {
        if (activities.isEmpty()) {
            return;
        }
        JsonGenerator $this$array$iv = writer;
        boolean $i$f$array = false;
        String string = fieldName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it$iv = string2;
            boolean bl3 = false;
            $this$array$iv.writeFieldName(it$iv);
        }
        $this$array$iv.writeStartArray();
        boolean bl = false;
        long skippedDuration = 0L;
        for (ActivityImpl item : activities) {
            long ownDuration = ownDurations.getLong((Object)item);
            long ownOrTotalDuration = ownDuration == -1L ? item.getEnd() - item.getStart() : ownDuration;
            this.beforeActivityWrite(item, ownOrTotalDuration, fieldName);
            if (ownOrTotalDuration <= measureThreshold) {
                skippedDuration += ownOrTotalDuration;
                continue;
            }
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl4 = false;
            String string3 = item.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"item.name");
            writer.writeStringField("n", IdeaFormatWriterKt.access$compactName(string3));
            writer.writeNumberField("s", timeUnit.convert(item.getStart() - startTime, TimeUnit.NANOSECONDS));
            writer.writeNumberField("d", timeUnit.convert(item.getEnd() - item.getStart(), TimeUnit.NANOSECONDS));
            if (ownDuration != -1L) {
                writer.writeNumberField("od", timeUnit.convert(ownDuration, TimeUnit.NANOSECONDS));
            }
            writer.writeStringField("t", this.threadNameManager.getThreadName(item));
            if (item.getPluginId() != null) {
                writer.writeStringField("p", item.getPluginId());
            }
            $this$obj$iv.writeEndObject();
        }
        if (skippedDuration > 0L) {
            JsonGenerator $this$obj$iv = writer;
            String fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj$iv.writeStartObject();
            boolean bl5 = false;
            writer.writeStringField("n", "Other");
            writer.writeNumberField("d", timeUnit.convert(skippedDuration, TimeUnit.NANOSECONDS));
            writer.writeNumberField("s", timeUnit.convert(((ActivityImpl)CollectionsKt.last(activities)).getStart() - startTime, TimeUnit.NANOSECONDS));
            $this$obj$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    protected void beforeActivityWrite(@NotNull ActivityImpl item, long ownOrTotalDuration, @NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
    }

    protected void writeItemTimeInfo(@NotNull ActivityImpl item, long duration, long offset, @NotNull JsonGenerator writer) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.writeNumberField("duration", TimeUnit.NANOSECONDS.toMillis(duration));
        writer.writeNumberField("start", TimeUnit.NANOSECONDS.toMillis(item.getStart() - offset));
        writer.writeNumberField("end", TimeUnit.NANOSECONDS.toMillis(item.getEnd() - offset));
        writer.writeStringField("thread", this.threadNameManager.getThreadName(item));
        if (item.getPluginId() != null) {
            writer.writeStringField("p", item.getPluginId());
        }
    }

    public IdeaFormatWriter(@NotNull Map<String, ? extends List<ActivityImpl>> activities, @NotNull ThreadNameManager threadNameManager) {
        Intrinsics.checkParameterIsNotNull(activities, (String)"activities");
        Intrinsics.checkParameterIsNotNull((Object)threadNameManager, (String)"threadNameManager");
        this.activities = activities;
        this.threadNameManager = threadNameManager;
        this.logPrefix = "=== Start: StartUp Measurement ===\n";
        this.stringWriter = new ExposingCharArrayWriter();
    }
}

