/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.EventLogSystemEvents;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomWhiteListRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.TestModeValidationRule;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistGroupRulesStorage;
import com.intellij.internal.statistic.eventLog.whitelist.WhitelistStorageProvider;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SensitiveDataValidator {
    private static final ConcurrentMap<String, SensitiveDataValidator> ourInstances = new ConcurrentHashMap<String, SensitiveDataValidator>();
    @NotNull
    protected final WhitelistGroupRulesStorage myWhiteListStorage;

    @NotNull
    public static SensitiveDataValidator getInstance(@NotNull String recorderId) {
        if (recorderId == null) {
            SensitiveDataValidator.$$$reportNull$$$0(0);
        }
        SensitiveDataValidator sensitiveDataValidator = ourInstances.computeIfAbsent(recorderId, id -> {
            WhitelistGroupRulesStorage whitelistStorage = WhitelistStorageProvider.newStorage(recorderId);
            return ApplicationManager.getApplication().isUnitTestMode() ? new BlindSensitiveDataValidator(whitelistStorage) : new SensitiveDataValidator(whitelistStorage);
        });
        if (sensitiveDataValidator == null) {
            SensitiveDataValidator.$$$reportNull$$$0(1);
        }
        return sensitiveDataValidator;
    }

    @Nullable
    public static SensitiveDataValidator getIfInitialized(@NotNull String recorderId) {
        if (recorderId == null) {
            SensitiveDataValidator.$$$reportNull$$$0(2);
        }
        return (SensitiveDataValidator)ourInstances.get(recorderId);
    }

    protected SensitiveDataValidator(@NotNull WhitelistGroupRulesStorage storage) {
        if (storage == null) {
            SensitiveDataValidator.$$$reportNull$$$0(3);
        }
        this.myWhiteListStorage = storage;
    }

    public WhitelistGroupRulesStorage getWhiteListStorage() {
        return this.myWhiteListStorage;
    }

    public String guaranteeCorrectEventId(@NotNull EventLogGroup group, @NotNull EventContext context) {
        if (group == null) {
            SensitiveDataValidator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            SensitiveDataValidator.$$$reportNull$$$0(5);
        }
        if (this.myWhiteListStorage.isUnreachableWhitelist()) {
            return ValidationResultType.UNREACHABLE_METADATA.getDescription();
        }
        if (EventLogSystemEvents.SYSTEM_EVENTS.contains(context.eventId)) {
            return context.eventId;
        }
        ValidationResultType validationResultType = this.validateEvent(group, context);
        return validationResultType == ValidationResultType.ACCEPTED ? context.eventId : validationResultType.getDescription();
    }

    public Map<String, Object> guaranteeCorrectEventData(@NotNull EventLogGroup group, @NotNull EventContext context) {
        boolean containsPluginInfo;
        EventGroupRules groupRules;
        if (group == null) {
            SensitiveDataValidator.$$$reportNull$$$0(6);
        }
        if (context == null) {
            SensitiveDataValidator.$$$reportNull$$$0(7);
        }
        if (SensitiveDataValidator.isTestModeEnabled(groupRules = this.myWhiteListStorage.getGroupRules(group.getId()))) {
            return context.eventData;
        }
        ConcurrentHashMap<String, Object> validatedData = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : context.eventData.entrySet()) {
            String key = entry.getKey();
            Object entryValue = entry.getValue();
            validatedData.put(key, this.validateEventData(context, groupRules, key, entryValue));
        }
        boolean bl = containsPluginInfo = validatedData.containsKey("plugin") || validatedData.containsKey("plugin_type") || validatedData.containsKey("plugin_version");
        if (context.pluginInfo != null && !containsPluginInfo) {
            StatisticsUtilKt.addPluginInfoTo(context.pluginInfo, validatedData);
        }
        return validatedData;
    }

    private static boolean isTestModeEnabled(@Nullable EventGroupRules rule) {
        return TestModeValidationRule.isTestModeEnabled() && rule != null && Arrays.stream(rule.getEventIdRules()).anyMatch(r -> r instanceof TestModeValidationRule);
    }

    public ValidationResultType validateEvent(@NotNull EventLogGroup group, @NotNull EventContext context) {
        EventGroupRules groupRules;
        if (group == null) {
            SensitiveDataValidator.$$$reportNull$$$0(8);
        }
        if (context == null) {
            SensitiveDataValidator.$$$reportNull$$$0(9);
        }
        if ((groupRules = this.myWhiteListStorage.getGroupRules(group.getId())) == null || !groupRules.areEventIdRulesDefined()) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        return groupRules.validateEventId(context);
    }

    private Object validateEventData(@NotNull EventContext context, @Nullable EventGroupRules groupRules, @NotNull String key, @NotNull Object entryValue) {
        if (context == null) {
            SensitiveDataValidator.$$$reportNull$$$0(10);
        }
        if (key == null) {
            SensitiveDataValidator.$$$reportNull$$$0(11);
        }
        if (entryValue == null) {
            SensitiveDataValidator.$$$reportNull$$$0(12);
        }
        if (this.myWhiteListStorage.isUnreachableWhitelist()) {
            return ValidationResultType.UNREACHABLE_METADATA;
        }
        if (groupRules == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        return groupRules.validateEventData(key, entryValue, context);
    }

    public void update() {
        this.myWhiteListStorage.update();
    }

    public void reload() {
        this.myWhiteListStorage.reload();
    }

    static {
        CustomValidationRule.EP_NAME.addChangeListener(ourInstances::clear, null);
        CustomWhiteListRule.EP_NAME.addChangeListener(ourInstances::clear, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIfInitialized";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "guaranteeCorrectEventId";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "guaranteeCorrectEventData";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateEvent";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validateEventData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BlindSensitiveDataValidator
    extends SensitiveDataValidator {
        protected BlindSensitiveDataValidator(@NotNull WhitelistGroupRulesStorage whiteListStorage) {
            if (whiteListStorage == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(0);
            }
            super(whiteListStorage);
        }

        @Override
        public String guaranteeCorrectEventId(@NotNull EventLogGroup group, @NotNull EventContext context) {
            if (group == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(1);
            }
            if (context == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(2);
            }
            return context.eventId;
        }

        @Override
        public Map<String, Object> guaranteeCorrectEventData(@NotNull EventLogGroup group, @NotNull EventContext context) {
            if (group == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(3);
            }
            if (context == null) {
                BlindSensitiveDataValidator.$$$reportNull$$$0(4);
            }
            return context.eventData;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "whiteListStorage";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator$BlindSensitiveDataValidator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guaranteeCorrectEventId";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "guaranteeCorrectEventData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

