/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "gitRemote", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;)V", "getGitRemote", "()Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "getRepository", "()Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "intellij.vcs.github"})
public final class GHGitRepositoryMapping {
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private final GitRemoteUrlCoordinates gitRemote;
    public static final Companion Companion = new Companion(null);

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHGitRepositoryMapping)) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.repository, (Object)((GHGitRepositoryMapping)other).repository) ^ true);
    }

    public int hashCode() {
        return this.repository.hashCode();
    }

    @NotNull
    public String toString() {
        return "(repository=" + this.repository + ", remote=" + this.gitRemote + ')';
    }

    @NotNull
    public final GHRepositoryCoordinates getRepository() {
        return this.repository;
    }

    @NotNull
    public final GitRemoteUrlCoordinates getGitRemote() {
        return this.gitRemote;
    }

    public GHGitRepositoryMapping(@NotNull GHRepositoryCoordinates repository, @NotNull GitRemoteUrlCoordinates gitRemote) {
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)gitRemote, (String)"gitRemote");
        this.repository = repository;
        this.gitRemote = gitRemote;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping$Companion;", "", "()V", "create", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "remote", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "intellij.vcs.github"})
    public static final class Companion {
        @Nullable
        public final GHGitRepositoryMapping create(@NotNull GithubServerPath server, @NotNull GitRemoteUrlCoordinates remote) {
            Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
            Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
            GHRepositoryPath gHRepositoryPath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(remote.getUrl());
            if (gHRepositoryPath == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)gHRepositoryPath, (String)"GithubUrlUtil.getUserAnd\u2026emote.url) ?: return null");
            GHRepositoryPath repositoryPath = gHRepositoryPath;
            GHRepositoryCoordinates repository = new GHRepositoryCoordinates(server, repositoryPath);
            return new GHGitRepositoryMapping(repository, remote);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

