/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.translate;

import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.MultiInputFormat;
import com.thaiopensource.relaxng.input.dtd.DtdInputFormat;
import com.thaiopensource.relaxng.input.parse.compact.CompactParseInputFormat;
import com.thaiopensource.relaxng.input.parse.sax.SAXParseInputFormat;
import com.thaiopensource.relaxng.input.xml.XmlInputFormat;
import com.thaiopensource.relaxng.output.LocalOutputDirectory;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.OutputFailedException;
import com.thaiopensource.relaxng.output.OutputFormat;
import com.thaiopensource.relaxng.output.dtd.DtdOutputFormat;
import com.thaiopensource.relaxng.output.rnc.RncOutputFormat;
import com.thaiopensource.relaxng.output.rng.RngOutputFormat;
import com.thaiopensource.relaxng.output.xsd.XsdOutputFormat;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.UriOrFile;
import com.thaiopensource.util.Version;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class Driver {
    private static final Localizer localizer = new Localizer(class$com$thaiopensource$relaxng$translate$Driver == null ? (class$com$thaiopensource$relaxng$translate$Driver = Driver.class$("com.thaiopensource.relaxng.translate.Driver")) : class$com$thaiopensource$relaxng$translate$Driver);
    private String inputType;
    private String outputType;
    private final ErrorHandlerImpl eh = new ErrorHandlerImpl();
    private static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";
    private static final int DEFAULT_LINE_LENGTH = 72;
    private static final int DEFAULT_INDENT = 2;
    static /* synthetic */ Class class$com$thaiopensource$relaxng$translate$Driver;

    public static void main(String[] stringArray) {
        System.exit(new Driver().doMain(stringArray));
    }

    private int doMain(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        try {
            SchemaCollection schemaCollection;
            Object object;
            OutputFormat outputFormat;
            InputFormat inputFormat;
            OptionParser optionParser = new OptionParser("I:O:i:o:", stringArray);
            try {
                while (optionParser.moveToNextOption()) {
                    switch (optionParser.getOptionChar()) {
                        case 'I': {
                            this.inputType = optionParser.getOptionArg();
                            break;
                        }
                        case 'O': {
                            this.outputType = optionParser.getOptionArg();
                            break;
                        }
                        case 'i': {
                            vector.add(optionParser.getOptionArg());
                            break;
                        }
                        case 'o': {
                            vector2.add(optionParser.getOptionArg());
                        }
                    }
                }
            }
            catch (OptionParser.InvalidOptionException invalidOptionException) {
                this.error(localizer.message("invalid_option", (Object)optionParser.getOptionCharString()));
                return 2;
            }
            catch (OptionParser.MissingArgumentException missingArgumentException) {
                this.error(localizer.message("option_missing_argument", (Object)optionParser.getOptionCharString()));
                return 2;
            }
            stringArray = optionParser.getRemainingArgs();
            if (stringArray.length < 2) {
                this.error(localizer.message("too_few_arguments"));
                this.eh.print(localizer.message("usage", (Object)Version.getVersion((Class)(class$com$thaiopensource$relaxng$translate$Driver == null ? (class$com$thaiopensource$relaxng$translate$Driver = Driver.class$("com.thaiopensource.relaxng.translate.Driver")) : class$com$thaiopensource$relaxng$translate$Driver))));
                return 2;
            }
            if (this.inputType == null) {
                this.inputType = Driver.extension(stringArray[0]);
                if (this.inputType.length() > 0) {
                    this.inputType = this.inputType.substring(1);
                }
            }
            if (this.inputType.equalsIgnoreCase("rng")) {
                inputFormat = new SAXParseInputFormat();
            } else if (this.inputType.equalsIgnoreCase("rnc")) {
                inputFormat = new CompactParseInputFormat();
            } else if (this.inputType.equalsIgnoreCase("dtd")) {
                inputFormat = new DtdInputFormat();
            } else if (this.inputType.equalsIgnoreCase("xml")) {
                inputFormat = new XmlInputFormat();
            } else {
                this.error(localizer.message("unrecognized_input_type", (Object)this.inputType));
                return 2;
            }
            String string = Driver.extension(stringArray[stringArray.length - 1]);
            if (this.outputType == null) {
                this.outputType = string;
                if (this.outputType.length() > 0) {
                    this.outputType = this.outputType.substring(1);
                }
            }
            if (this.outputType.equalsIgnoreCase("dtd")) {
                outputFormat = new DtdOutputFormat();
            } else if (this.outputType.equalsIgnoreCase("rng")) {
                outputFormat = new RngOutputFormat();
            } else if (this.outputType.equalsIgnoreCase("xsd")) {
                outputFormat = new XsdOutputFormat();
            } else if (this.outputType.equalsIgnoreCase("rnc")) {
                outputFormat = new RncOutputFormat();
            } else {
                this.error(localizer.message("unrecognized_output_type", (Object)this.outputType));
                return 2;
            }
            String[] stringArray2 = vector.toArray(new String[0]);
            this.outputType = this.outputType.toLowerCase();
            if (stringArray.length > 2) {
                if (!(inputFormat instanceof MultiInputFormat)) {
                    this.error(localizer.message("too_many_arguments"));
                    return 2;
                }
                object = new String[stringArray.length - 1];
                int n = 0;
                while (n < ((String[])object).length) {
                    object[n] = UriOrFile.toUri((String)stringArray[n]);
                    ++n;
                }
                schemaCollection = ((MultiInputFormat)inputFormat).load((String[])object, stringArray2, this.outputType, (ErrorHandler)this.eh);
            } else {
                schemaCollection = inputFormat.load(UriOrFile.toUri((String)stringArray[0]), stringArray2, this.outputType, (ErrorHandler)this.eh);
            }
            if (string.length() == 0) {
                string = this.outputType;
            }
            object = new LocalOutputDirectory(schemaCollection.getMainUri(), new File(stringArray[stringArray.length - 1]), string, DEFAULT_OUTPUT_ENCODING, 72, 2);
            outputFormat.output(schemaCollection, (OutputDirectory)object, vector2.toArray(new String[0]), this.inputType.toLowerCase(), (ErrorHandler)this.eh);
            return 0;
        }
        catch (OutputFailedException outputFailedException) {
        }
        catch (InputFailedException inputFailedException) {
        }
        catch (InvalidParamsException invalidParamsException) {
        }
        catch (IOException iOException) {
            this.eh.printException((Throwable)iOException);
        }
        catch (SAXException sAXException) {
            this.eh.printException((Throwable)sAXException);
        }
        return 1;
    }

    private void error(String string) {
        this.eh.printException((Throwable)new SAXException(string));
    }

    private static String extension(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        return string.substring(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

