/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.serviceContainer;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.serviceContainer.BaseComponentAdapter;
import com.intellij.serviceContainer.ComponentManagerImpl;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.serviceContainer.ConstructorParameterResolverKt;
import com.intellij.util.pico.DefaultPicoContainer;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J2\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002JJ\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0011JD\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/serviceContainer/ConstructorParameterResolver;", "", "()V", "findTargetAdapter", "Lorg/picocontainer/ComponentAdapter;", "componentManager", "Lcom/intellij/serviceContainer/ComponentManagerImpl;", "expectedType", "Ljava/lang/Class;", "requestorKey", "requestorClass", "requestorConstructor", "Ljava/lang/reflect/Constructor;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "handleUnsatisfiedDependency", "isResolvable", "", "isExtensionSupported", "resolveInstance", "intellij.platform.serviceContainer"})
public final class ConstructorParameterResolver {
    public final boolean isResolvable(@NotNull ComponentManagerImpl componentManager, @NotNull Object requestorKey, @NotNull Class<?> requestorClass, @NotNull Constructor<?> requestorConstructor, @NotNull Class<?> expectedType, @NotNull PluginId pluginId, boolean isExtensionSupported) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)componentManager), (String)"componentManager");
        Intrinsics.checkParameterIsNotNull((Object)requestorKey, (String)"requestorKey");
        Intrinsics.checkParameterIsNotNull(requestorClass, (String)"requestorClass");
        Intrinsics.checkParameterIsNotNull(requestorConstructor, (String)"requestorConstructor");
        Intrinsics.checkParameterIsNotNull(expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)pluginId, (String)"pluginId");
        if (ComponentManagerImpl.Companion.isLightService(expectedType) || expectedType == ComponentManager.class || this.findTargetAdapter(componentManager, expectedType, requestorKey, requestorClass, requestorConstructor, pluginId) != null) {
            return true;
        }
        return isExtensionSupported && componentManager.getExtensionArea().findExtensionByClass(expectedType) != null;
    }

    @Nullable
    public final Object resolveInstance(@NotNull ComponentManagerImpl componentManager, @NotNull Object requestorKey, @NotNull Class<?> requestorClass, @NotNull Constructor<?> requestorConstructor, @NotNull Class<?> expectedType, @NotNull PluginId pluginId) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)componentManager), (String)"componentManager");
        Intrinsics.checkParameterIsNotNull((Object)requestorKey, (String)"requestorKey");
        Intrinsics.checkParameterIsNotNull(requestorClass, (String)"requestorClass");
        Intrinsics.checkParameterIsNotNull(requestorConstructor, (String)"requestorConstructor");
        Intrinsics.checkParameterIsNotNull(expectedType, (String)"expectedType");
        Intrinsics.checkParameterIsNotNull((Object)pluginId, (String)"pluginId");
        if (expectedType == ComponentManager.class) {
            return componentManager;
        }
        if (ComponentManagerImpl.Companion.isLightService(expectedType)) {
            return componentManager.getLightService$intellij_platform_serviceContainer(expectedType, true);
        }
        ComponentAdapter componentAdapter = this.findTargetAdapter(componentManager, expectedType, requestorKey, requestorClass, requestorConstructor, pluginId);
        if (componentAdapter == null) {
            return this.handleUnsatisfiedDependency(componentManager, requestorClass, expectedType, pluginId);
        }
        ComponentAdapter adapter = componentAdapter;
        return adapter instanceof BaseComponentAdapter ? BaseComponentAdapter.getInstance$default((BaseComponentAdapter)adapter, ((BaseComponentAdapter)adapter).getComponentManager$intellij_platform_serviceContainer(), null, false, null, 12, null) : (componentManager.getParent$intellij_platform_serviceContainer() == null ? adapter.getComponentInstance((PicoContainer)componentManager.getPicoContainer$intellij_platform_serviceContainer()) : componentManager.getPicoContainer$intellij_platform_serviceContainer().getComponentInstance(adapter.getComponentKey()));
    }

    private final Object handleUnsatisfiedDependency(ComponentManagerImpl componentManager, Class<?> requestorClass, Class<?> expectedType, PluginId pluginId) {
        Object object = componentManager.getExtensionArea().findExtensionByClass(expectedType);
        if (object == null) {
            return null;
        }
        Object extension = object;
        String message = "Do not use constructor injection to get extension instance (requestorClass=" + requestorClass.getName() + ", extensionClass=" + expectedType.getName() + ')';
        Application app = componentManager.getApplication$intellij_platform_serviceContainer();
        if (app != null && app.isUnitTestMode() && Intrinsics.areEqual((Object)pluginId.getIdString(), (Object)"org.jetbrains.kotlin") ^ true && Intrinsics.areEqual((Object)pluginId.getIdString(), (Object)"Lombook Plugin") ^ true) {
            throw (Throwable)new PluginException(message, pluginId);
        }
        ComponentManagerImplKt.getLOG().warn(message);
        return extension;
    }

    /*
     * WARNING - void declaration
     */
    private final ComponentAdapter findTargetAdapter(ComponentManagerImpl componentManager, Class<?> expectedType, Object requestorKey, Class<?> requestorClass, Constructor<?> requestorConstructor, PluginId pluginId) {
        ComponentAdapter componentAdapter;
        DefaultPicoContainer container = componentManager.getPicoContainer$intellij_platform_serviceContainer();
        ComponentAdapter byKey = container.getComponentAdapter(expectedType);
        if (byKey != null && Intrinsics.areEqual((Object)requestorKey, (Object)byKey.getComponentKey()) ^ true) {
            return byKey;
        }
        String className = expectedType.getName();
        if (container.getParent() == null ? Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.project.Project") || ConstructorParameterResolverKt.access$getBadAppLevelClasses$p().contains(className) : Intrinsics.areEqual((Object)className, (Object)"com.intellij.configurationStore.StreamProvider") || Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl") || Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.roots.impl.CompilerModuleExtensionImpl") || Intrinsics.areEqual((Object)className, (Object)"com.intellij.openapi.roots.impl.JavaModuleExternalPathsImpl")) {
            return null;
        }
        if (componentManager.isGetComponentAdapterOfTypeCheckEnabled$intellij_platform_serviceContainer()) {
            ComponentManagerImplKt.getLOG().error((Throwable)new PluginException("getComponentAdapterOfType is used to get " + expectedType.getName() + " (requestorClass=" + requestorClass.getName() + ", requestorConstructor=" + requestorConstructor + ")." + "\n\nProbably constructor should be marked as NonInjectable.", pluginId));
        }
        List list = container.getComponentAdaptersOfType(expectedType);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"container.getComponentAdaptersOfType(expectedType)");
        List result = list;
        result.removeIf((Predicate)new Predicate<ComponentAdapter>(requestorKey){
            final /* synthetic */ Object $requestorKey;

            public final boolean test(ComponentAdapter it) {
                ComponentAdapter componentAdapter = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)componentAdapter, (String)"it");
                return Intrinsics.areEqual((Object)componentAdapter.getComponentKey(), (Object)this.$requestorKey);
            }
            {
                this.$requestorKey = object;
            }
        });
        switch (result.size()) {
            case 0: {
                DefaultPicoContainer defaultPicoContainer = container.getParent();
                if (defaultPicoContainer != null) {
                    componentAdapter = defaultPicoContainer.getComponentAdapterOfType(expectedType);
                    break;
                }
                componentAdapter = null;
                break;
            }
            case 1: {
                componentAdapter = (ComponentAdapter)result.get(0);
                break;
            }
            default: {
                Object[] objectArray;
                int n = result.size();
                Class<?> clazz = expectedType;
                Object[] objectArray2 = new Class[n];
                int n2 = 0;
                while (n2 < n) {
                    void it;
                    int n3 = n2;
                    int n4 = n2++;
                    objectArray = objectArray2;
                    boolean bl = false;
                    Object e = result.get((int)it);
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"result[it]");
                    Class clazz2 = ((ComponentAdapter)e).getComponentImplementation();
                    objectArray[n4] = clazz2;
                }
                Object[] objectArray3 = objectArray = objectArray2;
                Class<?> clazz3 = clazz;
                throw (Throwable)new AmbiguousComponentResolutionException(clazz3, objectArray3);
            }
        }
        return componentAdapter;
    }
}

